/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.FieldValue;
import org.llorllale.youtrack.api.HttpRequestWithEntity;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.UncheckedUriBuilder;
import org.llorllale.youtrack.api.UpdateIssue;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

class DefaultUpdateIssue
implements UpdateIssue {
    private static final String PATH_TEMPLATE = "/issue/%s";
    private final Issue issue;
    private final Session session;

    DefaultUpdateIssue(Issue issue, Session session) {
        this.issue = issue;
        this.session = session;
    }

    @Override
    public Issue summary(String summary) throws IOException, UnauthorizedException {
        return this.updateSmmryDesc(summary, this.issue.description().orElse(null));
    }

    @Override
    public Issue description(String description) throws IOException, UnauthorizedException {
        return this.updateSmmryDesc(this.issue.summary(), description);
    }

    @Override
    public Issue summaryAndDesc(String summary, String description) throws IOException, UnauthorizedException {
        return this.updateSmmryDesc(summary, description);
    }

    @Override
    public Issue field(Field field, FieldValue value) throws IOException, UnauthorizedException {
        HashMap<Field, FieldValue> fields = new HashMap<Field, FieldValue>();
        fields.put(field, value);
        return this.fields(fields);
    }

    @Override
    public Issue fields(Map<Field, FieldValue> fields) throws IOException, UnauthorizedException {
        String separator = " ";
        new HttpResponseAsResponse((HttpResponse)HttpClients.createDefault().execute((HttpUriRequest)new HttpRequestWithSession(this.session, new HttpRequestWithEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("command", fields.entrySet().stream().map(e -> String.join((CharSequence)" ", ((Field)e.getKey()).name(), ((FieldValue)e.getValue()).asString())).collect(Collectors.joining(" ")))), StandardCharsets.UTF_8), (HttpEntityEnclosingRequestBase)new HttpPost(this.session.baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.issue.id())).concat("/execute")))))).httpResponse();
        return this.issue.refresh();
    }

    private Issue updateSmmryDesc(String summary, String description) throws IOException, UnauthorizedException {
        new HttpResponseAsResponse((HttpResponse)HttpClients.createDefault().execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpEntityEnclosingRequestBase)new HttpPost(new UncheckedUriBuilder(this.session.baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.issue.id()))).param("summary", summary).paramIfPresent("description", Optional.ofNullable(description)).build())))).httpResponse();
        return this.issue.refresh();
    }
}

