/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.llorllale.youtrack.api.Counter;
import org.llorllale.youtrack.api.ExceptionalFunction;
import org.llorllale.youtrack.api.Page;
import org.llorllale.youtrack.api.PageUri;
import org.llorllale.youtrack.api.Response;

final class Pagination<T>
implements Iterator<T> {
    private final PageUri pageRequest;
    private final ExceptionalFunction<Response, Collection<T>, IOException> mapper;
    private final HttpClient httpClient;
    private Iterator<T> page;

    Pagination(PageUri pageRequest, ExceptionalFunction<Response, Collection<T>, IOException> mapper, HttpClient httpClient) {
        this.pageRequest = pageRequest;
        this.mapper = mapper;
        this.page = new Page.Empty();
        this.httpClient = httpClient;
    }

    Pagination(int pageSize, Function<Integer, HttpUriRequest> combiner, ExceptionalFunction<Response, Collection<T>, IOException> mapper, HttpClient httpClient) {
        this(new PageUri(new Counter(0, pageSize), combiner), mapper, httpClient);
    }

    @Override
    public boolean hasNext() {
        if (!this.page.hasNext()) {
            this.page = new Page<T>(this.pageRequest.get(), this.mapper, this.httpClient);
        }
        return this.page.hasNext();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.page.next();
        }
        throw new NoSuchElementException();
    }
}

