/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;

final class UncheckedUriBuilder {
    private final URIBuilder builder;

    UncheckedUriBuilder(String baseUrl) {
        try {
            this.builder = new URIBuilder(baseUrl);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("This should not have happened: syntax issue with URL: %s", baseUrl), e);
        }
    }

    UncheckedUriBuilder(URL baseUrl, String path) {
        try {
            this.builder = new URIBuilder(new URI(baseUrl.getProtocol(), null, baseUrl.getHost(), baseUrl.getPort(), baseUrl.getPath().concat(path), null, null));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("This should not have happened: syntax issue baseUrl=%s path=%s", baseUrl.toString(), path), e);
        }
    }

    public UncheckedUriBuilder param(String name, String value) {
        this.builder.setParameter(name, value);
        return this;
    }

    public UncheckedUriBuilder paramIfPresent(String name, Optional<String> value) {
        value.ifPresent(v -> this.param(name, (String)v));
        return this;
    }

    public URI build() {
        try {
            return this.builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("This should not have happened: syntax issue with a URL", e);
        }
    }
}

