/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.Projects;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlProject;
import org.llorllale.youtrack.api.XmlsOf;
import org.llorllale.youtrack.api.YouTrack;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class DefaultProjects
implements Projects {
    private final YouTrack youtrack;
    private final Session session;
    private final HttpClient httpClient;

    DefaultProjects(YouTrack youtrack, Session session, HttpClient httpClient) {
        this.youtrack = youtrack;
        this.session = session;
        this.httpClient = httpClient;
    }

    DefaultProjects(YouTrack youtrack, Session session) {
        this(youtrack, session, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public Stream<Project> stream() throws IOException, UnauthorizedException {
        return new StreamOf<Project>(new MappedCollection<Xml, Project>(xml -> new XmlProject(this.youtrack, this.session, (Xml)xml), new XmlsOf("/projects/project", new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat("/project/all"))))))));
    }

    @Override
    public Optional<Project> get(String id) throws IOException, UnauthorizedException {
        return new MappedCollection<Xml, Project>(xml -> new XmlProject(this.youtrack, this.session, (Xml)xml), new XmlsOf("/project", new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat("/admin/project/").concat(id))))))).stream().findAny();
    }
}

