/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.User;
import org.llorllale.youtrack.api.UsersOfProject;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlUser;
import org.llorllale.youtrack.api.XmlsOf;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class XmlUsersOfProject
implements UsersOfProject {
    private final Project project;
    private final Session session;
    private final Xml xml;
    private final HttpClient httpClient;

    XmlUsersOfProject(Project project, Session session, Xml xml, HttpClient httpClient) {
        this.project = project;
        this.session = session;
        this.xml = xml;
        this.httpClient = httpClient;
    }

    XmlUsersOfProject(Project project, Session session, Xml xml) {
        this(project, session, xml, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public User user(String login) throws IOException, UnauthorizedException {
        return new XmlUser((Xml)new XmlsOf("/user", new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat("/user/").concat(login)))))).stream().findAny().get());
    }

    @Override
    public Stream<User> assignees() throws IOException, UnauthorizedException {
        return new StreamOf<User>(new MappedCollection(() -> x -> this.user(x.textOf("@value").get()), this.xml.children("//assigneesLogin/sub")));
    }
}

