/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.FieldValue;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.ProjectField;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.SubstringAfterLast;
import org.llorllale.youtrack.api.UncheckedUriBuilder;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlFieldValue;
import org.llorllale.youtrack.api.XmlsOf;
import org.llorllale.youtrack.api.session.Session;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class XmlProjectField
implements ProjectField {
    private final Xml xml;
    private final Project project;
    private final Session session;
    private final HttpClient httpClient;

    XmlProjectField(Xml xml, Project project, Session session) {
        this.xml = xml;
        this.project = project;
        this.session = session;
        this.httpClient = HttpClients.createDefault();
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public String name() {
        return this.xml.textOf("@name").get();
    }

    @Override
    public Stream<FieldValue> values() throws IOException, UnauthorizedException {
        String bundleName = ((Xml)new XmlsOf("/projectCustomField/param", new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(this.session.baseUrl().toString().concat("/admin/project/").concat(this.project().id()).concat("/customfield/").concat(new SubstringAfterLast(this.xml.textOf("@url").get(), "/").get())))))).stream().findAny().get()).textOf("@value").get();
        return new StreamOf<FieldValue>(new MappedCollection<Xml, FieldValue>(x -> new XmlFieldValue((Xml)x, new XmlProjectField(this.xml, this.project, this.session)), new XmlsOf("/enumeration/value", new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.session, (HttpRequestBase)new HttpGet(new UncheckedUriBuilder(this.session.baseUrl(), "/admin/customfield/bundle/".concat(bundleName)).build())))))));
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field)obj;
        return this.isSameField(other);
    }
}

