/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.util.Optional;
import org.llorllale.youtrack.api.DefaultFields;
import org.llorllale.youtrack.api.DefaultIssues;
import org.llorllale.youtrack.api.DefaultProjectTimeTracking;
import org.llorllale.youtrack.api.Fields;
import org.llorllale.youtrack.api.Issues;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.ProjectTimeTracking;
import org.llorllale.youtrack.api.UsersOfProject;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlUsersOfProject;
import org.llorllale.youtrack.api.YouTrack;
import org.llorllale.youtrack.api.session.Session;

final class XmlProject
implements Project {
    private final YouTrack youtrack;
    private final Session session;
    private final Xml xml;

    XmlProject(YouTrack youtrack, Session session, Xml xml) {
        this.youtrack = youtrack;
        this.session = session;
        this.xml = xml;
    }

    @Override
    public String id() {
        return this.xml.textOf("(@id | @shortName)[last()]").get();
    }

    @Override
    public String name() {
        return this.xml.textOf("@name").get();
    }

    @Override
    public Optional<String> description() {
        return this.xml.textOf("@description");
    }

    @Override
    public Issues issues() {
        return new DefaultIssues(this, this.session);
    }

    @Override
    public YouTrack youtrack() {
        return this.youtrack;
    }

    @Override
    public Fields fields() {
        return new DefaultFields(this.session, this);
    }

    @Override
    public ProjectTimeTracking timetracking() {
        return new DefaultProjectTimeTracking(this, this.session);
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        return this.id().equals(other.id());
    }

    @Override
    public UsersOfProject users() {
        return new XmlUsersOfProject(this, this.session, this.xml);
    }
}

