/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.llorllale.youtrack.api.InputStreamAsString;
import org.llorllale.youtrack.api.Response;
import org.llorllale.youtrack.api.StringAsDocument;
import org.llorllale.youtrack.api.UncheckedException;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlsOf;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class XmlOf
implements Xml {
    private final Node xml;

    XmlOf(Node xml) {
        this.xml = xml;
    }

    XmlOf(Document document) {
        this(document.getDocumentElement());
    }

    XmlOf(Response response) throws UncheckedException, IOException {
        this(new StringAsDocument(new InputStreamAsString().apply(response.httpResponse().getEntity().getContent())).getDocumentElement());
    }

    XmlOf(String xml) throws UncheckedException {
        this(new StringAsDocument(xml));
    }

    @Override
    public Optional<String> textOf(String xpath) throws UncheckedException {
        return this.child(xpath).map(x -> x.node().getTextContent());
    }

    @Override
    public Optional<Xml> child(String xpath) throws UncheckedException {
        return this.children(xpath).stream().findFirst();
    }

    @Override
    public Collection<Xml> children(String xpath) throws UncheckedException {
        try {
            return new XmlsOf((NodeList)XPathFactory.newInstance().newXPath().evaluate(xpath, this.node(), XPathConstants.NODESET));
        }
        catch (XPathExpressionException e) {
            throw new UncheckedException(e.getMessage(), e);
        }
    }

    @Override
    public Node node() {
        return this.xml;
    }
}

