/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.ProjectTimeTracking;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.TimeTrackEntryType;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlTimeTrackEntryType;
import org.llorllale.youtrack.api.XmlsOf;
import org.llorllale.youtrack.api.session.Login;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class DefaultProjectTimeTracking
implements ProjectTimeTracking {
    private static final String PATH_TEMPLATE = "/admin/project/%s/timetracking";
    private final Project project;
    private final Login login;
    private final HttpClient httpClient;

    DefaultProjectTimeTracking(Project project, Login login, HttpClient httpClient) {
        this.project = project;
        this.login = login;
        this.httpClient = httpClient;
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public boolean enabled() throws IOException, UnauthorizedException {
        Xml settings = (Xml)new XmlsOf("/settings", new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), (HttpRequestBase)new HttpGet(this.login.session().baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.project().id()))))))).stream().findAny().get();
        return Boolean.parseBoolean(settings.textOf("@enabled").get()) && settings.child("estimation").isPresent() && settings.child("spentTime").isPresent();
    }

    @Override
    public Stream<TimeTrackEntryType> types() throws IOException, UnauthorizedException {
        return new StreamOf<TimeTrackEntryType>(new MappedCollection<Xml, TimeTrackEntryType>(XmlTimeTrackEntryType::new, new XmlsOf("/workItemTypes/workType", new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), (HttpRequestBase)new HttpGet(this.login.session().baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.project().id())).concat("/worktype"))))))));
    }
}

