/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.util.Optional;
import org.apache.http.client.HttpClient;
import org.llorllale.youtrack.api.DefaultFields;
import org.llorllale.youtrack.api.DefaultIssues;
import org.llorllale.youtrack.api.DefaultProjectTimeTracking;
import org.llorllale.youtrack.api.Fields;
import org.llorllale.youtrack.api.Issues;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.ProjectTimeTracking;
import org.llorllale.youtrack.api.UsersOfProject;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlUsersOfProject;
import org.llorllale.youtrack.api.YouTrack;
import org.llorllale.youtrack.api.session.Login;

final class XmlProject
implements Project {
    private final YouTrack youtrack;
    private final Login login;
    private final Xml xml;
    private final HttpClient client;

    XmlProject(YouTrack youtrack, Login login, Xml xml, HttpClient client) {
        this.youtrack = youtrack;
        this.login = login;
        this.xml = xml;
        this.client = client;
    }

    @Override
    public String id() {
        return this.xml.textOf("(@id | @shortName)[last()]").get();
    }

    @Override
    public String name() {
        return this.xml.textOf("@name").get();
    }

    @Override
    public Optional<String> description() {
        return this.xml.textOf("@description");
    }

    @Override
    public Issues issues() {
        return new DefaultIssues(this, this.login, this.client);
    }

    @Override
    public YouTrack youtrack() {
        return this.youtrack;
    }

    @Override
    public Fields fields() {
        return new DefaultFields(this.login, this, this.client);
    }

    @Override
    public ProjectTimeTracking timetracking() {
        return new DefaultProjectTimeTracking(this, this.login, this.client);
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        return this.id().equals(other.id());
    }

    @Override
    public UsersOfProject users() {
        return new XmlUsersOfProject(this, this.login, this.xml, this.client);
    }
}

