/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.llorllale.youtrack.api.Comment;
import org.llorllale.youtrack.api.Comments;
import org.llorllale.youtrack.api.HttpRequestWithEntity;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlComment;
import org.llorllale.youtrack.api.XmlsOf;
import org.llorllale.youtrack.api.session.Login;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class DefaultComments
implements Comments {
    private static final String BASE_PATH = "/issue/";
    private final Login login;
    private final Issue issue;
    private final Supplier<HttpClient> httpClient;

    DefaultComments(Login login, Issue issue, Supplier<HttpClient> httpClient) {
        this.login = login;
        this.issue = issue;
        this.httpClient = httpClient;
    }

    @Override
    public Stream<Comment> stream() throws IOException, UnauthorizedException {
        return new StreamOf<Comment>(new MappedCollection<Xml, Comment>(xml -> new XmlComment(this.issue(), this.login, (Xml)xml, this.httpClient), new XmlsOf("//comment", new HttpResponseAsResponse(this.httpClient.get().execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), (HttpRequestBase)new HttpGet(this.login.session().baseUrl().toString().concat(BASE_PATH).concat(this.issue().id()).concat("/comment"))))))));
    }

    @Override
    public Comments post(String text) throws IOException, UnauthorizedException {
        new HttpResponseAsResponse(this.httpClient.get().execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), new HttpRequestWithEntity((HttpEntity)new StringEntity("comment=".concat(text), ContentType.APPLICATION_FORM_URLENCODED), (HttpEntityEnclosingRequestBase)new HttpPost(this.login.session().baseUrl().toString().concat(BASE_PATH).concat(this.issue().id()).concat("/execute")))))).httpResponse();
        return new DefaultComments(this.login, this.issue(), this.httpClient);
    }

    @Override
    public Issue issue() {
        return this.issue;
    }
}

