/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.Projects;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlProject;
import org.llorllale.youtrack.api.XmlsOf;
import org.llorllale.youtrack.api.YouTrack;
import org.llorllale.youtrack.api.session.Login;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class DefaultProjects
implements Projects {
    private final YouTrack youtrack;
    private final Login login;
    private final Supplier<HttpClient> httpClient;

    DefaultProjects(YouTrack youtrack, Login login, Supplier<HttpClient> httpClient) {
        this.youtrack = youtrack;
        this.login = login;
        this.httpClient = httpClient;
    }

    @Override
    public Stream<Project> stream() throws IOException, UnauthorizedException {
        return new StreamOf<Project>(new MappedCollection<Xml, Project>(xml -> new XmlProject(this.youtrack, this.login, (Xml)xml, this.httpClient), new XmlsOf("/projects/project", new HttpResponseAsResponse(this.httpClient.get().execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), (HttpRequestBase)new HttpGet(this.login.session().baseUrl().toString().concat("/project/all"))))))));
    }

    @Override
    public Optional<Project> get(String id) throws IOException, UnauthorizedException {
        return new MappedCollection<Xml, Project>(xml -> new XmlProject(this.youtrack, this.login, (Xml)xml, this.httpClient), new XmlsOf("/project", new HttpResponseAsResponse(this.httpClient.get().execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), (HttpRequestBase)new HttpGet(this.login.session().baseUrl().toString().concat("/admin/project/").concat(id))))))).stream().findAny();
    }
}

