/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.llorllale.youtrack.api.ExceptionalFunction;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.Response;
import org.llorllale.youtrack.api.UncheckedException;

final class Page<T>
implements Iterator<T> {
    private final Deque<T> contents;

    Page(HttpUriRequest request, ExceptionalFunction<Response, Collection<T>, IOException> mapper, Supplier<HttpClient> httpClient) throws UncheckedException {
        try {
            this.contents = new ArrayDeque<T>(mapper.apply(new HttpResponseAsResponse(httpClient.get().execute(request))));
        }
        catch (IOException e) {
            throw new UncheckedException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.contents.isEmpty();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.contents.pop();
        }
        throw new NoSuchElementException();
    }

    static final class Empty<T>
    implements Iterator<T> {
        Empty() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }
    }
}

