/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.llorllale.youtrack.api.Attachment;
import org.llorllale.youtrack.api.Attachments;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.User;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.session.Login;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class XmlAttachment
implements Attachment {
    private final Xml fileUrl;
    private final Issue issue;
    private final Login login;
    private final Supplier<HttpClient> client;

    XmlAttachment(Xml fileUrl, Issue issue, Login login, Supplier<HttpClient> client) {
        this.fileUrl = fileUrl;
        this.issue = issue;
        this.login = login;
        this.client = client;
    }

    @Override
    public String name() {
        return this.fileUrl.textOf("@name").get();
    }

    @Override
    public User creator() throws IOException, UnauthorizedException {
        return this.issue.project().users().user(this.fileUrl.textOf("@authorLogin").get());
    }

    @Override
    public InputStream contents() throws IOException {
        return new HttpResponseAsResponse(this.client.get().execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), (HttpRequestBase)new HttpGet(this.fileUrl.textOf("@url").get())))).httpResponse().getEntity().getContent();
    }

    @Override
    public Attachments delete() throws IOException, UnauthorizedException {
        new HttpResponseAsResponse(this.client.get().execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), (HttpRequestBase)new HttpDelete(this.login.session().baseUrl().toString().concat(String.format("/issue/%s/attachment/%s", this.issue.id(), this.fileUrl.textOf("@id").get())))))).httpResponse();
        return this.issue.attachments();
    }
}

