/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.Field;
import org.llorllale.youtrack.api.FieldValue;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.Issues;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Pagination;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.Response;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.SubstringAfterLast;
import org.llorllale.youtrack.api.UncheckedIoFunction;
import org.llorllale.youtrack.api.UncheckedUriBuilder;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlIssue;
import org.llorllale.youtrack.api.XmlOf;
import org.llorllale.youtrack.api.XmlsOf;
import org.llorllale.youtrack.api.session.Login;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class DefaultIssues
implements Issues {
    private final Project project;
    private final Login login;
    private final HttpClient httpClient;

    DefaultIssues(Project project, Login login, HttpClient httpClient) {
        this.project = project;
        this.login = login;
        this.httpClient = httpClient;
    }

    DefaultIssues(Project project, Login login) {
        this(project, login, (HttpClient)HttpClients.createDefault());
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public Stream<Issue> stream() throws IOException, UnauthorizedException {
        int pageSize = 10;
        return new StreamOf<Issue>(new Pagination(10, new UncheckedIoFunction<Integer, HttpUriRequest>(n -> new HttpRequestWithSession(this.login.session(), (HttpRequestBase)new HttpGet(new UncheckedUriBuilder(this.login.session().baseUrl().toString().concat("/issue/byproject/").concat(this.project().id())).param("after", String.valueOf(n)).build()))), resp -> new MappedCollection<Xml, Issue>(new UncheckedIoFunction<Xml, Issue>(xml -> new XmlIssue(this.project(), this.login, (Xml)xml)), new XmlsOf("/issues/issue", (Response)resp)), this.httpClient));
    }

    @Override
    public Optional<Issue> get(String issueId) throws IOException, UnauthorizedException {
        return Optional.of(new XmlOf(new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), (HttpRequestBase)new HttpGet(this.login.session().baseUrl().toString().concat("/issue/").concat(issueId))))))).filter(x -> !x.child("//error").isPresent()).map(new UncheckedIoFunction<XmlOf, XmlIssue>(x -> new XmlIssue(this.project(), this.login, (Xml)x)));
    }

    @Override
    public Issue create(String summary, String description) throws IOException, UnauthorizedException {
        return this.create(summary, description, Collections.emptyMap());
    }

    @Override
    public Issue create(String summary, String description, Map<Field, FieldValue> fields) throws IOException, UnauthorizedException {
        return this.get(new SubstringAfterLast(new HttpResponseAsResponse(this.httpClient.execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), (HttpEntityEnclosingRequestBase)new HttpPut(new UncheckedUriBuilder(this.login.session().baseUrl().toString().concat("/issue")).param("project", this.project().id()).param("summary", summary).paramIfPresent("description", Optional.ofNullable(description)).build())))).httpResponse().getFirstHeader("Location").getValue(), "/").get()).get().update().fields(fields);
    }
}

