/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.llorllale.youtrack.api.Authenticated;
import org.llorllale.youtrack.api.Fields;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.ProjectField;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.UncheckedIoFunction;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlProjectField;
import org.llorllale.youtrack.api.XmlsOf;
import org.llorllale.youtrack.api.session.Login;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class DefaultFields
implements Fields {
    private final Login login;
    private final Project project;
    private final Supplier<CloseableHttpClient> httpClient;

    DefaultFields(Login session, Project project, Supplier<CloseableHttpClient> httpClient) {
        this.login = session;
        this.project = project;
        this.httpClient = httpClient;
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public Stream<ProjectField> stream() throws IOException, UnauthorizedException {
        return new StreamOf<ProjectField>(new MappedCollection<Xml, ProjectField>(new UncheckedIoFunction<Xml, ProjectField>(x -> new XmlProjectField((Xml)x, this.project(), this.login, this.httpClient)), new XmlsOf("/projectCustomFieldRefs/projectCustomField", new HttpResponseAsResponse(this.httpClient.get().execute((HttpUriRequest)new Authenticated(this.login.session(), (HttpRequestBase)new HttpGet(this.login.session().baseUrl().toString().concat("/admin/project/").concat(this.project().id()).concat("/customfield"))))))));
    }
}

