/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.llorllale.youtrack.api.Authenticated;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.Project;
import org.llorllale.youtrack.api.Projects;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.SubstringAfterLast;
import org.llorllale.youtrack.api.UncheckedUriBuilder;
import org.llorllale.youtrack.api.User;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlProject;
import org.llorllale.youtrack.api.XmlsOf;
import org.llorllale.youtrack.api.YouTrack;
import org.llorllale.youtrack.api.session.Login;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class DefaultProjects
implements Projects {
    private static final String PROJECT_PATH = "/admin/project/";
    private final YouTrack youtrack;
    private final Login login;
    private final Supplier<CloseableHttpClient> httpClient;

    DefaultProjects(YouTrack youtrack, Login login, Supplier<CloseableHttpClient> httpClient) {
        this.youtrack = youtrack;
        this.login = login;
        this.httpClient = httpClient;
    }

    @Override
    public Stream<Project> stream() throws IOException, UnauthorizedException {
        return new StreamOf<Project>(new MappedCollection<Xml, Project>(xml -> new XmlProject(this.youtrack, this.login, (Xml)xml, this.httpClient), new XmlsOf("/projects/project", new HttpResponseAsResponse(this.httpClient.get().execute((HttpUriRequest)new Authenticated(this.login.session(), (HttpRequestBase)new HttpGet(this.login.session().baseUrl().toString().concat("/project/all"))))))));
    }

    @Override
    public Optional<Project> get(String id) throws IOException, UnauthorizedException {
        return new MappedCollection<Xml, Project>(xml -> new XmlProject(this.youtrack, this.login, (Xml)xml, this.httpClient), new XmlsOf("/project", new HttpResponseAsResponse(this.httpClient.get().execute((HttpUriRequest)new Authenticated(this.login.session(), (HttpRequestBase)new HttpGet(this.login.session().baseUrl().toString().concat(PROJECT_PATH).concat(id))))))).stream().findAny();
    }

    @Override
    public Project create(String id, String name, User leader) throws IOException, UnauthorizedException {
        return this.get(new SubstringAfterLast(new HttpResponseAsResponse(this.httpClient.get().execute((HttpUriRequest)new Authenticated(this.login.session(), (HttpEntityEnclosingRequestBase)new HttpPut(new UncheckedUriBuilder(this.login.session().baseUrl().toString().concat(PROJECT_PATH).concat(id)).param("projectName", name).param("startingNumber", "1").param("projectLeadLogin", leader.loginName()).build())))).httpResponse().getFirstHeader("Location").getValue(), "/").get()).get();
    }
}

