/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.time.Instant;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.llorllale.youtrack.api.Authenticated;
import org.llorllale.youtrack.api.Comment;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.Loaded;
import org.llorllale.youtrack.api.UncheckedUriBuilder;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.session.Login;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class XmlComment
implements Comment {
    private static final String PATH_TEMPLATE = "/issue/%s/comment/%s";
    private final Issue issue;
    private final Login login;
    private final Xml xml;
    private final Supplier<CloseableHttpClient> http;

    XmlComment(Issue issue, Login login, Xml xml, Supplier<CloseableHttpClient> client) {
        this.issue = issue;
        this.login = login;
        this.xml = xml;
        this.http = client;
    }

    @Override
    public Issue issue() {
        return this.issue;
    }

    @Override
    public String id() {
        return this.xml.textOf("//@id").get();
    }

    @Override
    public Instant creationDate() {
        return Instant.ofEpochMilli(Long.parseLong(this.xml.textOf("//@created").get()));
    }

    @Override
    public String text() {
        return this.xml.textOf("//@text").get();
    }

    @Override
    public Comment update(String txt) throws IOException, UnauthorizedException {
        new HttpResponseAsResponse(this.http.get().execute((HttpUriRequest)new Authenticated(this.login.session(), new Loaded((HttpEntity)new StringEntity(String.format("{\"text\": \"%s\"}", txt), ContentType.APPLICATION_JSON), (HttpEntityEnclosingRequestBase)new HttpPut(new UncheckedUriBuilder(this.login.session().baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.issue().id(), this.id()))).build()))))).httpResponse();
        return new XmlComment(this.issue, this.login, this.xml, this.http);
    }

    @Override
    public Issue delete() throws IOException, UnauthorizedException {
        new HttpResponseAsResponse(this.http.get().execute((HttpUriRequest)new Authenticated(this.login.session(), (HttpRequestBase)new HttpDelete(this.login.session().baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.issue().id(), this.id())))))).httpResponse();
        return this.issue();
    }
}

