/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.time.Instant;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.llorllale.youtrack.api.Comment;
import org.llorllale.youtrack.api.HttpRequestWithEntity;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.UncheckedException;
import org.llorllale.youtrack.api.UncheckedUriBuilder;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.session.Login;
import org.llorllale.youtrack.api.session.UnauthorizedException;

final class XmlComment
implements Comment {
    private static final String PATH_TEMPLATE = "/issue/%s/comment/%s";
    private final String id;
    private final long creationDate;
    private final String text;
    private final Issue issue;
    private final Login login;

    XmlComment(String id, long creationDate, String text, Issue issue, Login login) {
        this.id = id;
        this.creationDate = creationDate;
        this.text = text;
        this.issue = issue;
        this.login = login;
    }

    XmlComment(Issue issue, Login login, Xml xml) throws UncheckedException {
        this(xml.textOf("//@id").get(), Long.parseLong(xml.textOf("//@created").get()), xml.textOf("//@text").get(), issue, login);
    }

    @Override
    public Issue issue() {
        return this.issue;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Instant creationDate() {
        return Instant.ofEpochMilli(this.creationDate);
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public Comment update(String txt) throws IOException, UnauthorizedException {
        new HttpResponseAsResponse((HttpResponse)HttpClients.createDefault().execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), new HttpRequestWithEntity((HttpEntity)new StringEntity(String.format("{\"text\": \"%s\"}", txt), ContentType.APPLICATION_JSON), (HttpEntityEnclosingRequestBase)new HttpPut(new UncheckedUriBuilder(this.login.session().baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.issue().id(), this.id()))).build()))))).httpResponse();
        return new XmlComment(this.id, this.creationDate, txt, this.issue(), this.login);
    }

    @Override
    public Issue delete() throws IOException, UnauthorizedException {
        new HttpResponseAsResponse((HttpResponse)HttpClients.createDefault().execute((HttpUriRequest)new HttpRequestWithSession(this.login.session(), (HttpRequestBase)new HttpDelete(this.login.session().baseUrl().toString().concat(String.format(PATH_TEMPLATE, this.issue().id(), this.id())))))).httpResponse();
        return this.issue();
    }
}

