/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.llorllale.youtrack.api.ExceptionalFunction;

final class MappedCollection<I, O>
extends AbstractCollection<O> {
    private final Collection<O> output = new ArrayList<O>();

    MappedCollection(Function<I, O> mappingFunction, Collection<I> collection) {
        collection.forEach(item -> this.output.add(mappingFunction.apply(item)));
    }

    MappedCollection(Supplier<ExceptionalFunction<I, O, IOException>> function, Collection<I> collection) throws IOException {
        for (I i : collection) {
            this.output.add(function.get().apply(i));
        }
    }

    @Override
    public Iterator<O> iterator() {
        return this.output.iterator();
    }

    @Override
    public int size() {
        return this.output.size();
    }
}

