/*
 * Decompiled with CFR 0.152.
 */
package org.llorllale.youtrack.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.UUID;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.llorllale.youtrack.api.Attachment;
import org.llorllale.youtrack.api.Attachments;
import org.llorllale.youtrack.api.HttpRequestWithEntity;
import org.llorllale.youtrack.api.HttpRequestWithSession;
import org.llorllale.youtrack.api.HttpResponseAsResponse;
import org.llorllale.youtrack.api.Issue;
import org.llorllale.youtrack.api.MappedCollection;
import org.llorllale.youtrack.api.StreamEnvelope;
import org.llorllale.youtrack.api.StreamOf;
import org.llorllale.youtrack.api.Xml;
import org.llorllale.youtrack.api.XmlAttachment;
import org.llorllale.youtrack.api.XmlsOf;
import org.llorllale.youtrack.api.session.Login;

final class DefaultAttachments
extends StreamEnvelope<Attachment>
implements Attachments {
    private static final String ATTACHMENTS_PATH = "/issue/%s/attachment";
    private final Issue issue;
    private final Login login;
    private final HttpClient client;

    DefaultAttachments(Issue issue, Login login, HttpClient client) {
        super(() -> {
            try {
                return new StreamOf(new MappedCollection<Xml, Attachment>(xml -> new XmlAttachment((Xml)xml, issue), new XmlsOf("/fileUrls/fileUrl", new HttpResponseAsResponse(client.execute((HttpUriRequest)new HttpRequestWithSession(login.session(), (HttpRequestBase)new HttpGet(login.session().baseUrl().toString().concat(String.format(ATTACHMENTS_PATH, issue.id())))))))));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        this.issue = issue;
        this.login = login;
        this.client = client;
    }

    @Override
    public Attachments create(String filename, String type, InputStream contents) throws IOException {
        new HttpResponseAsResponse(this.client.execute((HttpUriRequest)new HttpRequestWithEntity(MultipartEntityBuilder.create().setBoundary(UUID.randomUUID().toString()).addBinaryBody(filename, contents, ContentType.create((String)type), filename).build(), new HttpRequestWithSession(this.login.session(), (HttpEntityEnclosingRequestBase)new HttpPost(this.login.session().baseUrl().toString().concat(String.format(ATTACHMENTS_PATH, this.issue.id()))))))).httpResponse();
        return new DefaultAttachments(this.issue, this.login, this.client);
    }
}

