/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javafx.scene.input.KeyCode;

public class KeyCodeUtils {
    private static final Map<Character, KeyCode> KEY_CODES = ImmutableMap.builder().put((Object)Character.valueOf(','), (Object)KeyCode.COMMA).put((Object)Character.valueOf(';'), (Object)KeyCode.SEMICOLON).put((Object)Character.valueOf('.'), (Object)KeyCode.PERIOD).put((Object)Character.valueOf(':'), (Object)KeyCode.COLON).put((Object)Character.valueOf('_'), (Object)KeyCode.UNDERSCORE).put((Object)Character.valueOf('!'), (Object)KeyCode.EXCLAMATION_MARK).put((Object)Character.valueOf('\"'), (Object)KeyCode.QUOTEDBL).put((Object)Character.valueOf('#'), (Object)KeyCode.POUND).put((Object)Character.valueOf('&'), (Object)KeyCode.AMPERSAND).put((Object)Character.valueOf('/'), (Object)KeyCode.SLASH).put((Object)Character.valueOf('('), (Object)KeyCode.LEFT_PARENTHESIS).put((Object)Character.valueOf(')'), (Object)KeyCode.RIGHT_PARENTHESIS).put((Object)Character.valueOf('='), (Object)KeyCode.EQUALS).build();

    static KeyCode findKeyCode(char character) {
        if (KEY_CODES.containsKey(Character.valueOf(character))) {
            return KEY_CODES.get(Character.valueOf(character));
        }
        KeyCode keyCode = KeyCode.getKeyCode((String)String.valueOf(Character.toUpperCase(character)));
        if (keyCode != null) {
            return keyCode;
        }
        for (KeyCode code : KeyCode.values()) {
            if ((char)code.impl_getCode() != character) continue;
            return code;
        }
        throw new IllegalArgumentException("No KeyCode found for character: " + character);
    }
}

