/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx;

import com.google.common.collect.ImmutableMap;
import java.awt.AWTException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.util.Duration;
import org.loadui.testfx.FXTestUtils;
import org.loadui.testfx.ScreenController;

public class FXScreenController
implements ScreenController {
    private static final Map<MouseButton, Integer> BUTTONS = ImmutableMap.of((Object)MouseButton.PRIMARY, (Object)16, (Object)MouseButton.MIDDLE, (Object)8, (Object)MouseButton.SECONDARY, (Object)4);
    private final DoubleProperty mouseXProperty = new SimpleDoubleProperty();
    private final DoubleProperty mouseYProperty = new SimpleDoubleProperty();
    private final Robot robot;
    private long moveTime = 175L;

    public FXScreenController() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            throw new IllegalArgumentException(e);
        }
        ChangeListener<Number> mouseChangeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> value, Number oldNum, Number newNum) {
                FXScreenController.this.robot.mouseMove(FXScreenController.this.mouseXProperty.intValue(), FXScreenController.this.mouseYProperty.intValue());
            }
        };
        this.mouseXProperty.addListener((ChangeListener)mouseChangeListener);
        this.mouseYProperty.addListener((ChangeListener)mouseChangeListener);
    }

    @Override
    public Point2D getMouse() {
        return new Point2D(this.mouseXProperty.doubleValue(), this.mouseYProperty.doubleValue());
    }

    @Override
    public void position(double x, double y) {
        this.mouseXProperty.set(x);
        this.mouseYProperty.set(y);
    }

    @Override
    public void move(final double x, final double y) {
        Point currentMousePosition = MouseInfo.getPointerInfo().getLocation();
        this.mouseXProperty.set(currentMousePosition.getX());
        this.mouseYProperty.set(currentMousePosition.getY());
        final CountDownLatch done = new CountDownLatch(1);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                new Timeline(new KeyFrame[]{new KeyFrame(new Duration((double)FXScreenController.this.moveTime), (EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent arg0) {
                        done.countDown();
                    }
                }, new KeyValue[]{new KeyValue((WritableValue)FXScreenController.this.mouseXProperty, (Object)x, Interpolator.EASE_BOTH), new KeyValue((WritableValue)FXScreenController.this.mouseYProperty, (Object)y, Interpolator.EASE_BOTH)})}).playFromStart();
            }
        });
        try {
            done.await();
            FXTestUtils.awaitEvents();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void press(MouseButton button) {
        if (button == null) {
            return;
        }
        this.robot.mousePress(BUTTONS.get(button));
        FXTestUtils.awaitEvents();
    }

    @Override
    public void release(MouseButton button) {
        if (button == null) {
            return;
        }
        this.robot.mouseRelease(BUTTONS.get(button));
        FXTestUtils.awaitEvents();
    }

    @Override
    public void press(KeyCode key) {
        this.robot.keyPress(key.impl_getCode());
        FXTestUtils.awaitEvents();
    }

    @Override
    public void release(KeyCode key) {
        this.robot.keyRelease(key.impl_getCode());
        FXTestUtils.awaitEvents();
    }

    @Override
    public void scroll(int amount) {
        this.robot.mouseWheel(amount);
        FXTestUtils.awaitEvents();
    }
}

