/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.stage.Stage;
import org.junit.Assert;
import org.loadui.testfx.GuiTest;

public class FXTestUtils {
    public static void bringToFront(final Stage stage) throws Exception {
        FXTestUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                stage.toBack();
                stage.toFront();
            }
        }, 5);
        Thread.sleep(250L);
    }

    public static void awaitEvents() {
        try {
            for (int i = 0; i < 5; ++i) {
                final Semaphore sem = new Semaphore(0);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        sem.release();
                    }
                });
                sem.acquire();
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void invokeAndWait(final Callable<?> task, int timeoutInSeconds) throws Exception {
        final SettableFuture future = SettableFuture.create();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    task.call();
                    future.set(null);
                }
                catch (Throwable e) {
                    future.setException(e);
                }
            }
        });
        try {
            future.get((long)timeoutInSeconds, TimeUnit.SECONDS);
            FXTestUtils.awaitEvents();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    public static void invokeAndWait(final Runnable task, int timeoutInSeconds) throws Exception {
        FXTestUtils.invokeAndWait(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                task.run();
                return null;
            }
        }, timeoutInSeconds);
    }

    public static void launchApp(final Class<? extends Application> appClass, final String ... args) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Application.launch((Class)appClass, (String[])args);
            }
        }).start();
    }

    public static void printGraph(Node root) {
        FXTestUtils.printGraph(root, "");
    }

    public static void failIfExists(String selector) {
        try {
            GuiTest.find(selector);
            Assert.fail((String)("Selector shouldn't have found anything: " + selector));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T extends Node> T getOrFail(String selector) {
        try {
            return GuiTest.find(selector);
        }
        catch (Exception e) {
            Assert.fail((String)("Cannot find anything with selector: " + selector));
            return null;
        }
    }

    private static void printGraph(Node root, String indent) {
        System.out.println(indent + root);
        if (root instanceof Parent) {
            indent = indent + "  ";
            for (Node child : ((Parent)root).getChildrenUnmodifiable()) {
                FXTestUtils.printGraph(child, indent);
            }
        }
    }
}

