/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.SettableFuture;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.VerticalDirection;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneBuilder;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.loadui.testfx.FXScreenController;
import org.loadui.testfx.MouseMotion;
import org.loadui.testfx.ScreenController;
import org.loadui.testfx.controls.Commons;
import org.loadui.testfx.exceptions.NoNodesFoundException;
import org.loadui.testfx.exceptions.NoNodesVisibleException;
import org.loadui.testfx.utils.FXTestUtils;
import org.loadui.testfx.utils.KeyCodeUtils;
import org.loadui.testfx.utils.TestUtils;

public abstract class GuiTest {
    private static final SettableFuture<Stage> stageFuture = SettableFuture.create();
    protected static Stage stage;
    private static Window lastSeenWindow;
    private final ScreenController controller;
    private final Set<MouseButton> pressedButtons = new HashSet<MouseButton>();
    private final Set<KeyCode> pressedKeys = new HashSet<KeyCode>();
    private Pos nodePosition = Pos.CENTER;

    @Before
    public void setupStage() throws Throwable {
        this.showNodeInStage();
    }

    protected abstract Parent getRootNode();

    private void showNodeInStage() {
        this.showNodeInStage(null);
    }

    private void showNodeInStage(final String stylesheet) {
        if (stage == null) {
            FXTestUtils.launchApp(TestFxApp.class, new String[0]);
            try {
                stage = (Stage)GuiTest.targetWindow((Window)stageFuture.get(25L, TimeUnit.SECONDS));
                FXTestUtils.bringToFront(stage);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to show stage", e);
            }
        }
        try {
            FXTestUtils.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Scene scene = SceneBuilder.create().width(600.0).height(400.0).root(GuiTest.this.getRootNode()).build();
                    if (stylesheet != null) {
                        scene.getStylesheets().add((Object)stylesheet);
                    }
                    stage.setScene(scene);
                }
            }, 5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T extends Window> T targetWindow(T window) {
        lastSeenWindow = window;
        return window;
    }

    public static OffsetTarget offset(Object target, double offsetX, double offsetY) {
        return new OffsetTarget(target, offsetX, offsetY);
    }

    public static List<Window> getWindows() {
        return Lists.reverse((List)Lists.newArrayList((Iterator)Window.impl_getWindows()));
    }

    public static Window getWindowByIndex(int index) {
        return GuiTest.getWindows().get(index);
    }

    public static Stage findStageByTitle(final String titleRegex) {
        return (Stage)Iterables.find((Iterable)Iterables.filter(GuiTest.getWindows(), Stage.class), (Predicate)new Predicate<Stage>(){

            public boolean apply(Stage input) {
                return input.getTitle().matches(titleRegex);
            }
        });
    }

    private static Set<Node> findAll(String query, Object parent) {
        try {
            if (parent instanceof String) {
                String titleRegex = (String)parent;
                return GuiTest.findAll(query, GuiTest.targetWindow(GuiTest.findStageByTitle(titleRegex)).getScene());
            }
            if (parent instanceof Node) {
                Node node = (Node)parent;
                GuiTest.targetWindow(node.getScene().getWindow());
                return GuiTest.findAllRecursively(query, node);
            }
            if (parent instanceof Scene) {
                Scene scene = (Scene)parent;
                GuiTest.targetWindow(scene.getWindow());
                return GuiTest.findAllRecursively(query, (Node)scene.getRoot());
            }
            if (parent instanceof Window) {
                return GuiTest.findAll(query, GuiTest.targetWindow((Window)parent).getScene());
            }
        }
        catch (NoNodesVisibleException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    private static Set<Node> findAllRecursively(String query, Node node) {
        Set<Node> foundNodes = query.startsWith(".") || query.startsWith("#") ? node.lookupAll(query) : GuiTest.findAll(Commons.hasText(query), node);
        return foundNodes;
    }

    private static <T extends Node> Set<T> getVisibleNodes(Set<T> foundNodes) {
        Set visibleNodes = Sets.filter(foundNodes, FXTestUtils.isVisible);
        if (visibleNodes.isEmpty()) {
            throw new NoNodesVisibleException("Matching nodes were found, but none of them were visible. Screenshot saved as " + GuiTest.captureScreenshot().getAbsolutePath() + ".");
        }
        return visibleNodes;
    }

    private static void assertNodesFound(Object query, Collection<? extends Node> foundNodes) {
        if (foundNodes.isEmpty()) {
            throw new NoNodesFoundException("No nodes matched '" + query + "'. Screenshot saved as " + GuiTest.captureScreenshot().getAbsolutePath() + ".");
        }
    }

    public static Set<Node> findAll(String query) {
        Set<Node> foundNodes = GuiTest.findAllRecursively(query);
        GuiTest.assertNodesFound(query, foundNodes);
        return GuiTest.getVisibleNodes(foundNodes);
    }

    private static Set<Node> findAllRecursively(String query) {
        LinkedHashSet results = Sets.newLinkedHashSet();
        results.addAll(GuiTest.findAll(query, lastSeenWindow));
        Predicate<Window> isDescendant = new Predicate<Window>(){

            public boolean apply(Window input) {
                Window parent = null;
                if (input instanceof Stage) {
                    parent = ((Stage)input).getOwner();
                } else if (input instanceof PopupWindow) {
                    parent = ((PopupWindow)input).getOwnerWindow();
                }
                return parent == lastSeenWindow || parent != null && this.apply(parent);
            }
        };
        Iterable descendants = Iterables.filter(GuiTest.getWindows(), (Predicate)isDescendant);
        Iterable rest = Iterables.filter(GuiTest.getWindows(), (Predicate)Predicates.not((Predicate)isDescendant));
        for (Window descendant : ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)descendants, (Iterable)rest))) {
            results.addAll(GuiTest.findAll(query, descendant));
        }
        return results;
    }

    public static <T extends Node> T find(String selector, Object parent) {
        return (T)((Node)Preconditions.checkNotNull((Object)((Node)Iterables.getFirst(GuiTest.findAll(selector, parent), null)), (String)"Query [%s] select [%s] resulted in no nodes found!", (Object[])new Object[]{parent, selector}));
    }

    public static <T extends Node> T find(String query) {
        boolean isCssQuery;
        T foundNode = null;
        boolean bl = isCssQuery = query.startsWith(".") || query.startsWith("#");
        if (isCssQuery) {
            foundNode = GuiTest.findByCssSelector(query);
            if (foundNode == null) {
                throw new NoNodesFoundException("No nodes matched the CSS query '" + query + "'! Screenshot saved as " + GuiTest.captureScreenshot().getAbsolutePath());
            }
        } else {
            foundNode = GuiTest.find(Commons.hasText(query));
            if (foundNode == null) {
                throw new NoNodesFoundException("No nodes found with label '" + query + "'! Screenshot saved as " + GuiTest.captureScreenshot().getAbsolutePath());
            }
        }
        return foundNode;
    }

    public static boolean exists(String query) {
        return GuiTest.selectorExists(query) || GuiTest.labelExists(query);
    }

    private static boolean labelExists(String query) {
        return GuiTest.find(Commons.hasText(query)) != null;
    }

    private static boolean selectorExists(String query) {
        return GuiTest.findByCssSelector(query) != null;
    }

    public static Callable<Integer> numberOf(final String nodeQuery) {
        return new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return GuiTest.findAll(nodeQuery).size();
            }
        };
    }

    public static File captureScreenshot() {
        File screenshot = new File("screenshot" + new Date().getTime() + ".png");
        try {
            BufferedImage image = new Robot().createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
            ImageIO.write((RenderedImage)image, "png", screenshot);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return screenshot;
    }

    public static void waitUntil(final Node node, final Matcher<Object> condition, int timeoutInSeconds) {
        TestUtils.awaitCondition(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return condition.matches((Object)node);
            }
        }, timeoutInSeconds);
    }

    public static void waitUntil(Node node, Matcher<Object> condition) {
        GuiTest.waitUntil(node, condition, 15);
    }

    public static <T> void waitUntil(T value, Matcher<? super T> condition) {
        GuiTest.waitUntil(value, condition, 15);
    }

    public static <T> void waitUntil(final Callable<T> callable, final Matcher<? super T> condition) {
        TestUtils.awaitCondition(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return condition.matches(callable.call());
            }
        }, 15);
    }

    public static <T> void waitUntil(final T value, final Matcher<? super T> condition, int timeoutInSeconds) {
        TestUtils.awaitCondition(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return condition.matches(value);
            }
        }, timeoutInSeconds);
    }

    public static <T extends Node> void waitUntil(T node, Predicate<T> condition) {
        GuiTest.waitUntil(node, condition, 15);
    }

    public static <T extends Node> void waitUntil(final T node, final Predicate<T> condition, int timeoutInSeconds) {
        TestUtils.awaitCondition(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return condition.apply((Object)node);
            }
        }, timeoutInSeconds);
    }

    private static <T extends Node> T findByCssSelector(final String selector) {
        Set<Node> locallyFound = GuiTest.findAll(selector);
        Iterable globallyFound = Iterables.concat((Iterable)Iterables.transform(GuiTest.getWindows(), (Function)new Function<Window, Iterable<Node>>(){

            public Iterable<Node> apply(Window input) {
                return GuiTest.findAll(selector, input);
            }
        }));
        Iterables.addAll(locallyFound, (Iterable)globallyFound);
        GuiTest.assertNodesFound(selector, locallyFound);
        Set<Node> visibleNodes = GuiTest.getVisibleNodes(locallyFound);
        return (T)((Node)Iterables.getFirst(visibleNodes, null));
    }

    public static <T extends Node> T find(final Matcher<Object> matcher) {
        Iterable found = Iterables.transform(GuiTest.getWindows(), (Function)new Function<Window, Set<Node>>(){

            public Set<Node> apply(Window input) {
                return GuiTest.findAllRecursively((Matcher<Object>)matcher, (Node)input.getScene().getRoot());
            }
        });
        Set foundFlattened = FXTestUtils.flattenSets(found);
        GuiTest.assertNodesFound(matcher, foundFlattened);
        return (T)((Node)Iterables.getFirst(GuiTest.getVisibleNodes(foundFlattened), null));
    }

    public static <T extends Node> T find(final Predicate<T> predicate) {
        Iterable found = Iterables.transform(GuiTest.getWindows(), (Function)new Function<Window, Set<T>>(){

            public Set<T> apply(Window input) {
                return GuiTest.findAllRecursively(predicate, (Node)input.getScene().getRoot());
            }
        });
        Set foundFlattened = FXTestUtils.flattenSets(found);
        GuiTest.assertNodesFound(predicate, foundFlattened);
        return (T)((Node)Iterables.getFirst(GuiTest.getVisibleNodes(foundFlattened), null));
    }

    public static Set<Node> findAll(Matcher<Object> matcher, Node parent) {
        Set<Node> foundNodes = GuiTest.findAllRecursively(matcher, parent);
        GuiTest.assertNodesFound(matcher, foundNodes);
        return GuiTest.getVisibleNodes(foundNodes);
    }

    private static Set<Node> findAllRecursively(Matcher<Object> matcher, Node parent) {
        HashSet<Node> found = new HashSet<Node>();
        if (matcher.matches((Object)parent)) {
            found.add(parent);
        }
        if (parent instanceof Parent) {
            for (Node child : ((Parent)parent).getChildrenUnmodifiable()) {
                found.addAll(GuiTest.findAllRecursively(matcher, child));
            }
        }
        return ImmutableSet.copyOf(found);
    }

    public static <T extends Node> Set<T> findAll(Predicate<T> predicate, Node parent) {
        Set<T> foundNodes = GuiTest.findAllRecursively(predicate, parent);
        GuiTest.assertNodesFound(predicate, foundNodes);
        return GuiTest.getVisibleNodes(foundNodes);
    }

    private static <T extends Node> Set<T> findAllRecursively(Predicate<T> predicate, Node parent) {
        HashSet<Object> found = new HashSet<Object>();
        try {
            Node node = parent;
            if (predicate.apply((Object)node)) {
                found.add(node);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (parent instanceof Parent) {
            for (Node child : ((Parent)parent).getChildrenUnmodifiable()) {
                found.addAll(GuiTest.findAllRecursively(predicate, child));
            }
        }
        return ImmutableSet.copyOf(found);
    }

    public GuiTest() {
        this.controller = new FXScreenController();
    }

    public GuiTest sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public GuiTest sleep(long value, TimeUnit unit) {
        return this.sleep(unit.toMillis(value));
    }

    public GuiTest target(Object window) {
        if (window instanceof Window) {
            GuiTest.targetWindow((Window)window);
        } else if (window instanceof String) {
            GuiTest.targetWindow(GuiTest.findStageByTitle((String)window));
        } else if (window instanceof Number) {
            GuiTest.targetWindow(GuiTest.getWindowByIndex(((Number)window).intValue()));
        } else if (window instanceof Class) {
            GuiTest.targetWindow((Window)Iterables.find(GuiTest.getWindows(), (Predicate)Predicates.instanceOf((Class)((Class)window))));
        } else {
            Preconditions.checkArgument((boolean)false, (String)"Unable to identify Window based on the given argument: %s", (Object[])new Object[]{window});
        }
        return this;
    }

    public GuiTest click(MouseButton ... buttons) {
        if (buttons.length == 0) {
            return this.click(MouseButton.PRIMARY);
        }
        this.press(buttons);
        return this.release(buttons);
    }

    public GuiTest click(String query, MouseButton ... buttons) {
        this.move(query);
        return this.click(buttons);
    }

    public GuiTest click(Node node, MouseButton ... buttons) {
        this.move(node);
        return this.click(buttons);
    }

    public <T extends Node> GuiTest click(Predicate<T> p, MouseButton ... buttons) {
        this.move(p);
        return this.click(buttons);
    }

    public GuiTest click(Point2D point, MouseButton ... buttons) {
        this.move(point);
        return this.click(buttons);
    }

    public GuiTest click(Bounds bounds, MouseButton ... buttons) {
        this.move(bounds);
        return this.click(buttons);
    }

    public GuiTest click(Scene scene, MouseButton ... buttons) {
        this.move(scene);
        return this.click(buttons);
    }

    public GuiTest click(Window window, MouseButton ... buttons) {
        this.move(window);
        return this.click(buttons);
    }

    public GuiTest click(Matcher<Node> matcher, MouseButton ... buttons) {
        this.move(matcher);
        return this.click(buttons);
    }

    public GuiTest click(Iterable<?> iterable, MouseButton ... buttons) {
        this.move(iterable);
        return this.click(buttons);
    }

    public GuiTest click(OffsetTarget target, MouseButton ... buttons) {
        this.move(target);
        return this.click(buttons);
    }

    public GuiTest rightClick() {
        return this.click(MouseButton.SECONDARY);
    }

    public GuiTest rightClick(String query) {
        return this.click(query, MouseButton.SECONDARY);
    }

    public GuiTest rightClick(Node node) {
        return this.click(node, MouseButton.SECONDARY);
    }

    public GuiTest rightClick(Matcher<Node> matcher) {
        return this.click(matcher, MouseButton.SECONDARY);
    }

    public <T extends Node> GuiTest rightClick(Predicate<T> predicate) {
        return this.click(predicate, MouseButton.SECONDARY);
    }

    public GuiTest rightClick(Scene scene) {
        return this.click(scene, MouseButton.SECONDARY);
    }

    public GuiTest rightClick(Window window) {
        return this.click(window, MouseButton.SECONDARY);
    }

    public GuiTest rightClick(Point2D point) {
        return this.click(point, MouseButton.SECONDARY);
    }

    public GuiTest rightClick(Bounds bounds) {
        return this.click(bounds, MouseButton.SECONDARY);
    }

    public GuiTest rightClick(OffsetTarget target) {
        return this.click(target, MouseButton.SECONDARY);
    }

    public GuiTest rightClick(Iterable<?> iterable) {
        return this.click(iterable, MouseButton.SECONDARY);
    }

    public GuiTest doubleClick() {
        return this.click(new MouseButton[0]).click(new MouseButton[0]).sleep(50L);
    }

    public GuiTest doubleClick(String query) {
        return this.click(query, new MouseButton[0]).click(new MouseButton[0]).sleep(50L);
    }

    public GuiTest doubleClick(Node node) {
        return this.click(node, new MouseButton[0]).click(new MouseButton[0]).sleep(50L);
    }

    public GuiTest doubleClick(Matcher<Node> matcher) {
        return this.click(matcher, new MouseButton[0]).click(new MouseButton[0]).sleep(50L);
    }

    public <T extends Node> GuiTest doubleClick(Predicate<T> predicate) {
        return this.click(predicate, new MouseButton[0]).click(new MouseButton[0]).sleep(50L);
    }

    public GuiTest doubleClick(Scene scene) {
        return this.click(scene, new MouseButton[0]).click(new MouseButton[0]).sleep(50L);
    }

    public GuiTest doubleClick(Window window) {
        return this.click(window, new MouseButton[0]).click(new MouseButton[0]).sleep(50L);
    }

    public GuiTest doubleClick(Point2D point) {
        return this.click(point, new MouseButton[0]).click(new MouseButton[0]).sleep(50L);
    }

    public GuiTest doubleClick(Bounds bounds) {
        return this.click(bounds, new MouseButton[0]).click(new MouseButton[0]).sleep(50L);
    }

    public GuiTest doubleClick(OffsetTarget target) {
        return this.click(target, new MouseButton[0]).click(new MouseButton[0]).sleep(50L);
    }

    public GuiTest doubleClick(Iterable<?> iterable) {
        return this.click(iterable, new MouseButton[0]).click(new MouseButton[0]).sleep(50L);
    }

    public GuiTest doubleClick(MouseButton button) {
        return this.click(button).click(button).sleep(50L);
    }

    public GuiTest eraseCharacters(int characters) {
        for (int i = 0; i < characters; ++i) {
            this.type(KeyCode.BACK_SPACE);
        }
        return this;
    }

    public MouseMotion drag(Object source, MouseButton ... buttons) {
        this.move(source);
        this.press(buttons);
        return new MouseMotion(this, buttons);
    }

    public GuiTest move(double x, double y) {
        this.controller.move(x, y);
        return this;
    }

    public GuiTest move(Object target) {
        Point2D point = this.pointFor(target);
        if (!MouseInfo.getPointerInfo().getLocation().equals(point)) {
            this.move(point.getX(), point.getY());
        }
        point = this.pointFor(target);
        this.controller.position(point.getX(), point.getY());
        return this;
    }

    public GuiTest moveBy(double x, double y) {
        Point2D mouse = this.controller.getMouse();
        this.controller.move(mouse.getX() + x, mouse.getY() + y);
        return this;
    }

    public GuiTest press(MouseButton ... buttons) {
        if (buttons.length == 0) {
            return this.press(MouseButton.PRIMARY);
        }
        for (MouseButton button : buttons) {
            if (!this.pressedButtons.add(button)) continue;
            this.controller.press(button);
        }
        return this;
    }

    public GuiTest release(MouseButton ... buttons) {
        if (buttons.length == 0) {
            for (MouseButton button : this.pressedButtons) {
                this.controller.release(button);
            }
            this.pressedButtons.clear();
        } else {
            for (MouseButton button : buttons) {
                if (!this.pressedButtons.remove(button)) continue;
                this.controller.release(button);
            }
        }
        return this;
    }

    @Deprecated
    public GuiTest scroll(int amount) {
        for (int x = 0; x < Math.abs(amount); ++x) {
            this.controller.scroll(Integer.signum(amount));
        }
        return this;
    }

    public GuiTest scroll(int amount, VerticalDirection direction) {
        for (int x = 0; x < Math.abs(amount); ++x) {
            this.controller.scroll(this.directionToInteger(direction));
        }
        return this;
    }

    public GuiTest scroll(VerticalDirection direction) {
        return this.scroll(1, direction);
    }

    private int directionToInteger(VerticalDirection direction) {
        if (direction == VerticalDirection.UP) {
            return -1;
        }
        return 1;
    }

    public GuiTest type(String text) {
        for (int i = 0; i < text.length(); ++i) {
            this.type(text.charAt(i));
            try {
                Thread.sleep(25L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this;
    }

    public GuiTest type(char character) {
        KeyCode keyCode = KeyCodeUtils.findKeyCode(character);
        if (!Character.isUpperCase(character)) {
            return this.type(keyCode);
        }
        KeyCode[] modifiers = new KeyCode[]{KeyCode.SHIFT};
        this.press(modifiers);
        this.type(keyCode);
        return this.release(modifiers);
    }

    public GuiTest push(KeyCode ... keys) {
        return this.type(keys);
    }

    public GuiTest push(char character) {
        return this.type(character);
    }

    public GuiTest type(KeyCode ... keys) {
        this.press(keys);
        return this.release(keys);
    }

    public GuiTest press(KeyCode ... keys) {
        for (KeyCode key : keys) {
            if (!this.pressedKeys.add(key)) continue;
            this.controller.press(key);
        }
        return this;
    }

    public GuiTest release(KeyCode ... keys) {
        if (keys.length == 0) {
            for (KeyCode button : this.pressedKeys) {
                this.controller.release(button);
            }
            this.pressedKeys.clear();
        } else {
            for (KeyCode key : keys) {
                if (!this.pressedKeys.remove(key)) continue;
                this.controller.release(key);
            }
        }
        return this;
    }

    public GuiTest pos(Pos pos) {
        this.nodePosition = pos;
        return this;
    }

    public GuiTest closeCurrentWindow() {
        this.push(KeyCode.ALT, KeyCode.F4).sleep(100L);
        return this;
    }

    private Point2D pointForBounds(Bounds bounds) {
        double x = 0.0;
        switch (this.nodePosition.getHpos()) {
            case LEFT: {
                x = bounds.getMinX();
                break;
            }
            case CENTER: {
                x = (bounds.getMinX() + bounds.getMaxX()) / 2.0;
                break;
            }
            case RIGHT: {
                x = bounds.getMaxX();
            }
        }
        double y = 0.0;
        switch (this.nodePosition.getVpos()) {
            case TOP: {
                y = bounds.getMinY();
                break;
            }
            case CENTER: 
            case BASELINE: {
                y = (bounds.getMinY() + bounds.getMaxY()) / 2.0;
                break;
            }
            case BOTTOM: {
                y = bounds.getMaxY();
            }
        }
        return new Point2D(x, y);
    }

    private static Bounds sceneBoundsToScreenBounds(Bounds sceneBounds, Scene scene) {
        Window window = GuiTest.targetWindow(scene.getWindow());
        BoundingBox b = new BoundingBox(window.getX() + scene.getX() + sceneBounds.getMinX(), window.getY() + scene.getY() + sceneBounds.getMinY(), sceneBounds.getWidth(), sceneBounds.getHeight());
        return b;
    }

    public Point2D pointFor(Object target) {
        if (target instanceof Point2D) {
            return (Point2D)target;
        }
        if (target instanceof Bounds) {
            return this.pointForBounds((Bounds)target);
        }
        if (target instanceof String) {
            return this.pointFor(GuiTest.find((String)target));
        }
        if (target instanceof Node) {
            Node node = (Node)target;
            Bounds nodeBounds = node.localToScene(node.getBoundsInLocal());
            Scene scene = node.getScene();
            BoundingBox sceneBounds = new BoundingBox(0.0, 0.0, scene.getWidth(), scene.getHeight());
            Bounds clickableArea = FXTestUtils.intersection(nodeBounds, (Bounds)sceneBounds);
            return this.pointFor(GuiTest.sceneBoundsToScreenBounds(clickableArea, node.getScene()));
        }
        if (target instanceof Scene) {
            Scene scene = (Scene)target;
            return this.pointFor(GuiTest.sceneBoundsToScreenBounds((Bounds)new BoundingBox(0.0, 0.0, scene.getWidth(), scene.getHeight()), scene));
        }
        if (target instanceof Window) {
            Window window = GuiTest.targetWindow((Window)target);
            return this.pointFor(new BoundingBox(window.getX(), window.getY(), window.getWidth(), window.getHeight()));
        }
        if (target instanceof Matcher) {
            return this.pointFor(GuiTest.find((Matcher<Object>)((Matcher)target)));
        }
        if (target instanceof Predicate) {
            return this.pointFor(GuiTest.find((Predicate)target));
        }
        if (target instanceof Iterable) {
            return this.pointFor(Iterables.get((Iterable)((Iterable)target), (int)0));
        }
        if (target instanceof OffsetTarget) {
            OffsetTarget offset = (OffsetTarget)target;
            Pos oldPos = this.nodePosition;
            Point2D targetPoint = this.pos(Pos.TOP_LEFT).pointFor(offset.target);
            this.pos(oldPos);
            return new Point2D(targetPoint.getX() + offset.offsetX, targetPoint.getY() + offset.offsetY);
        }
        throw new IllegalArgumentException("Unable to get coordinates for: " + target);
    }

    static {
        lastSeenWindow = null;
    }

    static class OffsetTarget {
        private final Object target;
        private final double offsetX;
        private final double offsetY;

        private OffsetTarget(Object target, double offsetX, double offsetY) {
            this.target = target;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }
    }

    public static class TestFxApp
    extends Application {
        private static Scene scene = null;

        public void start(Stage primaryStage) throws Exception {
            primaryStage.initStyle(StageStyle.UNDECORATED);
            primaryStage.show();
            stageFuture.set((Object)primaryStage);
        }

        public static void setRoot(Parent rootNode) {
            scene.setRoot(rootNode);
        }
    }
}

