/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx.controls.impl;

import com.google.common.base.Preconditions;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextInputControl;
import org.hamcrest.Description;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.loadui.testfx.GuiTest;

public class HasLabelStringMatcher
extends TypeSafeMatcher<Object> {
    private final String label;

    public HasLabelStringMatcher(String label) {
        this.label = label;
    }

    public void describeTo(Description desc) {
        desc.appendText("Node should have label " + this.label);
    }

    public boolean matchesSafely(Object target) {
        if (target instanceof String) {
            return this.nodeHasLabel((Node)GuiTest.find((String)target));
        }
        if (target instanceof Labeled) {
            return this.nodeHasLabel((Node)((Labeled)target));
        }
        return false;
    }

    private boolean nodeHasLabel(Node node) {
        Preconditions.checkArgument((node instanceof Labeled || node instanceof TextInputControl ? 1 : 0) != 0, (Object)"Target node must be Labeled or TextInputControl.");
        if (node instanceof Labeled) {
            Labeled labeled = (Labeled)node;
            return this.label.equals(labeled.getText());
        }
        TextInputControl textInput = (TextInputControl)node;
        return this.label.equals(textInput.getText());
    }
}

