/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.SettableFuture;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.junit.Assert;
import org.loadui.testfx.GuiTest;

public class FXTestUtils {
    public static final int TIMEOUT = 5;
    public static final Predicate<Node> isVisible = new Predicate<Node>(){

        public boolean apply(Node node) {
            return FXTestUtils.isNodeVisible(node);
        }
    };

    public static void bringToFront(final Stage stage) throws Exception {
        FXTestUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                stage.toBack();
                stage.toFront();
            }
        }, 5);
        Thread.sleep(250L);
    }

    public static void awaitEvents() {
        try {
            for (int i = 0; i < 5; ++i) {
                final Semaphore sem = new Semaphore(0);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        sem.release();
                    }
                });
                boolean wasAcquired = sem.tryAcquire(5L, TimeUnit.SECONDS);
                if (!wasAcquired) {
                    System.out.println("[TestFX] WARNING: GUI locked for more than 5 seconds - timing out!");
                    break;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void invokeAndWait(final Callable<?> task, int timeoutInSeconds) throws Exception {
        final SettableFuture future = SettableFuture.create();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    task.call();
                    future.set(null);
                }
                catch (Throwable e) {
                    future.setException(e);
                }
            }
        });
        try {
            future.get((long)timeoutInSeconds, TimeUnit.SECONDS);
            FXTestUtils.awaitEvents();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    public static void invokeAndWait(final Runnable task, int timeoutInSeconds) throws Exception {
        FXTestUtils.invokeAndWait(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                task.run();
                return null;
            }
        }, timeoutInSeconds);
    }

    public static void launchApp(final Class<? extends Application> appClass, final String ... args) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Application.launch((Class)appClass, (String[])args);
            }
        }).start();
    }

    public static void printGraph(Node root) {
        FXTestUtils.printGraph(root, "");
    }

    public static void failIfExists(String selector) {
        try {
            GuiTest.find(selector);
            Assert.fail((String)("Selector shouldn't have found anything: " + selector));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T extends Node> T getOrFail(String selector) {
        try {
            return GuiTest.find(selector);
        }
        catch (Exception e) {
            Assert.fail((String)("Cannot find anything with selector: " + selector));
            return null;
        }
    }

    private static void printGraph(Node root, String indent) {
        System.out.println(indent + root);
        if (root instanceof Parent) {
            indent = indent + "  ";
            for (Node child : ((Parent)root).getChildrenUnmodifiable()) {
                FXTestUtils.printGraph(child, indent);
            }
        }
    }

    public static boolean isNodeVisible(Node node) {
        if (!node.isVisible() || !node.impl_isTreeVisible()) {
            return false;
        }
        return FXTestUtils.isNodeWithinSceneBounds(node);
    }

    public static boolean isNodeWithinSceneBounds(Node node) {
        Scene scene = node.getScene();
        Bounds nodeBounds = node.localToScene(node.getBoundsInLocal());
        return nodeBounds.intersects(0.0, 0.0, scene.getWidth(), scene.getHeight());
    }

    public static Bounds intersection(Bounds b1, Bounds b2) {
        Rectangle r1 = FXTestUtils.toRectangle(b1);
        Rectangle r2 = FXTestUtils.toRectangle(b2);
        Rectangle i = r1.intersection(r2);
        return new BoundingBox(i.getMinX(), i.getMinY(), i.getWidth(), i.getHeight());
    }

    private static Rectangle toRectangle(Bounds b1) {
        return new Rectangle((int)b1.getMinX(), (int)b1.getMinY(), (int)b1.getWidth(), (int)b1.getHeight());
    }

    public static <T extends Node> Set<T> flattenSets(Iterable<Set<T>> found) {
        ImmutableSet.Builder sb = ImmutableSet.builder();
        for (Set<T> set : found) {
            sb.addAll(set);
        }
        return sb.build();
    }

    public static void releaseButtons() {
        try {
            Robot robot = new Robot();
            robot.mouseRelease(1024);
            robot.mouseRelease(2048);
            robot.keyRelease(16);
            robot.keyRelease(17);
        }
        catch (AWTException e) {
            System.out.println("[TestFX] Failed releasing keys.");
            e.printStackTrace();
        }
    }
}

