/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.index;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.SimpleFeatureSerializer;
import org.locationtech.geomesa.features.kryo.ProjectingKryoFeatureSerializer;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.sft.package;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;

public final class IndexValueEncoder$ {
    public static IndexValueEncoder$ MODULE$;
    private final ConcurrentHashMap<package.ImmutableSimpleFeatureType, package.ImmutableSimpleFeatureType> cache;

    static {
        new IndexValueEncoder$();
    }

    private ConcurrentHashMap<package.ImmutableSimpleFeatureType, package.ImmutableSimpleFeatureType> cache() {
        return this.cache;
    }

    public SimpleFeatureSerializer apply(SimpleFeatureType sft) {
        return new ProjectingKryoFeatureSerializer(sft, this.getIndexSft(sft), SerializationOption.SerializationOptions$.MODULE$.withoutId());
    }

    public SimpleFeatureType getIndexSft(SimpleFeatureType sft) {
        SimpleFeatureType simpleFeatureType = sft;
        if (simpleFeatureType instanceof package.ImmutableSimpleFeatureType) {
            BoxedUnit boxedUnit;
            package.ImmutableSimpleFeatureType immutableSimpleFeatureType = (package.ImmutableSimpleFeatureType)simpleFeatureType;
            package.ImmutableSimpleFeatureType indexSft = this.cache().get(immutableSimpleFeatureType);
            if (indexSft == null) {
                indexSft = (package.ImmutableSimpleFeatureType)SimpleFeatureTypes$.MODULE$.immutable(this.buildIndexSft(sft), SimpleFeatureTypes$.MODULE$.immutable$default$2());
                boxedUnit = this.cache().put(immutableSimpleFeatureType, indexSft);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return indexSft;
        }
        return this.buildIndexSft(sft);
    }

    private SimpleFeatureType buildIndexSft(SimpleFeatureType sft) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setNamespaceURI(null);
        builder.setName(new StringBuilder(7).append(sft.getTypeName()).append("--index").toString());
        builder.setAttributes((List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.getIndexValueAttributes(sft)).asJava());
        if (sft.getGeometryDescriptor() != null) {
            builder.setDefaultGeometry(sft.getGeometryDescriptor().getLocalName());
        }
        builder.setCRS(sft.getCoordinateReferenceSystem());
        SimpleFeatureType indexSft = builder.buildFeatureType();
        indexSft.getUserData().putAll(sft.getUserData());
        return indexSft;
    }

    private Seq<AttributeDescriptor> getIndexValueAttributes(SimpleFeatureType sft) {
        GeometryDescriptor geom = sft.getGeometryDescriptor();
        Option dtg = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Buffer attributes = (Buffer)Buffer$.MODULE$.empty();
        for (int i = 0; i < sft.getAttributeCount(); ++i) {
            AttributeDescriptor ad;
            AttributeDescriptor attributeDescriptor = ad = sft.getDescriptor(i);
            GeometryDescriptor geometryDescriptor = geom;
            if ((attributeDescriptor == null ? geometryDescriptor != null : !attributeDescriptor.equals(geometryDescriptor)) && !dtg.contains((Object)ad.getLocalName()) && !RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isIndexValue$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad))) continue;
            attributes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeDescriptor[]{ad}));
        }
        return attributes.toSeq();
    }

    private IndexValueEncoder$() {
        MODULE$ = this;
        this.cache = new ConcurrentHashMap();
    }
}

