/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.jobs.index;

import com.beust.jcommander.Parameter;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.geotools.data.Query;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStoreParams$;
import org.locationtech.geomesa.accumulo.data.AccumuloQueryPlan;
import org.locationtech.geomesa.accumulo.jobs.AccumuloJobUtils$;
import org.locationtech.geomesa.accumulo.jobs.GeoMesaArgs;
import org.locationtech.geomesa.accumulo.jobs.InputCqlArgs;
import org.locationtech.geomesa.accumulo.jobs.InputDataStoreArgs;
import org.locationtech.geomesa.accumulo.jobs.InputFeatureArgs;
import org.locationtech.geomesa.accumulo.jobs.index.WriteIndexJob$;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloInputFormat;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloInputFormat$;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.jobs.JobUtils$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.WithStore$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tUr!\u0002\u0011\"\u0011\u0003qc!\u0002\u0019\"\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004\"\u0002\u001e\u0002\t\u0003Yd\u0001B(\u0002\u0001AC\u0011\u0002\u0011\u0003\u0003\u0002\u0003\u0006I!\u00110\t\u000ba\"A\u0011A0\t\u000f\r$\u0001\u0019!C\u0001I\"9Q\u000e\u0002a\u0001\n\u0003q\u0007BB9\u0005A\u0003&Q\rC\u0004\u0002\u000e\u0011!\t%a\u0004\u0007\r\u0005E\u0011\u0001AA\n\u0011\u0019A4\u0002\"\u0001\u0002J\u00151\u0011QJ\u0006\u0001\u0003\u001fB\u0011\"a\u0015\f\u0005\u0004%I!!\u0016\t\u0011\u0005]3\u0002)A\u0005\u0003SA1\"!\u0017\f\u0001\u0004\u0005\r\u0011\"\u0003\u0002\\!Y\u00111M\u0006A\u0002\u0003\u0007I\u0011BA3\u0011-\tIg\u0003a\u0001\u0002\u0003\u0006K!!\u0018\t\u000f\u0005-4\u0002\"\u0015\u0002n!9\u0011qO\u0006\u0005R\u0005e\u0004bBA?\u0017\u0011\u0005\u0013q\u0010\u0005\n\u0003\u0017\u000b\u0011\u0013!C\u0001\u0003\u001b3Q\u0001M\u0011\u0001\u00033D!B!\u0001\u0018\u0005\u0003\u0005\u000b\u0011BAI\u0011\u0019At\u0003\"\u0001\u0003\u0004!I!\u0011B\fA\u0002\u0013%!1\u0002\u0005\n\u0005/9\u0002\u0019!C\u0005\u00053A\u0001B!\b\u0018A\u0003&!Q\u0002\u0005\b\u0005?9B\u0011\tB\u0011\u0011\u001d\u0011Yc\u0006C!\u0005[AqAa\f\u0018\t\u0003\u0012\t$A\u0007Xe&$X-\u00138eKbTuN\u0019\u0006\u0003E\r\nQ!\u001b8eKbT!\u0001J\u0013\u0002\t)|'m\u001d\u0006\u0003M\u001d\n\u0001\"Y2dk6,Hn\u001c\u0006\u0003Q%\nqaZ3p[\u0016\u001c\u0018M\u0003\u0002+W\u0005aAn\\2bi&|g\u000e^3dQ*\tA&A\u0002pe\u001e\u001c\u0001\u0001\u0005\u00020\u00035\t\u0011EA\u0007Xe&$X-\u00138eKbTuNY\n\u0003\u0003I\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001/\u0003\u0011i\u0017-\u001b8\u0015\u0005qz\u0004CA\u001a>\u0013\tqDG\u0001\u0003V]&$\b\"\u0002!\u0004\u0001\u0004\t\u0015\u0001B1sON\u00042a\r\"E\u0013\t\u0019EGA\u0003BeJ\f\u0017\u0010\u0005\u0002F\u0019:\u0011aI\u0013\t\u0003\u000fRj\u0011\u0001\u0013\u0006\u0003\u00136\na\u0001\u0010:p_Rt\u0014BA&5\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-#$AD,sSR,\u0017J\u001c3fq\u0006\u0013xm]\n\u0006\tE+\u0006l\u0017\t\u0003%Nk\u0011aI\u0005\u0003)\u000e\u00121bR3p\u001b\u0016\u001c\u0018-\u0011:hgB\u0011!KV\u0005\u0003/\u000e\u0012\u0001#\u00138qkR4U-\u0019;ve\u0016\f%oZ:\u0011\u0005IK\u0016B\u0001.$\u0005IIe\u000e];u\t\u0006$\u0018m\u0015;pe\u0016\f%oZ:\u0011\u0005Ic\u0016BA/$\u00051Ie\u000e];u\u0007Fd\u0017I]4t\u0013\t\u00015\u000b\u0006\u0002aEB\u0011\u0011\rB\u0007\u0002\u0003!)\u0001I\u0002a\u0001\u0003\u0006Q\u0011N\u001c3fq:\u000bW.Z:\u0016\u0003\u0015\u00042AZ6E\u001b\u00059'B\u00015j\u0003\u0011)H/\u001b7\u000b\u0003)\fAA[1wC&\u0011An\u001a\u0002\u0005\u0019&\u001cH/\u0001\bj]\u0012,\u0007PT1nKN|F%Z9\u0015\u0005qz\u0007b\u00029\t\u0003\u0003\u0005\r!Z\u0001\u0004q\u0012\n\u0014aC5oI\u0016Dh*Y7fg\u0002BC\"C:~}\u0006\r\u0011QAA\u0005\u0003\u0017\u0001\"\u0001^>\u000e\u0003UT!A^<\u0002\u0015)\u001cw.\\7b]\u0012,'O\u0003\u0002ys\u0006)!-Z;ti*\t!0A\u0002d_6L!\u0001`;\u0003\u0013A\u000b'/Y7fi\u0016\u0014\u0018!\u00028b[\u0016\u001cH&A@\"\u0005\u0005\u0005\u0011aD\u0017.O\u0016|W.Z:b]%tG-\u001a=\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0003\u0003\u000f\tqHT1nK\u0002zg\rI5oI\u0016D\b&Z:*AQ|\u0007%\u00193eA5\u00023m\\7nC6\u001aX\r]1sCR,\u0007e\u001c:!kN,\u0007%\\;mi&\u0004H.\u001a\u0011gY\u0006<7/\u0001\u0005sKF,\u0018N]3e3\u0005\t\u0011aB;oa\u0006\u00148/\u001a\u000b\u0002\u0003\n\t\u0002+Y:t)\"\u0014x.^4i\u001b\u0006\u0004\b/\u001a:\u0014\u0007-\t)\u0002\u0005\u0007\u0002\u0018\u0005\u0015\u0012\u0011FA\u001b\u0003S\t)$\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0003\u0002 \u0005\u0005\u0012A\u00025bI>|\u0007OC\u0002\u0002$-\na!\u00199bG\",\u0017\u0002BA\u0014\u00033\u0011a!T1qa\u0016\u0014\b\u0003BA\u0016\u0003ci!!!\f\u000b\t\u0005=\u0012QD\u0001\u0003S>LA!a\r\u0002.\t!A+\u001a=u!\u0011\t9$!\u0012\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\taa]5na2,'\u0002BA \u0003\u0003\nqAZ3biV\u0014XMC\u0002\u0002D-\nqa\u001c9f]\u001eL7/\u0003\u0003\u0002H\u0005e\"!D*j[BdWMR3biV\u0014X\r\u0006\u0002\u0002LA\u0011\u0011m\u0003\u0002\b\u0007>tG/\u001a=u!\u0011\t)\"!\u0015\n\t\u00055\u0013QE\u0001\u0005i\u0016DH/\u0006\u0002\u0002*\u0005)A/\u001a=uA\u000591m\\;oi\u0016\u0014XCAA/!\u0011\t9\"a\u0018\n\t\u0005\u0005\u0014\u0011\u0004\u0002\b\u0007>,h\u000e^3s\u0003-\u0019w.\u001e8uKJ|F%Z9\u0015\u0007q\n9\u0007\u0003\u0005q#\u0005\u0005\t\u0019AA/\u0003!\u0019w.\u001e8uKJ\u0004\u0013!B:fiV\u0004Hc\u0001\u001f\u0002p!9\u0011\u0011O\nA\u0002\u0005M\u0014aB2p]R,\u0007\u0010\u001e\t\u0004\u0003kjQ\"A\u0006\u0002\u000f\rdW-\u00198vaR\u0019A(a\u001f\t\u000f\u0005ED\u00031\u0001\u0002t\u0005\u0019Q.\u00199\u0015\u000fq\n\t)!\"\u0002\n\"9\u00111Q\u000bA\u0002\u0005%\u0012aA6fs\"9\u0011qQ\u000bA\u0002\u0005U\u0012!\u0002<bYV,\u0007bBA9+\u0001\u0007\u00111O\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=%\u0006BAI\u0003\u000f\u0004RaMAJ\u0003/K1!!&5\u0005\u0019y\u0005\u000f^5p]B91'!'\u0002\u001e\u0006=\u0016bAANi\t1A+\u001e9mKJ\u0002R!a(\u0002*\u0012sA!!)\u0002&:\u0019q)a)\n\u0003UJ1!a*5\u0003\u001d\u0001\u0018mY6bO\u0016LA!a+\u0002.\n\u00191+Z9\u000b\u0007\u0005\u001dF\u0007\u0005\u0004\u0002 \u0006E\u0016QW\u0005\u0005\u0003g\u000biK\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0015\u0019\u0014qWA^\u0013\r\tI\f\u000e\u0002\n\rVt7\r^5p]B\u0002b!a(\u0002*\u0006u\u0006\u0003BA`\u0003\u0007l!!!1\u000b\u0007\u0005=\u0012.\u0003\u0003\u0002F\u0006\u0005'\u0001\u0002$jY\u0016\\#!!3\u0011\t\u0005-\u0017Q[\u0007\u0003\u0003\u001bTA!a4\u0002R\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'$\u0014AC1o]>$\u0018\r^5p]&!\u0011q[Ag\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\n\b/\u0005m\u0017q]Ay!\u0011\ti.a9\u000e\u0005\u0005}'bAAqS\u0006!A.\u00198h\u0013\u0011\t)/a8\u0003\r=\u0013'.Z2u!\u0011\tI/!<\u000e\u0005\u0005-(b\u00015\u0002\u001e%!\u0011q^Av\u0005\u0011!vn\u001c7\u0011\t\u0005M\u0018Q`\u0007\u0003\u0003kTA!a>\u0002z\u0006a1oY1mC2|wmZ5oO*\u0019\u00111`=\u0002\u0011QL\b/Z:bM\u0016LA!a@\u0002v\nYA*\u0019>z\u0019><w-\u001b8h\u0003\u001da\u0017N\u00196beN$BA!\u0002\u0003\bA\u0011qf\u0006\u0005\n\u0005\u0003I\u0002\u0013!a\u0001\u0003#\u000bAaY8oMV\u0011!Q\u0002\t\u0005\u0005\u001f\u0011\u0019\"\u0004\u0002\u0003\u0012)!!\u0011BA\u000f\u0013\u0011\u0011)B!\u0005\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003!\u0019wN\u001c4`I\u0015\fHc\u0001\u001f\u0003\u001c!A\u0001oGA\u0001\u0002\u0004\u0011i!A\u0003d_:4\u0007%A\u0002sk:$BAa\t\u0003*A\u00191G!\n\n\u0007\t\u001dBGA\u0002J]RDQ\u0001Q\u000fA\u0002\u0005\u000bqaZ3u\u0007>tg\r\u0006\u0002\u0003\u000e\u000591/\u001a;D_:4Gc\u0001\u001f\u00034!9!\u0011B\u0010A\u0002\t5\u0001")
public class WriteIndexJob
implements Tool,
LazyLogging {
    private final Option<Tuple2<Seq<String>, Iterator<Function0<Seq<File>>>>> libjars;
    private Configuration conf;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Seq<String>, Iterator<Function0<Seq<File>>>>> $lessinit$greater$default$1() {
        return WriteIndexJob$.MODULE$.$lessinit$greater$default$1();
    }

    public static void main(String[] args) {
        WriteIndexJob$.MODULE$.main(args);
    }

    private Logger logger$lzycompute() {
        WriteIndexJob writeIndexJob = this;
        synchronized (writeIndexJob) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Configuration conf() {
        return this.conf;
    }

    private void conf_$eq(Configuration x$1) {
        this.conf = x$1;
    }

    public int run(String[] args) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        WriteIndexArgs parsedArgs = new WriteIndexArgs(args);
        parsedArgs.parse();
        String featureIn = parsedArgs.inFeature();
        scala.collection.immutable.Map<String, String> dsInParams = parsedArgs.inDataStore();
        String filter = (String)Option$.MODULE$.apply((Object)parsedArgs.inCql()).getOrElse((Function0 & Serializable)() -> "INCLUDE");
        Tuple3 tuple3 = (Tuple3)WithStore$.MODULE$.apply(dsInParams).apply((Function1 & Serializable)dsIn -> {
            Predef$.MODULE$.require(dsIn != null, (Function0 & Serializable)() -> "The specified input data store could not be created - check your job parameters");
            SimpleFeatureType sft = dsIn.getSchema(featureIn);
            Predef$.MODULE$.require(sft != null, (Function0 & Serializable)() -> new StringBuilder(53).append("The feature '").append(featureIn).append("' does not exist in the input data store").toString());
            Seq allIndices = dsIn.manager().indices(sft, IndexMode$.MODULE$.Write());
            Buffer indices = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(parsedArgs.indexNames()).asScala()).map((Function1 & Serializable)name -> (GeoMesaFeatureIndex)allIndices.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)WriteIndexJob.$anonfun$run$6(name, x$2))).orElse((Function0 & Serializable)() -> allIndices.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)WriteIndexJob.$anonfun$run$8(name, x$3)))).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(33).append("Invalid index ").append((String)name).append(". Valid values are ").append(((IterableOnceOps)((SeqOps)allIndices.map((Function1 & Serializable)x$4 -> x$4.identifier())).sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString());
            }));
            AccumuloQueryPlan plan = AccumuloJobUtils$.MODULE$.getSingleQueryPlan((AccumuloDataStore)dsIn, new Query(sft.getTypeName(), ECQL.toFilter((String)filter)));
            return new Tuple3((Object)sft, indices.map((Function1 & Serializable)x$5 -> x$5.identifier()), (Object)plan);
        });
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        SimpleFeatureType sft = (SimpleFeatureType)tuple3._1();
        Buffer indices = (Buffer)tuple3._2();
        AccumuloQueryPlan plan = (AccumuloQueryPlan)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)sft, (Object)indices, (Object)plan);
        SimpleFeatureType sft2 = (SimpleFeatureType)tuple32._1();
        Buffer indices2 = (Buffer)tuple32._2();
        AccumuloQueryPlan plan2 = (AccumuloQueryPlan)tuple32._3();
        Configuration conf = new Configuration();
        String jobName = new StringBuilder(21).append("GeoMesa Index Job [").append(sft2.getTypeName()).append("] ").append(indices2.mkString("[", "][", "]")).toString();
        Job job = Job.getInstance((Configuration)conf, (String)jobName);
        this.libjars.foreach((Function1 & Serializable)x0$1 -> {
            WriteIndexJob.$anonfun$run$12(job, x0$1);
            return BoxedUnit.UNIT;
        });
        job.setJarByClass(WriteIndexJob.class);
        job.setMapperClass(PassThroughMapper.class);
        job.setInputFormatClass(GeoMesaAccumuloInputFormat.class);
        job.setOutputFormatClass(GeoMesaOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(ScalaSimpleFeature.class);
        job.setNumReduceTasks(0);
        GeoMesaAccumuloInputFormat$.MODULE$.configure(job.getConfiguration(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(dsInParams).asJava(), plan2);
        scala.collection.immutable.Map dsOutParams = (scala.collection.immutable.Map)dsInParams.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AccumuloDataStoreParams$.MODULE$.GenerateStatsParam().getName()), (Object)"false")})));
        GeoMesaOutputFormat$.MODULE$.setOutput(job.getConfiguration(), dsOutParams, sft2, (Option)new Some((Object)indices2.toSeq()));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Submitting job - please wait...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        job.submit();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Tracking available at {}", (Object)job.getStatus().getTrackingUrl());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean result = job.waitForCompletion(true);
        if (result) {
            return 0;
        }
        return 1;
    }

    public Configuration getConf() {
        return this.conf();
    }

    public void setConf(Configuration conf) {
        this.conf_$eq(conf);
    }

    public static final /* synthetic */ boolean $anonfun$run$6(String name$1, GeoMesaFeatureIndex x$2) {
        String string = x$2.identifier();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$run$8(String name$1, GeoMesaFeatureIndex x$3) {
        String string = x$3.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$run$12(Job job$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq jars = (Seq)tuple2._1();
            Iterator path = (Iterator)tuple2._2();
            JobUtils$.MODULE$.setLibJars(job$1.getConfiguration(), jars, path);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public WriteIndexJob(Option<Tuple2<Seq<String>, Iterator<Function0<Seq<File>>>>> libjars) {
        this.libjars = libjars;
        LazyLogging.$init$((LazyLogging)this);
        this.conf = new Configuration();
    }

    public static class PassThroughMapper
    extends Mapper<Text, SimpleFeature, Text, SimpleFeature> {
        private final Text text = new Text();
        private Counter counter;

        private Text text() {
            return this.text;
        }

        private Counter counter() {
            return this.counter;
        }

        private void counter_$eq(Counter x$1) {
            this.counter = x$1;
        }

        public void setup(Mapper.Context context) {
            this.counter_$eq(context.getCounter("org.locationtech.geomesa", "features-written"));
        }

        public void cleanup(Mapper.Context context) {
        }

        public void map(Text key, SimpleFeature value, Mapper.Context context) {
            context.write((Object)this.text(), (Object)value);
            this.counter().increment(1L);
        }
    }

    public static class WriteIndexArgs
    extends GeoMesaArgs
    implements InputFeatureArgs,
    InputDataStoreArgs,
    InputCqlArgs {
        @Parameter(names={"--geomesa.index"}, description="Name of index(es) to add - comma-separate or use multiple flags", required=true)
        private java.util.List<String> indexNames;
        @Parameter(names={"--geomesa.input.cql"}, description="CQL query filter")
        private String inCql;
        @Parameter(names={"--geomesa.input.user"}, description="Accumulo user name", required=true)
        private String inUser;
        @Parameter(names={"--geomesa.input.password"}, description="Accumulo password")
        private String inPassword;
        @Parameter(names={"--geomesa.input.keytabPath"}, description="Accumulo Kerberos keytab path")
        private String inKeytabPath;
        @Parameter(names={"--geomesa.input.instanceId"}, description="Accumulo instance name", required=true)
        private String inInstanceId;
        @Parameter(names={"--geomesa.input.zookeepers"}, description="Zookeepers (host[:port], comma separated)", required=true)
        private String inZookeepers;
        @Parameter(names={"--geomesa.input.tableName"}, description="Accumulo catalog table name", required=true)
        private String inTableName;
        @Parameter(names={"--geomesa.input.feature"}, description="Simple feature type name", required=true)
        private String inFeature;

        @Override
        public scala.collection.immutable.Map<String, String> inDataStore() {
            return InputDataStoreArgs.inDataStore$(this);
        }

        @Override
        public String inCql() {
            return this.inCql;
        }

        @Override
        public void inCql_$eq(String x$1) {
            this.inCql = x$1;
        }

        @Override
        public String inUser() {
            return this.inUser;
        }

        @Override
        public void inUser_$eq(String x$1) {
            this.inUser = x$1;
        }

        @Override
        public String inPassword() {
            return this.inPassword;
        }

        @Override
        public void inPassword_$eq(String x$1) {
            this.inPassword = x$1;
        }

        @Override
        public String inKeytabPath() {
            return this.inKeytabPath;
        }

        @Override
        public void inKeytabPath_$eq(String x$1) {
            this.inKeytabPath = x$1;
        }

        @Override
        public String inInstanceId() {
            return this.inInstanceId;
        }

        @Override
        public void inInstanceId_$eq(String x$1) {
            this.inInstanceId = x$1;
        }

        @Override
        public String inZookeepers() {
            return this.inZookeepers;
        }

        @Override
        public void inZookeepers_$eq(String x$1) {
            this.inZookeepers = x$1;
        }

        @Override
        public String inTableName() {
            return this.inTableName;
        }

        @Override
        public void inTableName_$eq(String x$1) {
            this.inTableName = x$1;
        }

        @Override
        public String inFeature() {
            return this.inFeature;
        }

        @Override
        public void inFeature_$eq(String x$1) {
            this.inFeature = x$1;
        }

        public java.util.List<String> indexNames() {
            return this.indexNames;
        }

        public void indexNames_$eq(java.util.List<String> x$1) {
            this.indexNames = x$1;
        }

        @Override
        public String[] unparse() {
            String[] names = this.indexNames() == null || this.indexNames().isEmpty() ? (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)) : (String[])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.indexNames()).asScala()).flatMap((Function1 & Serializable)n -> new .colon.colon((Object)"--geomesa.index", (List)new .colon.colon(n, (List)Nil$.MODULE$)))).toArray(ClassTag$.MODULE$.apply(String.class));
            return (String[])Array$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[][]{InputFeatureArgs.unparse$(this), InputDataStoreArgs.unparse$(this), InputCqlArgs.unparse$(this), names}), ClassTag$.MODULE$.apply(String.class));
        }

        public WriteIndexArgs(String[] args) {
            super(args);
            InputFeatureArgs.$init$(this);
            InputDataStoreArgs.$init$(this);
            InputCqlArgs.$init$(this);
            this.indexNames = new ArrayList<String>();
        }
    }
}

