/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.geotools.data.DataStoreFinder;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloIndexAdapter;
import org.locationtech.geomesa.accumulo.data.AccumuloWritableFeature$;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloFileOutputFormat$;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.package;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.package$Configurator$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WriteConverter;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.partition.TablePartition;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005s!\u0002\u001c8\u0011\u0003!e!\u0002$8\u0011\u00039\u0005\"\u0002-\u0002\t\u0003I\u0006b\u0002.\u0002\u0005\u0004%\ta\u0017\u0005\u0007I\u0006\u0001\u000b\u0011\u0002/\t\u000f\u0015\f!\u0019!C\u00017\"1a-\u0001Q\u0001\nqCQaZ\u0001\u0005\u0002!4a!a\u001a\u0002\u0001\u0005%\u0004B\u0002-\t\t\u0003\ty*\u0002\u0004\u0002&\"\u0001\u0011q\u0015\u0005\u000bq\"\u0001\r\u00111A\u0005\n\u00055\u0006bCAX\u0011\u0001\u0007\t\u0019!C\u0005\u0003cC!\"a.\t\u0001\u0004\u0005\t\u0015)\u0003z\u0011-\ty\u0002\u0003a\u0001\u0002\u0004%I!!/\t\u0017\u0005m\u0006\u00021AA\u0002\u0013%\u0011Q\u0018\u0005\f\u0003\u0003D\u0001\u0019!A!B\u0013\t\t\u0003C\u0006\u0002D\"\u0001\r\u00111A\u0005\n\u0005\u0015\u0007bCA|\u0011\u0001\u0007\t\u0019!C\u0005\u0003sD1\"!@\t\u0001\u0004\u0005\t\u0015)\u0003\u0002H\"Y\u0011q \u0005A\u0002\u0003\u0007I\u0011\u0002B\u0001\u0011-\u0011)\u0002\u0003a\u0001\u0002\u0004%IAa\u0006\t\u0017\tm\u0001\u00021A\u0001B\u0003&!1\u0001\u0005\f\u0005;A\u0001\u0019!a\u0001\n\u0013\u0011y\u0002C\u0006\u0003^!\u0001\r\u00111A\u0005\n\t}\u0003b\u0003B\u001d\u0011\u0001\u0007\t\u0011)Q\u0005\u0005CA\u0011Ba\u001f\t\u0005\u0004%IA! \t\u0011\tU\u0005\u0002)A\u0005\u0005\u007fB\u0011Ba&\t\u0005\u0004%IA!'\t\u0011\tm\u0005\u0002)A\u0005\u0003\u0007C1B!(\t\u0001\u0004\u0005\r\u0011\"\u0003\u0003 \"Y!q\u0015\u0005A\u0002\u0003\u0007I\u0011\u0002BU\u0011-\u0011i\u000b\u0003a\u0001\u0002\u0003\u0006KA!)\t\u0017\t=\u0006\u00021AA\u0002\u0013%!q\u0014\u0005\f\u0005cC\u0001\u0019!a\u0001\n\u0013\u0011\u0019\fC\u0006\u00038\"\u0001\r\u0011!Q!\n\t\u0005\u0006b\u0003B]\u0011\u0001\u0007\t\u0019!C\u0005\u0005?C1Ba/\t\u0001\u0004\u0005\r\u0011\"\u0003\u0003>\"Y!\u0011\u0019\u0005A\u0002\u0003\u0005\u000b\u0015\u0002BQ\u0011\u001d\u0011\u0019\r\u0003C!\u0005\u000bDqAa4\t\t\u0003\u0012\t\u000eC\u0004\u0003V\"!\tEa6\u0007\r\t\r\u0018\u0001\u0001Bs\u0011\u0019A&\u0006\"\u0001\u0003t\u00161!q\u001f\u0016\u0001\u0005sD1B!@+\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0000\"Y1\u0011\u0001\u0016A\u0002\u0003\u0007I\u0011BB\u0002\u0011-\u00199A\u000ba\u0001\u0002\u0003\u0006K!!\u0007\t\u0017\r%!\u00061AA\u0002\u0013%11\u0002\u0005\f\u00077Q\u0003\u0019!a\u0001\n\u0013\u0019i\u0002C\u0006\u0004\")\u0002\r\u0011!Q!\n\r5\u0001b\u0002BbU\u0011\u000531\u0005\u0005\b\u0005\u001fTC\u0011IB\u0016\u0011\u001d\u0019yC\u000bC!\u0007c\tqdR3p\u001b\u0016\u001c\u0018-Q2dk6,Hn\u001c$jY\u0016|U\u000f\u001e9vi\u001a{'/\\1u\u0015\tA\u0014(A\u0005nCB\u0014X\rZ;dK*\u0011!hO\u0001\u0005U>\u00147O\u0003\u0002={\u0005A\u0011mY2v[VdwN\u0003\u0002?\u007f\u00059q-Z8nKN\f'B\u0001!B\u00031awnY1uS>tG/Z2i\u0015\u0005\u0011\u0015aA8sO\u000e\u0001\u0001CA#\u0002\u001b\u00059$aH$f_6+7/Y!dGVlW\u000f\\8GS2,w*\u001e;qkR4uN]7biN\u0019\u0011\u0001\u0013(\u0011\u0005%cU\"\u0001&\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0003\r\u0005s\u0017PU3g!\tye+D\u0001Q\u0015\t\t&+\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002T)\u0006AA/\u001f9fg\u00064WMC\u0001V\u0003\r\u0019w.\\\u0005\u0003/B\u00131\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001R\u0001\n\r&dWm\u001d)bi\",\u0012\u0001\u0018\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\fA\u0001\\1oO*\t\u0011-\u0001\u0003kCZ\f\u0017BA2_\u0005\u0019\u0019FO]5oO\u0006Qa)\u001b7fgB\u000bG\u000f\u001b\u0011\u0002\u0015M\u0003H.\u001b;t!\u0006$\b.A\u0006Ta2LGo\u001d)bi\"\u0004\u0013!C2p]\u001aLw-\u001e:f)1IGn^@\u0002\u001e\u0005U\u0012QIA(!\tI%.\u0003\u0002l\u0015\n!QK\\5u\u0011\u0015iw\u00011\u0001o\u0003\rQwN\u0019\t\u0003_Vl\u0011\u0001\u001d\u0006\u0003qET!A]:\u0002\r!\fGm\\8q\u0015\t!\u0018)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003mB\u00141AS8c\u0011\u0015Ax\u00011\u0001z\u0003\t!7\u000f\u0005\u0002{{6\t1P\u0003\u0002}w\u0005!A-\u0019;b\u0013\tq8PA\tBG\u000e,X.\u001e7p\t\u0006$\u0018m\u0015;pe\u0016Dq!!\u0001\b\u0001\u0004\t\u0019!\u0001\u0004qCJ\fWn\u001d\t\t\u0003\u000b\t\u0019\"!\u0007\u0002\u001a9!\u0011qAA\b!\r\tIAS\u0007\u0003\u0003\u0017Q1!!\u0004D\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0003&\u0002\rA\u0013X\rZ3g\u0013\u0011\t)\"a\u0006\u0003\u00075\u000b\u0007OC\u0002\u0002\u0012)\u0003B!!\u0002\u0002\u001c%\u00191-a\u0006\t\u000f\u0005}q\u00011\u0001\u0002\"\u0005\u00191O\u001a;\u0011\t\u0005\r\u0012\u0011G\u0007\u0003\u0003KQA!a\n\u0002*\u000511/[7qY\u0016TA!a\u000b\u0002.\u00059a-Z1ukJ,'bAA\u0018\u0003\u00069q\u000e]3oO&\u001c\u0018\u0002BA\u001a\u0003K\u0011\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011\u001d\t9d\u0002a\u0001\u0003s\taa\\;uaV$\b\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}\u0012/\u0001\u0002gg&!\u00111IA\u001f\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005\u001ds\u00011\u0001\u0002J\u0005)\u0011N\u001c3fqB)\u0011*a\u0013\u0002\u001a%\u0019\u0011Q\n&\u0003\r=\u0003H/[8o\u0011\u001d\t\tf\u0002a\u0001\u0003'\n!\u0002]1si&$\u0018n\u001c8t!\u0015I\u00151JA+!\u0019\t9&!\u0019\u0002\u001a9!\u0011\u0011LA/\u001d\u0011\tI!a\u0017\n\u0003-K1!a\u0018K\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0019\u0002f\t\u00191+Z9\u000b\u0007\u0005}#J\u0001\nBG\u000e,X.\u001e7p\r&dW-T1qa\u0016\u00148\u0003\u0002\u0005\u0002l9\u00032b\\A7\u0003c\ni(a!\u0002\u0010&\u0019\u0011q\u000e9\u0003\r5\u000b\u0007\u000f]3s!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$bAA<c\u0006\u0011\u0011n\\\u0005\u0005\u0003w\n)H\u0001\u0005Xe&$\u0018M\u00197f!\u0011\t\u0019#a \n\t\u0005\u0005\u0015Q\u0005\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0011\t\u0005\u0015\u0015\u0011\u0012\b\u0004\u000b\u0006\u001d\u0015bAA0o%!\u00111RAG\u0005-!\u0016M\u00197f\u0003:$7*Z=\u000b\u0007\u0005}s\u0007\u0005\u0003\u0002\u0012\u0006mUBAAJ\u0015\ra\u0018Q\u0013\u0006\u0005\u0003/\u000bI*\u0001\u0003d_J,'B\u0001\u001ft\u0013\u0011\ti*a%\u0003\u000bY\u000bG.^3\u0015\u0005\u0005\u0005\u0006cAAR\u00115\t\u0011A\u0001\u0006NCB\u001cuN\u001c;fqR\u0004B!a\u001b\u0002*&!\u00111VA7\u0005\u001d\u0019uN\u001c;fqR,\u0012!_\u0001\u0007IN|F%Z9\u0015\u0007%\f\u0019\f\u0003\u0005\u000262\t\t\u00111\u0001z\u0003\rAH%M\u0001\u0004IN\u0004SCAA\u0011\u0003\u001d\u0019h\r^0%KF$2![A`\u0011%\t)lDA\u0001\u0002\u0004\t\t#\u0001\u0003tMR\u0004\u0013aB<sCB\u0004XM]\u000b\u0003\u0003\u000f\u0004b!!3\u0002j\u0006=h\u0002BAf\u0003GtA!!4\u0002^:!\u0011qZAn\u001d\u0011\t\t.!7\u000f\t\u0005M\u0017q\u001b\b\u0005\u0003\u0013\t).C\u0001C\u0013\t\u0001\u0015)\u0003\u0002?\u007f%\u0019\u0011qI\u001f\n\t\u0005}\u0017\u0011]\u0001\u0004CBL'bAA${%!\u0011Q]At\u0003=9&/\u001b;bE2,g)Z1ukJ,'\u0002BAp\u0003CLA!a;\u0002n\nqa)Z1ukJ,wK]1qa\u0016\u0014(\u0002BAs\u0003O\u0004B!!=\u0002t6\u0011\u0011q]\u0005\u0005\u0003k\f9OA\bXe&$\u0018M\u00197f\r\u0016\fG/\u001e:f\u0003-9(/\u00199qKJ|F%Z9\u0015\u0007%\fY\u0010C\u0005\u00026J\t\t\u00111\u0001\u0002H\u0006AqO]1qa\u0016\u0014\b%A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014XC\u0001B\u0002!\u0015I\u00151\nB\u0003!\u0011\u00119A!\u0005\u000e\u0005\t%!\u0002\u0002B\u0006\u0005\u001b\t\u0011\u0002]1si&$\u0018n\u001c8\u000b\t\t=\u0011\u0011]\u0001\u0005G>tg-\u0003\u0003\u0003\u0014\t%!A\u0004+bE2,\u0007+\u0019:uSRLwN\\\u0001\u0010a\u0006\u0014H/\u001b;j_:,'o\u0018\u0013fcR\u0019\u0011N!\u0007\t\u0013\u0005UV#!AA\u0002\t\r\u0011\u0001\u00049beRLG/[8oKJ\u0004\u0013aB<sSR,'o]\u000b\u0003\u0005C\u0001b!a\u0016\u0002b\t\r\u0002cB%\u0003&\t%\"qJ\u0005\u0004\u0005OQ%A\u0002+va2,'\u0007\r\u0004\u0003,\tU\"1\n\t\t\u0003c\u0014iC!\r\u0003J%!!qFAt\u0005M9Um\\'fg\u00064U-\u0019;ve\u0016Le\u000eZ3y!\u0011\u0011\u0019D!\u000e\r\u0001\u0011Y!qG\r\u0002\u0002\u0003\u0005)\u0011\u0001B\u001e\u0005\ryFeM\u0001\toJLG/\u001a:tAE!!Q\bB\"!\rI%qH\u0005\u0004\u0005\u0003R%a\u0002(pi\"Lgn\u001a\t\u0004\u0013\n\u0015\u0013b\u0001B$\u0015\n\u0019\u0011I\\=\u0011\t\tM\"1\n\u0003\f\u0005\u001bJ\u0012\u0011!A\u0001\u0006\u0003\u0011YDA\u0002`IQ\u0002DA!\u0015\u0003ZA1\u0011\u0011\u001fB*\u0005/JAA!\u0016\u0002h\nqqK]5uK\u000e{gN^3si\u0016\u0014\b\u0003\u0002B\u001a\u00053\"1Ba\u0017\u001a\u0003\u0003\u0005\tQ!\u0001\u0003<\t\u0019q\fJ\u001b\u0002\u0017]\u0014\u0018\u000e^3sg~#S-\u001d\u000b\u0004S\n\u0005\u0004\"CA[1\u0005\u0005\t\u0019\u0001B2!\u0019\t9&!\u0019\u0003fA9\u0011J!\n\u0003h\tM\u0004G\u0002B5\u0005[\u0012\t\b\u0005\u0005\u0002r\n5\"1\u000eB8!\u0011\u0011\u0019D!\u001c\u0005\u0019\t]\"\u0011MA\u0001\u0002\u0003\u0015\tAa\u000f\u0011\t\tM\"\u0011\u000f\u0003\r\u0005\u001b\u0012\t'!A\u0001\u0002\u000b\u0005!1\b\u0019\u0005\u0005k\u0012I\b\u0005\u0004\u0002r\nM#q\u000f\t\u0005\u0005g\u0011I\b\u0002\u0007\u0003\\\t\u0005\u0014\u0011!A\u0001\u0006\u0003\u0011Y$\u0001\u0005wSN\u001c\u0015m\u00195f+\t\u0011y\b\u0005\u0003\u0003\u0002\n=e\u0002\u0002BB\u0005\u0017sAA!\"\u0003\n:!\u0011q\u001aBD\u0013\taT(\u0003\u0002}w%\u0019!QR>\u0002)\u0005\u001b7-^7vY>Le\u000eZ3y\u0003\u0012\f\u0007\u000f^3s\u0013\u0011\u0011\tJa%\u0003\u001fYK7/\u001b2jY&$\u0018pQ1dQ\u0016T1A!$|\u0003%1\u0018n]\"bG\",\u0007%A\u0006uC\ndW-\u00118e\u0017\u0016LXCAAB\u00031!\u0018M\u00197f\u0003:$7*Z=!\u0003!1W-\u0019;ve\u0016\u001cXC\u0001BQ!\ry'1U\u0005\u0004\u0005K\u0003(aB\"pk:$XM]\u0001\rM\u0016\fG/\u001e:fg~#S-\u001d\u000b\u0004S\n-\u0006\"CA[?\u0005\u0005\t\u0019\u0001BQ\u0003%1W-\u0019;ve\u0016\u001c\b%A\u0004f]R\u0014\u0018.Z:\u0002\u0017\u0015tGO]5fg~#S-\u001d\u000b\u0004S\nU\u0006\"CA[E\u0005\u0005\t\u0019\u0001BQ\u0003!)g\u000e\u001e:jKN\u0004\u0013A\u00024bS2,G-\u0001\u0006gC&dW\rZ0%KF$2!\u001bB`\u0011%\t),JA\u0001\u0002\u0004\u0011\t+A\u0004gC&dW\r\u001a\u0011\u0002\u000bM,G/\u001e9\u0015\u0007%\u00149\rC\u0004\u0003J\u001e\u0002\rAa3\u0002\u000f\r|g\u000e^3yiB\u0019!Q\u001a\u0006\u000e\u0003!\tqa\u00197fC:,\b\u000fF\u0002j\u0005'DqA!3)\u0001\u0004\u0011Y-A\u0002nCB$r!\u001bBm\u0005;\u0014\t\u000fC\u0004\u0003\\&\u0002\r!!\u001d\u0002\u0007-,\u0017\u0010C\u0004\u0003`&\u0002\r!! \u0002\u000bY\fG.^3\t\u000f\t%\u0017\u00061\u0001\u0003L\n\u0019\u0012iY2v[VdwNR5mKJ+G-^2feN\u0019!Fa:\u0011\u0017=\u0014I/a!\u0002\u0010\n5\u0018qR\u0005\u0004\u0005W\u0004(a\u0002*fIV\u001cWM\u001d\t\u0005\u0003#\u0013y/\u0003\u0003\u0003r\u0006M%aA&fsR\u0011!Q\u001f\t\u0004\u0003GS#A\u0004*fIV\u001cWM]\"p]R,\u0007\u0010\u001e\t\u0005\u0005O\u0014Y0\u0003\u0003\u0002,\n%\u0018AA5e+\t\tI\"\u0001\u0004jI~#S-\u001d\u000b\u0004S\u000e\u0015\u0001\"CA[]\u0005\u0005\t\u0019AA\r\u0003\rIG\rI\u0001\u0004_V$XCAB\u0007!!\u0019yaa\u0006\u0003n\u0006=UBAB\t\u0015\u0011\t9da\u0005\u000b\u0007\rU\u0001/A\u0002mS\nLAa!\u0007\u0004\u0012\tyQ*\u001e7uSBdWmT;uaV$8/A\u0004pkR|F%Z9\u0015\u0007%\u001cy\u0002C\u0005\u00026F\n\t\u00111\u0001\u0004\u000e\u0005!q.\u001e;!)\rI7Q\u0005\u0005\b\u0005\u0013\u001c\u0004\u0019AB\u0014!\r\u0019I\u0003L\u0007\u0002UQ\u0019\u0011n!\f\t\u000f\t%G\u00071\u0001\u0004(\u00051!/\u001a3vG\u0016$r![B\u001a\u0007k\u0019y\u0004C\u0004\u0003\\V\u0002\r!a!\t\u000f\r]R\u00071\u0001\u0004:\u00051a/\u00197vKN\u0004R!XB\u001e\u0003\u001fK1a!\u0010_\u0005!IE/\u001a:bE2,\u0007b\u0002Bek\u0001\u00071q\u0005")
public final class GeoMesaAccumuloFileOutputFormat {
    public static void configure(Job job, AccumuloDataStore ds, scala.collection.immutable.Map<String, String> params, SimpleFeatureType sft, Path output, Option<String> index, Option<Seq<String>> partitions) {
        GeoMesaAccumuloFileOutputFormat$.MODULE$.configure(job, ds, params, sft, output, index, partitions);
    }

    public static String SplitsPath() {
        return GeoMesaAccumuloFileOutputFormat$.MODULE$.SplitsPath();
    }

    public static String FilesPath() {
        return GeoMesaAccumuloFileOutputFormat$.MODULE$.FilesPath();
    }

    public static class AccumuloFileMapper
    extends Mapper<Writable, SimpleFeature, package.TableAndKey, Value>
    implements LazyLogging {
        private AccumuloDataStore ds;
        private SimpleFeatureType sft;
        private WritableFeature.FeatureWrapper<WritableFeature> wrapper;
        private Option<TablePartition> partitioner;
        private Seq<Tuple2<GeoMesaFeatureIndex<?, ?>, WriteConverter<?>>> writers;
        private final AccumuloIndexAdapter.VisibilityCache visCache;
        private final package.TableAndKey tableAndKey;
        private Counter features;
        private Counter entries;
        private Counter failed;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            AccumuloFileMapper accumuloFileMapper = this;
            synchronized (accumuloFileMapper) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private AccumuloDataStore ds() {
            return this.ds;
        }

        private void ds_$eq(AccumuloDataStore x$1) {
            this.ds = x$1;
        }

        private SimpleFeatureType sft() {
            return this.sft;
        }

        private void sft_$eq(SimpleFeatureType x$1) {
            this.sft = x$1;
        }

        private WritableFeature.FeatureWrapper<WritableFeature> wrapper() {
            return this.wrapper;
        }

        private void wrapper_$eq(WritableFeature.FeatureWrapper<WritableFeature> x$1) {
            this.wrapper = x$1;
        }

        private Option<TablePartition> partitioner() {
            return this.partitioner;
        }

        private void partitioner_$eq(Option<TablePartition> x$1) {
            this.partitioner = x$1;
        }

        private Seq<Tuple2<GeoMesaFeatureIndex<?, ?>, WriteConverter<?>>> writers() {
            return this.writers;
        }

        private void writers_$eq(Seq<Tuple2<GeoMesaFeatureIndex<?, ?>, WriteConverter<?>>> x$1) {
            this.writers = x$1;
        }

        private AccumuloIndexAdapter.VisibilityCache visCache() {
            return this.visCache;
        }

        private package.TableAndKey tableAndKey() {
            return this.tableAndKey;
        }

        private Counter features() {
            return this.features;
        }

        private void features_$eq(Counter x$1) {
            this.features = x$1;
        }

        private Counter entries() {
            return this.entries;
        }

        private void entries_$eq(Counter x$1) {
            this.entries = x$1;
        }

        private Counter failed() {
            return this.failed;
        }

        private void failed_$eq(Counter x$1) {
            this.failed = x$1;
        }

        public void setup(Mapper.Context context) {
            java.util.Map params = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration())).asJava();
            this.ds_$eq((AccumuloDataStore)DataStoreFinder.getDataStore((java.util.Map)params));
            Predef$.MODULE$.require(this.ds() != null, (Function0 & Serializable)() -> "Could not find data store - check your configuration and hbase-site.xml");
            this.sft_$eq(this.ds().getSchema(package$Configurator$.MODULE$.getTypeName(context.getConfiguration())));
            Predef$.MODULE$.require(this.sft() != null, (Function0 & Serializable)() -> "Could not find schema - check your configuration");
            Seq indexIds = (Seq)GeoMesaConfigurator$.MODULE$.getIndicesOut(context.getConfiguration()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Predef$.MODULE$.require(indexIds != null, (Function0 & Serializable)() -> "Indices to write was not set in the job configuration");
            Seq indices = (Seq)indexIds.map((Function1 & Serializable)x$13 -> this.ds().manager().index(this.sft(), x$13, IndexMode$.MODULE$.Write()));
            this.wrapper_$eq((WritableFeature.FeatureWrapper<WritableFeature>)AccumuloWritableFeature$.MODULE$.wrapper(this.sft(), this.ds().adapter().groups(), indices));
            this.partitioner_$eq((Option<TablePartition>)TablePartition$.MODULE$.apply((package.HasGeoMesaMetadata)this.ds(), this.sft()));
            this.writers_$eq((Seq)indices.map((Function1 & Serializable)i -> new Tuple2(i, (Object)i.createConverter())));
            this.features_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat.OutputCounters$.MODULE$.Written()));
            this.entries_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), "entries"));
            this.failed_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat.OutputCounters$.MODULE$.Failed()));
        }

        public void cleanup(Mapper.Context context) {
            if (this.ds() != null) {
                this.ds().dispose();
                return;
            }
        }

        public void map(Writable key, SimpleFeature value, Mapper.Context context) {
            try {
                WritableFeature.FeatureWrapper<WritableFeature> qual$1 = this.wrapper();
                SimpleFeature x$1 = value;
                boolean x$2 = qual$1.wrap$default$2();
                WritableFeature feature = qual$1.wrap(x$1, x$2);
                Option partition = this.partitioner().map((Function1 & Serializable)x$14 -> x$14.partition(value));
                this.writers().foreach((Function1 & Serializable)x0$1 -> {
                    AccumuloFileMapper.$anonfun$map$2(this, partition, feature, context, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.features().increment(1L);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(22).append("Error writing feature ").append(Option$.MODULE$.apply((Object)value).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString(), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.failed().increment(1L);
                }
                throw throwable;
            }
        }

        public static final /* synthetic */ void $anonfun$map$5(AccumuloFileMapper $this, package.SingleRowKeyValue x2$1, Mapper.Context context$1, package.KeyValue value) {
            $this.tableAndKey().setKey(new Key(x2$1.row(), value.cf(), value.cq(), $this.visCache().apply(value.vis()), Long.MAX_VALUE));
            context$1.write((Object)$this.tableAndKey(), (Object)new Value(value.value()));
            $this.entries().increment(1L);
        }

        public static final /* synthetic */ void $anonfun$map$7(AccumuloFileMapper $this, byte[] row$1, Mapper.Context context$1, package.KeyValue value) {
            $this.tableAndKey().setKey(new Key(row$1, value.cf(), value.cq(), $this.visCache().apply(value.vis()), Long.MAX_VALUE));
            context$1.write((Object)$this.tableAndKey(), (Object)new Value(value.value()));
            $this.entries().increment(1L);
        }

        public static final /* synthetic */ void $anonfun$map$6(AccumuloFileMapper $this, package.MultiRowKeyValue x3$1, Mapper.Context context$1, byte[] row) {
            x3$1.values().foreach((Function1 & Serializable)value -> {
                AccumuloFileMapper.$anonfun$map$7($this, row, context$1, value);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$map$2(AccumuloFileMapper $this, Option partition$1, WritableFeature feature$1, Mapper.Context context$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SeqOps seqOps;
                GeoMesaFeatureIndex index = (GeoMesaFeatureIndex)tuple2._1();
                WriteConverter writer = (WriteConverter)tuple2._2();
                Seq seq = index.getTableNames(partition$1);
                if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0) {
                    String msg = seq.isEmpty() ? "No table found" : "Multiple tables found";
                    throw new IllegalStateException(new StringBuilder(0).append(msg).append(partition$1.map((Function1 & Serializable)p -> new StringBuilder(15).append(" for partition ").append((String)p).toString()).getOrElse((Function0 & Serializable)() -> "")).toString());
                }
                String table = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                $this.tableAndKey().getTable().set(table);
                package.RowKeyValue rowKeyValue = writer.convert(feature$1, writer.convert$default$2());
                if (rowKeyValue instanceof package.SingleRowKeyValue) {
                    package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                    singleRowKeyValue.values().foreach((Function1 & Serializable)value -> {
                        AccumuloFileMapper.$anonfun$map$5($this, singleRowKeyValue, context$1, value);
                        return BoxedUnit.UNIT;
                    });
                } else if (rowKeyValue instanceof package.MultiRowKeyValue) {
                    package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                    multiRowKeyValue.rows().foreach((Function1 & Serializable)row -> {
                        AccumuloFileMapper.$anonfun$map$6($this, multiRowKeyValue, context$1, row);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    throw new MatchError((Object)rowKeyValue);
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public AccumuloFileMapper() {
            LazyLogging.$init$((LazyLogging)this);
            this.visCache = new AccumuloIndexAdapter.VisibilityCache();
            this.tableAndKey = new package.TableAndKey(new Text(), null);
        }
    }

    public static class AccumuloFileReducer
    extends Reducer<package.TableAndKey, Value, Key, Value> {
        private String id;
        private MultipleOutputs<Key, Value> out;

        private String id() {
            return this.id;
        }

        private void id_$eq(String x$1) {
            this.id = x$1;
        }

        private MultipleOutputs<Key, Value> out() {
            return this.out;
        }

        private void out_$eq(MultipleOutputs<Key, Value> x$1) {
            this.out = x$1;
        }

        public void setup(Reducer.Context context) {
            this.id_$eq(context.getJobID().appendTo(new StringBuilder("gm")).toString());
            this.out_$eq((MultipleOutputs<Key, Value>)new MultipleOutputs((TaskInputOutputContext)context));
        }

        public void cleanup(Reducer.Context context) {
            if (this.out() != null) {
                this.out().close();
                return;
            }
        }

        public void reduce(package.TableAndKey key, Iterable<Value> values, Reducer.Context context) {
            String path = new StringBuilder(1).append(key.getTable()).append("/").append(this.id()).toString();
            Iterator<Value> iter = values.iterator();
            while (iter.hasNext()) {
                this.out().write((Object)key.getKey(), (Object)iter.next(), path);
            }
        }
    }
}

