/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.hadoop.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.hadoop.mapreduce.InputFormatBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.Query;
import org.locationtech.geomesa.accumulo.data.AccumuloClientConfig$;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStoreParams$;
import org.locationtech.geomesa.accumulo.data.AccumuloQueryPlan;
import org.locationtech.geomesa.accumulo.jobs.AccumuloJobUtils$;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloInputFormat;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.utils.io.WithStore$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GeoMesaAccumuloInputFormat$
implements LazyLogging {
    public static final GeoMesaAccumuloInputFormat$ MODULE$ = new GeoMesaAccumuloInputFormat$();
    private static final String SYS_PROP_SPARK_LOAD_CP;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        SYS_PROP_SPARK_LOAD_CP = "org.locationtech.geomesa.spark.load-classpath";
    }

    private Logger logger$lzycompute() {
        GeoMesaAccumuloInputFormat$ geoMesaAccumuloInputFormat$ = this;
        synchronized (geoMesaAccumuloInputFormat$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String SYS_PROP_SPARK_LOAD_CP() {
        return SYS_PROP_SPARK_LOAD_CP;
    }

    public void configure(Configuration conf, Map<String, ?> params, Query query) {
        AccumuloQueryPlan plan = (AccumuloQueryPlan)WithStore$.MODULE$.apply(params).apply((Function1 & Serializable)ds -> {
            Predef$.MODULE$.require(ds != null, (Function0 & Serializable)() -> "Invalid data store parameters");
            return AccumuloJobUtils$.MODULE$.getSingleQueryPlan((AccumuloDataStore)ds, query);
        });
        this.configure(conf, params, plan);
    }

    public void configure(Configuration conf, Map<String, ?> params, AccumuloQueryPlan plan) {
        Option auths = AccumuloDataStoreParams$.MODULE$.AuthsParam().lookupOpt(params).map((Function1 & Serializable)a -> new Authorizations(a.split(",")));
        this.configure(conf, params, plan, (Option<Authorizations>)auths);
    }

    public void configure(Configuration conf, Map<String, ?> params, AccumuloQueryPlan plan, Option<Authorizations> auths) {
        Job job = new Job(conf);
        job.setInputFormatClass(GeoMesaAccumuloInputFormat.class);
        Properties props = new Properties();
        props.put(ClientProperty.INSTANCE_NAME.getKey(), AccumuloDataStoreParams$.MODULE$.InstanceNameParam().lookup(params));
        props.put(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), AccumuloDataStoreParams$.MODULE$.ZookeepersParam().lookup(params));
        Option password = AccumuloDataStoreParams$.MODULE$.PasswordParam().lookupOpt(params);
        password.orElse((Function0 & Serializable)() -> AccumuloDataStoreParams$.MODULE$.KeytabPathParam().lookupOpt(params)).foreach((Function1 & Serializable)token -> {
            props.put(ClientProperty.AUTH_PRINCIPAL.getKey(), AccumuloDataStoreParams$.MODULE$.UserParam().lookup(params));
            props.put(ClientProperty.AUTH_TOKEN.getKey(), token);
            if (password.isDefined()) {
                return props.put(ClientProperty.AUTH_TYPE.getKey(), AccumuloClientConfig$.MODULE$.PasswordAuthType());
            }
            props.put(ClientProperty.AUTH_TYPE.getKey(), AccumuloClientConfig$.MODULE$.KerberosAuthType());
            return props.put(ClientProperty.SASL_ENABLED.getKey(), "true");
        });
        Predef$.MODULE$.require(plan.tables().lengthCompare(1) == 0, (Function0 & Serializable)() -> new StringBuilder(36).append("Can only query from a single table: ").append(plan.tables().mkString(", ")).toString());
        InputFormatBuilder.InputFormatOptions builder = AccumuloInputFormat.configure().clientProperties(props).table((String)plan.tables().head()).batchScan(true);
        auths.foreach((Function1 & Serializable)x$1 -> builder.auths(x$1));
        Object object = plan.ranges().nonEmpty() ? builder.ranges((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)plan.ranges()).asJava()) : BoxedUnit.UNIT;
        plan.columnFamily().foreach((Function1 & Serializable)colFamily -> builder.fetchColumns(Collections.singletonList(new IteratorSetting.Column(colFamily))));
        plan.iterators().foreach((Function1 & Serializable)x$1 -> builder.addIterator(x$1));
        builder.store((Object)job);
        conf.addResource(job.getConfiguration());
        GeoMesaConfigurator$.MODULE$.setResultsToFeatures(conf, plan.resultsToFeatures());
        plan.reducer().foreach((Function1 & Serializable)x$4 -> {
            GeoMesaConfigurator$.MODULE$.setReducer(conf, x$4);
            return BoxedUnit.UNIT;
        });
        plan.sort().foreach((Function1 & Serializable)x$5 -> {
            GeoMesaConfigurator$.MODULE$.setSorting(conf, x$5);
            return BoxedUnit.UNIT;
        });
        plan.projection().foreach((Function1 & Serializable)x$6 -> {
            GeoMesaConfigurator$.MODULE$.setProjection(conf, x$6);
            return BoxedUnit.UNIT;
        });
    }

    public void ensureSparkClasspath() {
        BoxedUnit boxedUnit;
        ClassLoader sysLoader = ClassLoader.getSystemClassLoader();
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl == null || !ccl.getClass().getCanonicalName().startsWith("org.apache.spark.")) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("No spark context classloader found");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return;
        }
        if (!(ccl instanceof URLClassLoader)) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Found context classloader, but can't handle type {}", (Object)ccl.getClass().getCanonicalName());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            return;
        }
        if (!(sysLoader instanceof URLClassLoader)) {
            BoxedUnit boxedUnit4;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Found context classloader, but can't add to type {}", (Object)sysLoader.getClass().getCanonicalName());
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            return;
        }
        Method addUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addUrl.setAccessible(true);
        Set sysUrls = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((URLClassLoader)sysLoader).getURLs()), (Function1 & Serializable)x$7 -> x$7.toString(), ClassTag$.MODULE$.apply(String.class))).toSet();
        Tuple2 tuple2 = ArrayOps$.MODULE$.partition$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])((URLClassLoader)ccl).getURLs()), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)GeoMesaAccumuloInputFormat$.$anonfun$ensureSparkClasspath$2(x$8)))), (Function1 & Serializable)url -> BoxesRunTime.boxToBoolean((boolean)sysUrls.contains((Object)url.toString())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        URL[] dupeUrls = (URL[])tuple2._1();
        URL[] newUrls = (URL[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dupeUrls, (Object)newUrls);
        URL[] dupeUrls2 = (URL[])tuple22._1();
        URL[] newUrls2 = (URL[])tuple22._2();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])newUrls2), (Function1 & Serializable)x$10 -> addUrl.invoke((Object)sysLoader, x$10));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(98).append("Loaded ").append(newUrls2.length).append(" urls from context classloader into system classloader ").append("and ignored ").append(dupeUrls2.length).append(" that are already loaded").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$ensureSparkClasspath$2(URL x$8) {
        return x$8.toString().contains("__app__.jar");
    }

    private GeoMesaAccumuloInputFormat$() {
    }
}

