/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.jobs.mapreduce.interop;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.geotools.data.Query;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.interop.GeoMesaAccumuloInputFormat;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureCountJob {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        Job job = Job.getInstance((Configuration)conf, (String)"simple feature count");
        job.setJarByClass(FeatureCountJob.class);
        job.setMapperClass(MyMapper.class);
        job.setInputFormatClass(GeoMesaAccumuloInputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path("/tmp/myjob"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceId", "myinstance");
        params.put("zookeepers", "zoo1,zoo2,zoo3");
        params.put("user", "myuser");
        params.put("password", "mypassword");
        params.put("tableName", "mycatalog");
        Query query = new Query("myfeature", ECQL.toFilter((String)"BBOX(geom, -165,5,-50,75)"));
        GeoMesaAccumuloInputFormat.configure(job, params, query);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class MyMapper
    extends Mapper<Text, SimpleFeature, Text, Text> {
        public void map(Text key, SimpleFeature value, Mapper.Context context) throws IOException, InterruptedException {
            Counter counter = context.getCounter(CountersEnum.class.getName(), CountersEnum.FEATURES.toString());
            counter.increment(1L);
            context.write((Object)key, (Object)new Text(value.getDefaultGeometry().toString()));
        }

        static enum CountersEnum {
            FEATURES;

        }
    }
}

