/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.jobs.mapreduce.interop;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.Query;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.interop.GeoMesaAccumuloInputFormat;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.jobs.interop.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureWriterJob {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        Job job = Job.getInstance((Configuration)conf, (String)"simple feature writer");
        job.setJarByClass(FeatureWriterJob.class);
        job.setMapperClass(MyMapper.class);
        job.setInputFormatClass(GeoMesaAccumuloInputFormat.class);
        job.setOutputFormatClass(GeoMesaOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(ScalaSimpleFeature.class);
        job.setNumReduceTasks(0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceId", "myinstance");
        params.put("zookeepers", "zoo1,zoo2,zoo3");
        params.put("user", "myuser");
        params.put("password", "mypassword");
        params.put("tableName", "mycatalog");
        Query query = new Query("myfeature", ECQL.toFilter((String)"BBOX(geom, -165,5,-50,75)"));
        GeoMesaAccumuloInputFormat.configure(job, params, query);
        HashMap<String, String> outParams = new HashMap<String, String>();
        outParams.put("instanceId", "myinstance");
        outParams.put("zookeepers", "zoo1,zoo2,zoo3");
        outParams.put("user", "myuser");
        outParams.put("password", "mypassword");
        outParams.put("tableName", "mycatalog_2");
        DataStore ds = DataStoreFinder.getDataStore(params);
        SimpleFeatureType sft = ds.getSchema(query.getTypeName());
        GeoMesaOutputFormat.setOutput((Configuration)job.getConfiguration(), outParams, (SimpleFeatureType)sft);
        ds.dispose();
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class MyMapper
    extends Mapper<Text, SimpleFeature, Text, SimpleFeature> {
        Text text = new Text();
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType("test", "dtg:Date,*geom:Point:srid=4326");

        public void map(Text key, SimpleFeature value, Mapper.Context context) throws IOException, InterruptedException {
            Counter counter = context.getCounter(CountersEnum.class.getName(), CountersEnum.FEATURES.toString());
            counter.increment(1L);
            Object[] values = new Object[]{value.getAttribute("dtg"), value.getAttribute("geom")};
            ScalaSimpleFeature feature = new ScalaSimpleFeature(this.sft, value.getID(), values, null);
            context.write((Object)this.text, (Object)feature);
        }

        static enum CountersEnum {
            FEATURES;

        }
    }
}

