/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.jobs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.hadoop.conf.Configuration;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloQueryPlan;
import org.locationtech.geomesa.accumulo.index.JoinIndex$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.jobs.JobUtils$;
import org.locationtech.geomesa.utils.classpath.ClassPathUtils$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;

public final class AccumuloJobUtils$
implements LazyLogging {
    public static final AccumuloJobUtils$ MODULE$ = new AccumuloJobUtils$();
    private static List<String> defaultLibJars;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile boolean bitmap$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        AccumuloJobUtils$ accumuloJobUtils$ = this;
        synchronized (accumuloJobUtils$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private List<String> defaultLibJars$lzycompute() {
        AccumuloJobUtils$ accumuloJobUtils$ = this;
        synchronized (accumuloJobUtils$) {
            if (!bitmap$0) {
                String defaultLibJarsFile = "org/locationtech/geomesa/jobs/accumulo-libjars.list";
                Try url2 = Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.getClass().getClassLoader().getResource(defaultLibJarsFile));
                Try source = url2.map((Function1 & Serializable)url -> Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()));
                Try lines = source.map((Function1 & Serializable)x$1 -> x$1.getLines().toList());
                source.foreach((Function1 & Serializable)x$2 -> {
                    x$2.close();
                    return BoxedUnit.UNIT;
                });
                defaultLibJars = (List)lines.get();
                bitmap$0 = true;
            }
        }
        return defaultLibJars;
    }

    public List<String> defaultLibJars() {
        if (!bitmap$0) {
            return this.defaultLibJars$lzycompute();
        }
        return defaultLibJars;
    }

    public Iterator<Function0<Seq<File>>> defaultSearchPath() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(Function0 & Serializable)() -> ClassPathUtils$.MODULE$.getJarsFromEnvironment("GEOMESA_ACCUMULO_HOME", "lib"), (Function0 & Serializable)() -> ClassPathUtils$.MODULE$.getJarsFromEnvironment("ACCUMULO_HOME"), (Function0 & Serializable)() -> ClassPathUtils$.MODULE$.getJarsFromClasspath(AccumuloDataStore.class), (Function0 & Serializable)() -> ClassPathUtils$.MODULE$.getJarsFromClasspath(AccumuloClient.class)}));
    }

    public void setLibJars(Configuration conf, Seq<String> libJars, Iterator<Function0<Seq<File>>> searchPath) {
        JobUtils$.MODULE$.setLibJars(conf, libJars, searchPath);
    }

    public Seq<String> setLibJars$default$2() {
        return this.defaultLibJars();
    }

    public Iterator<Function0<Seq<File>>> setLibJars$default$3() {
        return this.defaultSearchPath();
    }

    public AccumuloQueryPlan getSingleQueryPlan(AccumuloDataStore ds, Query query) {
        AccumuloQueryPlan.EmptyPlan emptyPlan;
        JoinIndex$.MODULE$.AllowJoinPlans().set(BoxesRunTime.boxToBoolean((boolean)false));
        try {
            LazyRef fallbackIndex$lzy = new LazyRef();
            Seq queryPlans = ds.getQueryPlan(query, ds.getQueryPlan$default$2(), ds.getQueryPlan$default$3());
            if (queryPlans.isEmpty()) {
                emptyPlan = new AccumuloQueryPlan.EmptyPlan(new package.FilterStrategy(AccumuloJobUtils$.fallbackIndex$1(fallbackIndex$lzy, ds, query), (Option)None$.MODULE$, (Option)new Some((Object)Filter.EXCLUDE), false, Float.POSITIVE_INFINITY), AccumuloQueryPlan.EmptyPlan$.MODULE$.apply$default$2());
            } else if (queryPlans.lengthCompare(1) > 0) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Desired query plan requires multiple scans - falling back to full table scan");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                Seq qps = ds.getQueryPlan(query, (Option)new Some((Object)AccumuloJobUtils$.fallbackIndex$1(fallbackIndex$lzy, ds, query).identifier()), ds.getQueryPlan$default$3());
                if (qps.lengthCompare(1) > 0 || qps.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AccumuloJobUtils$.$anonfun$getSingleQueryPlan$2(x$3)))) {
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(148).append("The query being executed requires multiple scans, which is not currently supported by GeoMesa. Your result set will be partially incomplete. ").append("Query: ").append(org.locationtech.geomesa.filter.package$.MODULE$.filterToString(query.getFilter())).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                emptyPlan = (AccumuloQueryPlan)qps.head();
            } else {
                BoxedUnit boxedUnit;
                AccumuloQueryPlan qp = (AccumuloQueryPlan)queryPlans.head();
                if (qp.tables().lengthCompare(1) > 0) {
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(148).append("The query being executed requires multiple scans, which is not currently supported by GeoMesa. Your result set will be partially incomplete. ").append("Query: ").append(org.locationtech.geomesa.filter.package$.MODULE$.filterToString(query.getFilter())).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                emptyPlan = qp;
            }
        }
        finally {
            JoinIndex$.MODULE$.AllowJoinPlans().remove();
        }
        return emptyPlan;
    }

    public Seq<AccumuloQueryPlan> getMultipleQueryPlan(AccumuloDataStore ds, Query query) {
        Object object;
        JoinIndex$.MODULE$.AllowJoinPlans().set(BoxesRunTime.boxToBoolean((boolean)false));
        try {
            LazyRef fallbackIndex$lzy = new LazyRef();
            Seq queryPlans = ds.getQueryPlan(query, ds.getQueryPlan$default$2(), ds.getQueryPlan$default$3());
            object = queryPlans.isEmpty() ? new .colon.colon((Object)new AccumuloQueryPlan.EmptyPlan(new package.FilterStrategy(AccumuloJobUtils$.fallbackIndex$2(fallbackIndex$lzy, ds, query), (Option)None$.MODULE$, (Option)new Some((Object)Filter.EXCLUDE), false, Float.POSITIVE_INFINITY), AccumuloQueryPlan.EmptyPlan$.MODULE$.apply$default$2()), (List)Nil$.MODULE$) : queryPlans;
        }
        finally {
            JoinIndex$.MODULE$.AllowJoinPlans().remove();
        }
        return object;
    }

    private static final /* synthetic */ GeoMesaFeatureIndex fallbackIndex$lzycompute$1(LazyRef fallbackIndex$lzy$1, AccumuloDataStore ds$1, Query query$1) {
        GeoMesaFeatureIndex geoMesaFeatureIndex;
        LazyRef lazyRef = fallbackIndex$lzy$1;
        synchronized (lazyRef) {
            GeoMesaFeatureIndex geoMesaFeatureIndex2;
            if (fallbackIndex$lzy$1.initialized()) {
                geoMesaFeatureIndex2 = (GeoMesaFeatureIndex)fallbackIndex$lzy$1.value();
            } else {
                SimpleFeatureType schema = ds$1.getSchema(query$1.getTypeName());
                geoMesaFeatureIndex2 = (GeoMesaFeatureIndex)fallbackIndex$lzy$1.initialize(ds$1.manager().indices(schema, IndexMode$.MODULE$.Read()).headOption().getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(44).append("Schema '").append(schema.getTypeName()).append("' does not have any readable indices").toString());
                }));
            }
            geoMesaFeatureIndex = geoMesaFeatureIndex2;
        }
        return geoMesaFeatureIndex;
    }

    private static final GeoMesaFeatureIndex fallbackIndex$1(LazyRef fallbackIndex$lzy$1, AccumuloDataStore ds$1, Query query$1) {
        if (fallbackIndex$lzy$1.initialized()) {
            return (GeoMesaFeatureIndex)fallbackIndex$lzy$1.value();
        }
        return AccumuloJobUtils$.fallbackIndex$lzycompute$1(fallbackIndex$lzy$1, ds$1, query$1);
    }

    public static final /* synthetic */ boolean $anonfun$getSingleQueryPlan$2(AccumuloQueryPlan x$3) {
        return x$3.tables().lengthCompare(1) > 0;
    }

    private static final /* synthetic */ GeoMesaFeatureIndex fallbackIndex$lzycompute$2(LazyRef fallbackIndex$lzy$2, AccumuloDataStore ds$2, Query query$2) {
        GeoMesaFeatureIndex geoMesaFeatureIndex;
        LazyRef lazyRef = fallbackIndex$lzy$2;
        synchronized (lazyRef) {
            GeoMesaFeatureIndex geoMesaFeatureIndex2;
            if (fallbackIndex$lzy$2.initialized()) {
                geoMesaFeatureIndex2 = (GeoMesaFeatureIndex)fallbackIndex$lzy$2.value();
            } else {
                SimpleFeatureType schema = ds$2.getSchema(query$2.getTypeName());
                geoMesaFeatureIndex2 = (GeoMesaFeatureIndex)fallbackIndex$lzy$2.initialize(ds$2.manager().indices(schema, IndexMode$.MODULE$.Read()).headOption().getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(44).append("Schema '").append(schema.getTypeName()).append("' does not have any readable indices").toString());
                }));
            }
            geoMesaFeatureIndex = geoMesaFeatureIndex2;
        }
        return geoMesaFeatureIndex;
    }

    private static final GeoMesaFeatureIndex fallbackIndex$2(LazyRef fallbackIndex$lzy$2, AccumuloDataStore ds$2, Query query$2) {
        if (fallbackIndex$lzy$2.initialized()) {
            return (GeoMesaFeatureIndex)fallbackIndex$lzy$2.value();
        }
        return AccumuloJobUtils$.fallbackIndex$lzycompute$2(fallbackIndex$lzy$2, ds$2, query$2);
    }

    private AccumuloJobUtils$() {
    }
}

