/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.accumulo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.mapred.AbstractInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.impl.InputConfigurator;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.rdd.NewHadoopRDD;
import org.apache.spark.rdd.RDD;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStoreFactory$;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStoreParams$;
import org.locationtech.geomesa.accumulo.index.AccumuloQueryPlan;
import org.locationtech.geomesa.accumulo.index.BatchScanPlan;
import org.locationtech.geomesa.accumulo.index.EmptyPlan;
import org.locationtech.geomesa.accumulo.index.ScanPlan;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.accumulo.AccumuloJobUtils$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaAccumuloInputFormat;
import org.locationtech.geomesa.spark.CaseInsensitiveMapFix$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.SpatialRDDProvider;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.NotImplementedError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u00015\u0011!$Q2dk6,Hn\\*qCRL\u0017\r\u001c*E\tB\u0013xN^5eKJT!a\u0001\u0003\u0002\u0011\u0005\u001c7-^7vY>T!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019!\u0002\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011\u0001B\u0005\u0003/\u0011\u0011!c\u00159bi&\fGN\u0015#E!J|g/\u001b3feB\u0011\u0011\u0004I\u0007\u00025)\u00111\u0004H\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003;y\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0002?\u0005\u00191m\\7\n\u0005\u0005R\"a\u0003'bufdunZ4j]\u001eDQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtD#A\u0013\u0011\u0005\u0019\u0002Q\"\u0001\u0002\t\u000b!\u0002A\u0011I\u0015\u0002\u0015\r\fg\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0002+[A\u0011qbK\u0005\u0003YA\u0011qAQ8pY\u0016\fg\u000eC\u0003/O\u0001\u0007q&\u0001\u0004qCJ\fWn\u001d\t\u0005aU:d(D\u00012\u0015\t\u00114'\u0001\u0003vi&d'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u00121!T1q!\tA4H\u0004\u0002\u0010s%\u0011!\bE\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;!A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011iM\u0001\u0003S>L!a\u0011!\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b\u0015\u0003A\u0011\t$\u0002\u0007I$G\rF\u0003H\u0015Vcv\f\u0005\u0002\u0016\u0011&\u0011\u0011\n\u0002\u0002\u000b'B\fG/[1m%\u0012#\u0005\"B&E\u0001\u0004a\u0015\u0001B2p]\u001a\u0004\"!T*\u000e\u00039S!aS(\u000b\u0005A\u000b\u0016A\u00025bI>|\u0007O\u0003\u0002S\u0015\u00051\u0011\r]1dQ\u0016L!\u0001\u0016(\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u00151F\t1\u0001X\u0003\t\u00198\r\u0005\u0002Y56\t\u0011L\u0003\u0002\u0006#&\u00111,\u0017\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006]\u0011\u0003\r!\u0018\t\u0005qy;t'\u0003\u00027{!)\u0001\r\u0012a\u0001C\u0006)\u0011/^3ssB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0005I\u0006$\u0018M\u0003\u0002g\u0015\u0005Aq-Z8u_>d7/\u0003\u0002iG\n)\u0011+^3ss\")!\u000e\u0001C\u0001W\u0006!1/\u0019<f)\u0015awn`A\u0001!\tyQ.\u0003\u0002o!\t!QK\\5u\u0011\u0015)\u0015\u000e1\u0001q!\r\t8/^\u0007\u0002e*\u0011Q)W\u0005\u0003iJ\u00141A\u0015#E!\t1X0D\u0001x\u0015\tA\u00180\u0001\u0004tS6\u0004H.\u001a\u0006\u0003un\fqAZ3biV\u0014XM\u0003\u0002}\u0015\u00059q\u000e]3oO&\u001c\u0018B\u0001@x\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\")a&\u001ba\u0001;\"1\u00111A5A\u0002]\n\u0001\u0002^=qK:\u000bW.\u001a")
public class AccumuloSpatialRDDProvider
implements SpatialRDDProvider,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        AccumuloSpatialRDDProvider accumuloSpatialRDDProvider = this;
        synchronized (accumuloSpatialRDDProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public boolean canProcess(java.util.Map<String, Serializable> params) {
        return AccumuloDataStoreFactory$.MODULE$.canProcess(params);
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, scala.collection.immutable.Map<String, String> params, Query query) {
        ObjectRef transform$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        AccumuloDataStore ds = (AccumuloDataStore)DataStoreFinder.getDataStore((java.util.Map)CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap(params));
        try {
            RDD rDD;
            SimpleFeatureType sft = ds.getSchema(query.getTypeName());
            Seq qps = AccumuloJobUtils$.MODULE$.getMultipleQueryPlan(ds, query);
            if (qps.lengthCompare(1) == 0 && ((AccumuloQueryPlan)qps.head()).tables().lengthCompare(1) == 0) {
                rDD = this.org$locationtech$geomesa$spark$accumulo$AccumuloSpatialRDDProvider$$queryPlanToRDD$1(sft, (AccumuloQueryPlan)qps.head(), conf, sc, params, query, ds, transform$lzy, bitmap$0);
            } else {
                Seq expanded = (Seq)qps.flatMap((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<AccumuloQueryPlan> apply(AccumuloQueryPlan x0$1) {
                        AccumuloQueryPlan accumuloQueryPlan;
                        block5: {
                            Seq seq;
                            block3: {
                                block4: {
                                    block2: {
                                        accumuloQueryPlan = x0$1;
                                        if (!(accumuloQueryPlan instanceof BatchScanPlan)) break block2;
                                        BatchScanPlan batchScanPlan = (BatchScanPlan)accumuloQueryPlan;
                                        seq = (Seq)batchScanPlan.tables().map((Function1)new scala.Serializable(this, batchScanPlan){
                                            public static final long serialVersionUID = 0L;
                                            private final BatchScanPlan x2$1;

                                            public final BatchScanPlan apply(String t) {
                                                Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}));
                                                FilterStrategy x$5 = this.x2$1.copy$default$1();
                                                Seq x$6 = this.x2$1.copy$default$3();
                                                Seq x$7 = this.x2$1.copy$default$4();
                                                Seq x$8 = this.x2$1.copy$default$5();
                                                Function1 x$9 = this.x2$1.copy$default$6();
                                                Option x$10 = this.x2$1.copy$default$7();
                                                int x$11 = this.x2$1.copy$default$8();
                                                boolean x$12 = this.x2$1.copy$default$9();
                                                return this.x2$1.copy(x$5, x$4, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
                                            }
                                            {
                                                this.x2$1 = x2$1;
                                            }
                                        }, Seq$.MODULE$.canBuildFrom());
                                        break block3;
                                    }
                                    if (!(accumuloQueryPlan instanceof ScanPlan)) break block4;
                                    ScanPlan scanPlan = (ScanPlan)accumuloQueryPlan;
                                    seq = (Seq)scanPlan.tables().map((Function1)new scala.Serializable(this, scanPlan){
                                        public static final long serialVersionUID = 0L;
                                        private final ScanPlan x3$1;

                                        public final ScanPlan apply(String t) {
                                            Seq x$13 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}));
                                            FilterStrategy x$14 = this.x3$1.copy$default$1();
                                            Range x$15 = this.x3$1.copy$default$3();
                                            Seq x$16 = this.x3$1.copy$default$4();
                                            Seq x$17 = this.x3$1.copy$default$5();
                                            Function1 x$18 = this.x3$1.copy$default$6();
                                            Option x$19 = this.x3$1.copy$default$7();
                                            boolean x$20 = this.x3$1.copy$default$8();
                                            return this.x3$1.copy(x$14, x$13, x$15, x$16, x$17, x$18, x$19, x$20);
                                        }
                                        {
                                            this.x3$1 = x3$1;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                    break block3;
                                }
                                if (!(accumuloQueryPlan instanceof EmptyPlan)) break block5;
                                EmptyPlan emptyPlan = (EmptyPlan)accumuloQueryPlan;
                                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EmptyPlan[]{emptyPlan}));
                            }
                            return seq;
                        }
                        throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected query plan type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{accumuloQueryPlan})));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                rDD = sc.union((Seq)expanded.map((Function1)new scala.Serializable(this, conf, sc, params, query, ds, transform$lzy, sft, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AccumuloSpatialRDDProvider $outer;
                    private final Configuration conf$1;
                    private final SparkContext sc$1;
                    private final scala.collection.immutable.Map params$1;
                    private final Query query$1;
                    private final AccumuloDataStore ds$1;
                    private final ObjectRef transform$lzy$1;
                    private final SimpleFeatureType sft$1;
                    private final VolatileByteRef bitmap$0$1;

                    public final RDD<SimpleFeature> apply(AccumuloQueryPlan x$3) {
                        return this.$outer.org$locationtech$geomesa$spark$accumulo$AccumuloSpatialRDDProvider$$queryPlanToRDD$1(this.sft$1, x$3, new Configuration(this.conf$1), this.sc$1, this.params$1, this.query$1, this.ds$1, this.transform$lzy$1, this.bitmap$0$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.conf$1 = conf$1;
                        this.sc$1 = sc$1;
                        this.params$1 = params$1;
                        this.query$1 = query$1;
                        this.ds$1 = ds$1;
                        this.transform$lzy$1 = transform$lzy$1;
                        this.sft$1 = sft$1;
                        this.bitmap$0$1 = bitmap$0$1;
                    }
                }, Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(SimpleFeature.class));
            }
            RDD sfrdd = rDD;
            return SpatialRDD$.MODULE$.apply(sfrdd, (SimpleFeatureType)this.transform$1(query, transform$lzy, bitmap$0).getOrElse((Function0)new scala.Serializable(this, sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final SimpleFeatureType apply() {
                    return this.sft$1;
                }
                {
                    this.sft$1 = sft$1;
                }
            }));
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void save(RDD<SimpleFeature> rdd2, scala.collection.immutable.Map<String, String> params, String typeName) {
        AccumuloDataStore ds = (AccumuloDataStore)DataStoreFinder.getDataStore((java.util.Map)CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap(params));
        try {
            Predef$.MODULE$.require(ds.getSchema(typeName) != null, (Function0)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Feature type must exist before calling save.  Call createSchema on the DataStore first.";
                }
            });
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.dispose();
            throw throwable;
        }
        ds.dispose();
        rdd2.foreachPartition((Function1)new scala.Serializable(this, params, typeName){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map params$2;
            private final String typeName$1;

            /*
             * WARNING - void declaration
             */
            public final void apply(Iterator<SimpleFeature> iter) {
                AccumuloDataStore ds = (AccumuloDataStore)DataStoreFinder.getDataStore((java.util.Map)CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap((Map)this.params$2));
                SimpleFeatureWriter featureWriter = ds.getFeatureWriterAppend(this.typeName$1, Transaction.AUTO_COMMIT);
                try {
                    iter.foreach((Function1)new scala.Serializable(this, featureWriter){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureWriter featureWriter$1;

                        public final void apply(SimpleFeature rawFeature) {
                            FeatureUtils$.MODULE$.copyToWriter((FeatureWriter)this.featureWriter$1, rawFeature, true);
                            this.featureWriter$1.write();
                        }
                        {
                            this.featureWriter$1 = featureWriter$1;
                        }
                    });
                }
                catch (Throwable throwable) {
                    void var2_2;
                    void var3_3;
                    IOUtils.closeQuietly((Closeable)var3_3);
                    var2_2.dispose();
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)featureWriter);
                ds.dispose();
            }
            {
                this.params$2 = params$2;
                this.typeName$1 = typeName$1;
            }
        });
    }

    private final Option transform$lzycompute$1(Query query$1, ObjectRef transform$lzy$1, VolatileByteRef bitmap$0$1) {
        AccumuloSpatialRDDProvider accumuloSpatialRDDProvider = this;
        synchronized (accumuloSpatialRDDProvider) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                transform$lzy$1.elem = QueryHints$.MODULE$.RichHints(query$1.getHints()).getTransformSchema();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Option)transform$lzy$1.elem;
        }
    }

    private final Option transform$1(Query query$1, ObjectRef transform$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.transform$lzycompute$1(query$1, transform$lzy$1, bitmap$0$1) : (Option)transform$lzy$1.elem;
    }

    public final RDD org$locationtech$geomesa$spark$accumulo$AccumuloSpatialRDDProvider$$queryPlanToRDD$1(SimpleFeatureType sft, AccumuloQueryPlan qp, Configuration conf, SparkContext sc$1, scala.collection.immutable.Map params$1, Query query$1, AccumuloDataStore ds$1, ObjectRef transform$lzy$1, VolatileByteRef bitmap$0$1) {
        RDD rDD;
        if (ds$1 == null || sft == null || qp instanceof EmptyPlan) {
            rDD = sc$1.emptyRDD(ClassTag$.MODULE$.apply(SimpleFeature.class));
        } else {
            InputConfigurator.setInputTableName(AccumuloInputFormat.class, (Configuration)conf, (String)((String)qp.tables().head()));
            InputConfigurator.setRanges(AccumuloInputFormat.class, (Configuration)conf, (Collection)JavaConversions$.MODULE$.seqAsJavaList(qp.ranges()));
            qp.iterators().foreach((Function1)new scala.Serializable(this, conf){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$2;

                public final void apply(IteratorSetting x$1) {
                    InputConfigurator.addIterator(AccumuloInputFormat.class, (Configuration)this.conf$2, (IteratorSetting)x$1);
                }
                {
                    this.conf$2 = conf$2;
                }
            });
            if (qp.columnFamilies().nonEmpty()) {
                Seq cf = (Seq)qp.columnFamilies().map((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Pair<Text, Text> apply(Text cf) {
                        return new Pair((Object)cf, null);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                InputConfigurator.fetchColumns(AccumuloInputFormat.class, (Configuration)conf, (Collection)JavaConversions$.MODULE$.seqAsJavaList(cf));
            }
            InputConfigurator.setBatchScan(AccumuloInputFormat.class, (Configuration)conf, (boolean)true);
            InputConfigurator.setBatchScan(GeoMesaAccumuloInputFormat.class, (Configuration)conf, (boolean)true);
            GeoMesaConfigurator$.MODULE$.setSerialization(conf);
            GeoMesaConfigurator$.MODULE$.setTable(conf, (String)qp.tables().head());
            GeoMesaConfigurator$.MODULE$.setDataStoreInParams(conf, params$1);
            GeoMesaConfigurator$.MODULE$.setFeatureType(conf, sft.getTypeName());
            qp.filter().secondary().collect((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1;
                    A1 A12 = A1 = x1;
                    IncludeFilter includeFilter = Filter.INCLUDE;
                    Object object = !(A12 != null ? !A12.equals(includeFilter) : includeFilter != null) ? function1.apply(x1) : A1;
                    return (B1)object;
                }

                public final boolean isDefinedAt(Filter x1) {
                    Filter filter;
                    Filter filter2 = filter = x1;
                    IncludeFilter includeFilter = Filter.INCLUDE;
                    boolean bl = filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null;
                    return bl;
                }
            }).foreach((Function1)new scala.Serializable(this, conf){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$2;

                public final void apply(Filter f) {
                    GeoMesaConfigurator$.MODULE$.setFilter(this.conf$2, ECQL.toCQL((Filter)f));
                }
                {
                    this.conf$2 = conf$2;
                }
            });
            this.transform$1(query$1, transform$lzy$1, bitmap$0$1).foreach((Function1)new scala.Serializable(this, conf){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$2;

                public final void apply(SimpleFeatureType x$2) {
                    GeoMesaConfigurator$.MODULE$.setTransformSchema(this.conf$2, x$2);
                }
                {
                    this.conf$2 = conf$2;
                }
            });
            Option auths = AccumuloDataStoreParams$.MODULE$.AuthsParam().lookupOpt(CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap((Map)params$1));
            auths.foreach((Function1)new scala.Serializable(this, conf){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$2;

                public final void apply(String a) {
                    Authorizations authorizations = new Authorizations(a.split(","));
                    InputConfigurator.setScanAuthorizations(AccumuloInputFormat.class, (Configuration)this.conf$2, (Authorizations)authorizations);
                }
                {
                    this.conf$2 = conf$2;
                }
            });
            JobConf jconf = new JobConf(conf);
            SparkHadoopUtil$.MODULE$.get().addCredentials(jconf);
            String username = (String)AccumuloDataStoreParams$.MODULE$.UserParam().lookup(CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap((Map)params$1));
            String password = (String)AccumuloDataStoreParams$.MODULE$.PasswordParam().lookup(CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap((Map)params$1));
            String keytabPath = (String)AccumuloDataStoreParams$.MODULE$.KeytabPathParam().lookup(CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap((Map)params$1));
            KerberosToken authToken = password == null ? new KerberosToken(username, new File(keytabPath.toString()), true) : new PasswordToken(password.toString().getBytes());
            String instance = (String)AccumuloDataStoreParams$.MODULE$.InstanceIdParam().lookup(CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap((Map)params$1));
            String zookeepers = (String)AccumuloDataStoreParams$.MODULE$.ZookeepersParam().lookup(CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap((Map)params$1));
            if (Predef$.MODULE$.Boolean2boolean((Boolean)AccumuloDataStoreParams$.MODULE$.MockParam().lookup(CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap((Map)params$1)))) {
                AbstractInputFormat.setMockInstance((JobConf)jconf, (String)instance);
            } else {
                AbstractInputFormat.setZooKeeperInstance((JobConf)jconf, (ClientConfiguration)new ClientConfiguration(new org.apache.commons.configuration.Configuration[0]).withInstance(instance).withZkHosts(zookeepers).withSasl(authToken instanceof KerberosToken));
            }
            String user = (String)AccumuloDataStoreParams$.MODULE$.UserParam().lookup(CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap((Map)params$1));
            AbstractInputFormat.setConnectorInfo((JobConf)jconf, (String)user, (AuthenticationToken)authToken);
            JavaConversions$.MODULE$.collectionAsScalaIterable(jconf.getCredentials().getAllTokens()).foreach((Function1)new scala.Serializable(this, jconf){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AccumuloSpatialRDDProvider $outer;
                private final JobConf jconf$1;

                public final void apply(Token<? extends TokenIdentifier> tok) {
                    String string = tok.getKind().toString();
                    String string2 = "ACCUMULO_AUTH_TOKEN";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        BoxedUnit boxedUnit;
                        if (this.$outer.logger().underlying().isInfoEnabled()) {
                            this.$outer.logger().underlying().info("Adding ACCUMULO_AUTH_TOKEN to configuration");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.jconf$1.set("org.locationtech.geomesa.token", tok.encodeToUrlString());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.jconf$1 = jconf$1;
                }
            });
            rDD = new NewHadoopRDD(sc$1, GeoMesaAccumuloInputFormat.class, Text.class, SimpleFeature.class, (Configuration)jconf).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SimpleFeature apply(Tuple2<Text, SimpleFeature> U) {
                    return (SimpleFeature)U._2();
                }
            }, ClassTag$.MODULE$.apply(SimpleFeature.class));
        }
        return rDD;
    }

    public AccumuloSpatialRDDProvider() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

