/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.accumulo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.token.Token;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.rdd.NewHadoopRDD;
import org.apache.spark.rdd.RDD;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStoreFactory$;
import org.locationtech.geomesa.accumulo.data.AccumuloQueryPlan;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.jobs.accumulo.AccumuloJobUtils$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaAccumuloInputFormat;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaAccumuloInputFormat$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.SpatialRDDProvider;
import org.locationtech.geomesa.spark.accumulo.AccumuloSpatialRDDProvider$;
import org.locationtech.geomesa.spark.accumulo.AccumuloSpatialRDDProvider$$anonfun$save$2$;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.WithStore$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u0011!$Q2dk6,Hn\\*qCRL\u0017\r\u001c*E\tB\u0013xN^5eKJT!a\u0001\u0003\u0002\u0011\u0005\u001c7-^7vY>T!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019!\u0002\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011\u0001B\u0005\u0003/\u0011\u0011!c\u00159bi&\fGN\u0015#E!J|g/\u001b3feB\u0011\u0011\u0004I\u0007\u00025)\u00111\u0004H\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003;y\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0002?\u0005\u00191m\\7\n\u0005\u0005R\"a\u0003'bufdunZ4j]\u001eDQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtD#A\u0013\u0011\u0005\u0019\u0002Q\"\u0001\u0002\t\u000b!\u0002A\u0011I\u0015\u0002\u0015\r\fg\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0002+[A\u0011qbK\u0005\u0003YA\u0011qAQ8pY\u0016\fg\u000eC\u0003/O\u0001\u0007q&\u0001\u0004qCJ\fWn\u001d\u0019\u0003a\u0005\u0003B!\r\u001c9\u007f5\t!G\u0003\u00024i\u0005!Q\u000f^5m\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u001a\u0003\u00075\u000b\u0007\u000f\u0005\u0002:y9\u0011qBO\u0005\u0003wA\ta\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111\b\u0005\t\u0003\u0001\u0006c\u0001\u0001B\u0005C[\u0005\u0005\t\u0011!B\u0001\u0007\n\u0019q\fJ\u0019\u0012\u0005\u0011;\u0005CA\bF\u0013\t1\u0005CA\u0004O_RD\u0017N\\4\u0011\u0005![U\"A%\u000b\u0005)#\u0014AA5p\u0013\ta\u0015J\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003O\u0001\u0011\u0005s*A\u0002sI\u0012$R\u0001U*_K\"\u0004\"!F)\n\u0005I#!AC*qCRL\u0017\r\u001c*E\t\")A+\u0014a\u0001+\u0006!1m\u001c8g!\t1F,D\u0001X\u0015\t!\u0006L\u0003\u0002Z5\u00061\u0001.\u00193p_BT!a\u0017\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tivKA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006?6\u0003\r\u0001Y\u0001\u0003g\u000e\u0004\"!Y2\u000e\u0003\tT!!\u0002.\n\u0005\u0011\u0014'\u0001D*qCJ\\7i\u001c8uKb$\b\"\u0002\u0018N\u0001\u00041\u0007\u0003B\u001dhqaJ!a\u000e \t\u000b%l\u0005\u0019\u00016\u0002\u000bE,XM]=\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017\u0001\u00023bi\u0006T!a\u001c\u0006\u0002\u0011\u001d,w\u000e^8pYNL!!\u001d7\u0003\u000bE+XM]=\t\u000bM\u0004A\u0011\u0001;\u0002\tM\fg/\u001a\u000b\u0007kb\f\t\"a\u0005\u0011\u0005=1\u0018BA<\u0011\u0005\u0011)f.\u001b;\t\u000b9\u0013\b\u0019A=\u0011\u0007idh0D\u0001|\u0015\tq%-\u0003\u0002~w\n\u0019!\u000b\u0012#\u0011\u0007}\fi!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0019\u0019\u0018.\u001c9mK*!\u0011qAA\u0005\u0003\u001d1W-\u0019;ve\u0016T1!a\u0003\u000b\u0003\u001dy\u0007/\u001a8hSNLA!a\u0004\u0002\u0002\ti1+[7qY\u00164U-\u0019;ve\u0016DQA\f:A\u0002\u0019Da!!\u0006s\u0001\u0004A\u0014\u0001\u0003;za\u0016t\u0015-\\3")
public class AccumuloSpatialRDDProvider
implements SpatialRDDProvider,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        AccumuloSpatialRDDProvider accumuloSpatialRDDProvider = this;
        synchronized (accumuloSpatialRDDProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Option<SimpleFeatureType> sft(scala.collection.immutable.Map<String, String> params, String typeName) {
        return SpatialRDDProvider.class.sft((SpatialRDDProvider)this, params, (String)typeName);
    }

    public boolean canProcess(Map<String, ? extends Serializable> params) {
        return AccumuloDataStoreFactory$.MODULE$.canProcess(params);
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, scala.collection.immutable.Map<String, String> params, Query query) {
        ObjectRef transform$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Map paramsAsJava = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(params).asJava();
        AccumuloDataStore ds = (AccumuloDataStore)DataStoreFinder.getDataStore((Map)paramsAsJava);
        try {
            RDD rDD;
            SimpleFeatureType sft = ds.getSchema(query.getTypeName());
            Seq qps = AccumuloJobUtils$.MODULE$.getMultipleQueryPlan(ds, query);
            if (qps.lengthCompare(1) == 0 && ((AccumuloQueryPlan)qps.head()).tables().lengthCompare(1) == 0) {
                rDD = this.org$locationtech$geomesa$spark$accumulo$AccumuloSpatialRDDProvider$$queryPlanToRDD$1(sft, (AccumuloQueryPlan)qps.head(), conf, sc, paramsAsJava, ds);
            } else {
                Seq expanded = (Seq)qps.flatMap((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<AccumuloQueryPlan> apply(AccumuloQueryPlan x0$1) {
                        AccumuloQueryPlan accumuloQueryPlan;
                        block4: {
                            Seq seq;
                            block3: {
                                block2: {
                                    accumuloQueryPlan = x0$1;
                                    if (!(accumuloQueryPlan instanceof AccumuloQueryPlan.BatchScanPlan)) break block2;
                                    AccumuloQueryPlan.BatchScanPlan batchScanPlan = (AccumuloQueryPlan.BatchScanPlan)accumuloQueryPlan;
                                    seq = (Seq)batchScanPlan.tables().map((Function1)new scala.Serializable(this, batchScanPlan){
                                        public static final long serialVersionUID = 0L;
                                        private final AccumuloQueryPlan.BatchScanPlan x2$1;

                                        public final AccumuloQueryPlan.BatchScanPlan apply(String t) {
                                            Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}));
                                            package.FilterStrategy x$5 = this.x2$1.copy$default$1();
                                            Seq x$6 = this.x2$1.copy$default$3();
                                            Seq x$7 = this.x2$1.copy$default$4();
                                            Option x$8 = this.x2$1.copy$default$5();
                                            QueryPlan.ResultsToFeatures x$9 = this.x2$1.copy$default$6();
                                            Option x$10 = this.x2$1.copy$default$7();
                                            Option x$11 = this.x2$1.copy$default$8();
                                            Option x$12 = this.x2$1.copy$default$9();
                                            Option x$13 = this.x2$1.copy$default$10();
                                            int x$14 = this.x2$1.copy$default$11();
                                            return this.x2$1.copy(x$5, x$4, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14);
                                        }
                                        {
                                            this.x2$1 = x2$1;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                    break block3;
                                }
                                if (!(accumuloQueryPlan instanceof AccumuloQueryPlan.EmptyPlan)) break block4;
                                AccumuloQueryPlan.EmptyPlan emptyPlan = (AccumuloQueryPlan.EmptyPlan)accumuloQueryPlan;
                                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccumuloQueryPlan.EmptyPlan[]{emptyPlan}));
                            }
                            return seq;
                        }
                        throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected query plan type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{accumuloQueryPlan})));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                rDD = sc.union((Seq)expanded.map((Function1)new scala.Serializable(this, conf, sc, paramsAsJava, ds, sft){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AccumuloSpatialRDDProvider $outer;
                    private final Configuration conf$1;
                    private final SparkContext sc$1;
                    private final Map paramsAsJava$1;
                    private final AccumuloDataStore ds$1;
                    private final SimpleFeatureType sft$1;

                    public final RDD<SimpleFeature> apply(AccumuloQueryPlan x$2) {
                        return this.$outer.org$locationtech$geomesa$spark$accumulo$AccumuloSpatialRDDProvider$$queryPlanToRDD$1(this.sft$1, x$2, this.conf$1, this.sc$1, this.paramsAsJava$1, this.ds$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.conf$1 = conf$1;
                        this.sc$1 = sc$1;
                        this.paramsAsJava$1 = paramsAsJava$1;
                        this.ds$1 = ds$1;
                        this.sft$1 = sft$1;
                    }
                }, Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(SimpleFeature.class));
            }
            RDD sfrdd = rDD;
            return SpatialRDD$.MODULE$.apply(sfrdd, (SimpleFeatureType)this.transform$1(query, transform$lzy, bitmap$0).getOrElse((Function0)new scala.Serializable(this, sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final SimpleFeatureType apply() {
                    return this.sft$1;
                }
                {
                    this.sft$1 = sft$1;
                }
            }));
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
    }

    public void save(RDD<SimpleFeature> rdd2, scala.collection.immutable.Map<String, String> params, String typeName) {
        WithStore$.MODULE$.apply(params).apply((Function1)new scala.Serializable(this, typeName){
            public static final long serialVersionUID = 0L;
            private final String typeName$1;

            public final void apply(AccumuloDataStore ds) {
                Predef$.MODULE$.require(ds.getSchema(this.typeName$1) != null, (Function0)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Feature type must exist before calling save. Call createSchema on the DataStore first.";
                    }
                });
            }
            {
                this.typeName$1 = typeName$1;
            }
        });
        rdd2.foreachPartition((Function1)new scala.Serializable(this, params, typeName){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map params$1;
            public final String typeName$1;

            public final void apply(Iterator<SimpleFeature> iter) {
                WithStore$.MODULE$.apply(this.params$1).apply((Function1)new scala.Serializable(this, iter){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$save$2 $outer;
                    public final Iterator iter$1;

                    public final void apply(AccumuloDataStore ds) {
                        package.WithClose$.MODULE$.apply((Object)ds.getFeatureWriterAppend(this.$outer.typeName$1, Transaction.AUTO_COMMIT), (Function1)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$save$2$$anonfun$apply$3 $outer;

                            public final void apply(SimpleFeatureWriter writer) {
                                this.$outer.iter$1.foreach((Function1)new scala.Serializable(this, writer){
                                    public static final long serialVersionUID = 0L;
                                    private final SimpleFeatureWriter writer$1;

                                    public final SimpleFeature apply(SimpleFeature x$3) {
                                        return FeatureUtils$.MODULE$.write((FeatureWriter)this.writer$1, x$3, true);
                                    }
                                    {
                                        this.writer$1 = writer$1;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, IsCloseable$.MODULE$.closeableIsCloseable());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.iter$1 = iter$1;
                    }
                });
            }
            {
                this.params$1 = params$1;
                this.typeName$1 = typeName$1;
            }
        });
    }

    private final Option transform$lzycompute$1(Query query$1, ObjectRef transform$lzy$1, VolatileByteRef bitmap$0$1) {
        AccumuloSpatialRDDProvider accumuloSpatialRDDProvider = this;
        synchronized (accumuloSpatialRDDProvider) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                transform$lzy$1.elem = QueryHints$.MODULE$.RichHints(query$1.getHints()).getTransformSchema();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Option)transform$lzy$1.elem;
        }
    }

    private final Option transform$1(Query query$1, ObjectRef transform$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.transform$lzycompute$1(query$1, transform$lzy$1, bitmap$0$1) : (Option)transform$lzy$1.elem;
    }

    public final RDD org$locationtech$geomesa$spark$accumulo$AccumuloSpatialRDDProvider$$queryPlanToRDD$1(SimpleFeatureType sft, AccumuloQueryPlan qp, Configuration conf$1, SparkContext sc$1, Map paramsAsJava$1, AccumuloDataStore ds$1) {
        RDD rDD;
        if (ds$1 == null || sft == null || qp instanceof AccumuloQueryPlan.EmptyPlan) {
            rDD = sc$1.emptyRDD(ClassTag$.MODULE$.apply(SimpleFeature.class));
        } else {
            Job job = new Job(conf$1);
            GeoMesaAccumuloInputFormat$.MODULE$.configure(job, paramsAsJava$1, qp);
            JobConf jconf = (JobConf)job.getConfiguration();
            SparkHadoopUtil$.MODULE$.get().addCredentials(jconf);
            java.util.Iterator tokens = jconf.getCredentials().getAllTokens().iterator();
            boolean hasNext = tokens.hasNext();
            while (hasNext) {
                Token token = (Token)tokens.next();
                String string = token.getKind().toString();
                String string2 = "ACCUMULO_AUTH_TOKEN";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Adding ACCUMULO_AUTH_TOKEN to configuration");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    jconf.set("org.locationtech.geomesa.token", token.encodeToUrlString());
                    hasNext = false;
                    continue;
                }
                hasNext = tokens.hasNext();
            }
            rDD = new NewHadoopRDD(sc$1, GeoMesaAccumuloInputFormat.class, Text.class, SimpleFeature.class, (Configuration)jconf).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SimpleFeature apply(Tuple2<Text, SimpleFeature> x$1) {
                    return (SimpleFeature)x$1._2();
                }
            }, ClassTag$.MODULE$.apply(SimpleFeature.class));
        }
        return rDD;
    }

    public AccumuloSpatialRDDProvider() {
        SpatialRDDProvider.class.$init$((SpatialRDDProvider)this);
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

