/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.util.Locale;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloRasterTableParam;
import org.locationtech.geomesa.accumulo.tools.AccumuloRasterTableParam$class;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams$class;
import org.locationtech.geomesa.accumulo.tools.OptionalZookeepersParam$class;
import org.locationtech.geomesa.accumulo.tools.ingest.IngestRasterCommand$;
import org.locationtech.geomesa.accumulo.tools.ingest.PathValidator;
import org.locationtech.geomesa.accumulo.tools.raster.LocalRasterIngest;
import org.locationtech.geomesa.raster.util.RasterUtils;
import org.locationtech.geomesa.tools.Command;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.RequiredCredentialsParams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0001\u0003\u0001=\u00111#\u00138hKN$(+Y:uKJ\u001cu.\\7b]\u0012T!a\u0001\u0003\u0002\r%tw-Z:u\u0015\t)a!A\u0003u_>d7O\u0003\u0002\b\u0011\u0005A\u0011mY2v[VdwN\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"aF\r\u000e\u0003aQ!!\u0002\u0005\n\u0005iA\"aB\"p[6\fg\u000e\u001a\u0005\u00069\u0001!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"a\b\u0001\u000e\u0003\tAq!\t\u0001C\u0002\u0013\u0005#%\u0001\u0003oC6,W#A\u0012\u0011\u0005\u0011:cBA\t&\u0013\t1##\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q%\u0012aa\u0015;sS:<'B\u0001\u0014\u0013\u0011\u0019Y\u0003\u0001)A\u0005G\u0005)a.Y7fA!9Q\u0006\u0001b\u0001\n\u0003r\u0013A\u00029be\u0006l7/F\u00010!\t\u0001\u0014J\u0004\u0002 c\u001d)!G\u0001E\u0001g\u0005\u0019\u0012J\\4fgR\u0014\u0016m\u001d;fe\u000e{W.\\1oIB\u0011q\u0004\u000e\u0004\u0006\u0003\tA\t!N\n\u0003iAAQ\u0001\b\u001b\u0005\u0002]\"\u0012a\r\u0005\u0006sQ\"\tAO\u0001\nO\u0016$hi\u001c:nCR$\"aI\u001e\t\u000bqB\u0004\u0019A\u001f\u0002\u0013\u0019LG.Z(s\t&\u0014\bC\u0001 D\u001b\u0005y$B\u0001!B\u0003\tIwNC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$\u0001\u0002$jY\u0016DQA\u0012\u001b\u0005\u0002\u001d\u000b\u0001cZ3u\r&dW-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0005\rB\u0005\"B\u0011F\u0001\u0004\u0019c\u0001\u0002&5\u0001-\u0013a#\u00138hKN$(+Y:uKJ\u0004\u0016M]1nKR,'o]\n\u0005\u0013Ba\u0005\u000b\u0005\u0002N\u001d6\tA!\u0003\u0002P\t\tA\u0012iY2v[VdwnQ8o]\u0016\u001cG/[8o!\u0006\u0014\u0018-\\:\u0011\u00055\u000b\u0016B\u0001*\u0005\u0005a\t5mY;nk2|'+Y:uKJ$\u0016M\u00197f!\u0006\u0014\u0018-\u001c\u0005\u00069%#\t\u0001\u0016\u000b\u0002+B\u0011a+S\u0007\u0002i!9\u0001,\u0013a\u0001\n\u0003\u0011\u0013aC<sSR,W*Z7pefDqAW%A\u0002\u0013\u00051,A\bxe&$X-T3n_JLx\fJ3r)\tav\f\u0005\u0002\u0012;&\u0011aL\u0005\u0002\u0005+:LG\u000fC\u0004a3\u0006\u0005\t\u0019A\u0012\u0002\u0007a$\u0013\u0007\u0003\u0004c\u0013\u0002\u0006KaI\u0001\roJLG/Z'f[>\u0014\u0018\u0010\t\u0015\u0007C\u0012twN]:\u0011\u0005\u0015dW\"\u00014\u000b\u0005\u001dD\u0017A\u00036d_6l\u0017M\u001c3fe*\u0011\u0011N[\u0001\u0006E\u0016,8\u000f\u001e\u0006\u0002W\u0006\u00191m\\7\n\u000554'!\u0003)be\u0006lW\r^3s\u0003\u0015q\u0017-\\3tY\u0005\u0001\u0018%A9\u0002\u001d5jsO]5uK6jW-\\8ss\u0006YA-Z:de&\u0004H/[8oC\u0005!\u0018!K'f[>\u0014\u0018\u0010I1mY>\u001c\u0017\r^5p]\u00022wN\u001d\u0011j]\u001e,7\u000f^5p]\u0002z\u0007/\u001a:bi&|g\u000eC\u0004w\u0013\u0002\u0007I\u0011A<\u0002\u0019]\u0014\u0018\u000e^3UQJ,\u0017\rZ:\u0016\u0003a\u0004\"!\u001f?\u000e\u0003iT!a_!\u0002\t1\fgnZ\u0005\u0003{j\u0014q!\u00138uK\u001e,'\u000f\u0003\u0005\u0000\u0013\u0002\u0007I\u0011AA\u0001\u0003A9(/\u001b;f)\"\u0014X-\u00193t?\u0012*\u0017\u000fF\u0002]\u0003\u0007Aq\u0001\u0019@\u0002\u0002\u0003\u0007\u0001\u0010C\u0004\u0002\b%\u0003\u000b\u0015\u0002=\u0002\u001b]\u0014\u0018\u000e^3UQJ,\u0017\rZ:!Q%\t)\u0001\u001a8\u0002\fI\f\t\u0002\f\u0002\u0002\u000e\u0005\u0012\u0011qB\u0001\u0010[5:(/\u001b;f[QD'/Z1eg\u0006\u0012\u00111C\u0001 )\"\u0014X-\u00193tA\u0019|'\u000fI<sSRLgn\u001a\u0011sCN$XM\u001d\u0011eCR\f\u0007\u0002CA\f\u0013\u0002\u0007I\u0011A<\u0002\u0019E,XM]=UQJ,\u0017\rZ:\t\u0013\u0005m\u0011\n1A\u0005\u0002\u0005u\u0011\u0001E9vKJLH\u000b\u001b:fC\u0012\u001cx\fJ3r)\ra\u0016q\u0004\u0005\tA\u0006e\u0011\u0011!a\u0001q\"9\u00111E%!B\u0013A\u0018!D9vKJLH\u000b\u001b:fC\u0012\u001c\b\u0005K\u0005\u0002\"\u0011t\u0017q\u0005:\u0002.1\u0012\u0011\u0011F\u0011\u0003\u0003W\tq\"L\u0017rk\u0016\u0014\u00180\f;ie\u0016\fGm]\u0011\u0003\u0003_\tq\u0004\u00165sK\u0006$7\u000f\t4pe\u0002\nX/\u001a:j]\u001e\u0004#/Y:uKJ\u0004C-\u0019;b\u0011!\t\u0019$\u0013a\u0001\n\u0003\u0011\u0013A\u00024pe6\fG\u000fC\u0005\u00028%\u0003\r\u0011\"\u0001\u0002:\u0005Qam\u001c:nCR|F%Z9\u0015\u0007q\u000bY\u0004\u0003\u0005a\u0003k\t\t\u00111\u0001$\u0011\u001d\ty$\u0013Q!\n\r\nqAZ8s[\u0006$\b\u0005K\u0005\u0002>\u0011t\u00171\t:\u0002N1\"\u0011QIA%C\t\t9%\u0001\u0002.\r\u0006\u0012\u00111J\u0001\t[52wN]7bi\u0006\u0012\u0011qJ\u0001W\r>\u0014X.\u0019;!_\u001a\u0004\u0013N\\2p[&tw\r\t:bgR,'\u000f\t3bi\u0006\u0004\u0003fZ3pi&4g\r\t?!\tR+E)\u000b\u0011u_\u0002zg/\u001a:sS\u0012,\u0007EZ5mK\u0002*\u0007\u0010^3og&|g\u000e\t:fG><g.\u001b;j_:D\u0001\"a\u0015J\u0001\u0004%\tAI\u0001\u0005M&dW\rC\u0005\u0002X%\u0003\r\u0011\"\u0001\u0002Z\u0005Aa-\u001b7f?\u0012*\u0017\u000fF\u0002]\u00037B\u0001\u0002YA+\u0003\u0003\u0005\ra\t\u0005\b\u0003?J\u0005\u0015)\u0003$\u0003\u00151\u0017\u000e\\3!QE\ti\u0006\u001a8\u0002dI\fi'!\u001d\u0002t\u0005m\u0014Q\u0010\u0017\u0005\u0003K\nI'\t\u0002\u0002h\u0005\u0011QFZ\u0011\u0003\u0003W\na!L\u0017gS2,\u0017EAA8\u0003y\u001a\u0016N\\4mK\u0002\u0012\u0018m\u001d;fe\u00022\u0017\u000e\\3!_J\u0004C-\u001b:fGR|'/\u001f\u0011pM\u0002\u0012\u0018m\u001d;fe\u00022\u0017\u000e\\3tAQ|\u0007EY3!S:<Wm\u001d;fI\u0006aa/\u00197jI\u0006$XmV5uQ\u000e\u0012\u0011Q\u000f\t\u0004?\u0005]\u0014bAA=\u0005\ti\u0001+\u0019;i-\u0006d\u0017\u000eZ1u_J\f\u0001B]3rk&\u0014X\rZ\r\u0002\u0003!A\u0011\u0011Q%A\u0002\u0013\u0005!%A\u0005uS6,7\u000b^1na\"I\u0011QQ%A\u0002\u0013\u0005\u0011qQ\u0001\u000ei&lWm\u0015;b[B|F%Z9\u0015\u0007q\u000bI\t\u0003\u0005a\u0003\u0007\u000b\t\u00111\u0001$\u0011\u001d\ti)\u0013Q!\n\r\n!\u0002^5nKN#\u0018-\u001c9!Q%\tY\t\u001a8\u0002\u0012J\fY\n\f\u0003\u0002\u0014\u0006]\u0015EAAK\u0003\tiC+\t\u0002\u0002\u001a\u0006YQ&\f;j[\u0016\u001cH/Y7qC\t\ti*\u0001\u0015J]\u001e,7\u000f^5p]\u0002\"\u0018.\\3!Q\u0011,g-Y;mi\u0002\"x\u000eI2veJ,g\u000e\u001e\u0011uS6,\u0017\u0006\u0003\u0005\u0002\"&\u0003\r\u0011\"\u0001x\u0003!\u0001\u0018M\u001d'fm\u0016d\u0007\"CAS\u0013\u0002\u0007I\u0011AAT\u00031\u0001\u0018M\u001d'fm\u0016dw\fJ3r)\ra\u0016\u0011\u0016\u0005\tA\u0006\r\u0016\u0011!a\u0001q\"9\u0011QV%!B\u0013A\u0018!\u00039be2+g/\u001a7!Q%\tY\u000b\u001a8\u00022J\fY\f\f\u0003\u00024\u0006]\u0016EAA[\u0003\ti\u0003+\t\u0002\u0002:\u0006\u0001R&\f9be\u0006dG.\u001a7.Y\u00164X\r\\\u0011\u0003\u0003{\u000b!+T1yS6,X\u000e\t8v[\n,'\u000fI8gA1|7-\u00197!i\"\u0014X-\u00193tA\u0019|'\u000fI5oO\u0016\u001cH/\u001b8hA5,H\u000e^5qY\u0016\u0004#/Y:uKJ\u0004c-\u001b7fg\u0002BC-\u001a4bk2$\b\u0005^8!c%Bs!SAa\u0003\u000f\fI\rE\u0002f\u0003\u0007L1!!2g\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0013G>lW.\u00198e\t\u0016\u001c8M]5qi&|g.\t\u0002\u0002L\u0006\u0001\u0013J\\4fgR\u0004#/Y:uKJ\u0004c-\u001b7fg\u0002Jg\u000e^8!\u000f\u0016|W*Z:b\u0011\u001d\ty\r\u0001Q\u0001\n=\nq\u0001]1sC6\u001c\b\u0005C\u0004\u0002T\u0002!\t%!6\u0002\u000f\u0015DXmY;uKR\tA\fC\u0004\u0002Z\u0002!\t!a7\u0002+\u001d,GOU1ti\u0016\u0014\u0018J\\4fgR\u0004\u0016M]1ngV\u0011\u0011Q\u001c\t\u0007I\u0005}7%a9\n\u0007\u0005\u0005\u0018FA\u0002NCB\u0004B!EAsG%\u0019\u0011q\u001d\n\u0003\r=\u0003H/[8o\u0001")
public class IngestRasterCommand
implements Command {
    private final String name;
    private final IngestRasterParameters params = new IngestRasterParameters();

    public static String getFileExtension(String string) {
        return IngestRasterCommand$.MODULE$.getFileExtension(string);
    }

    public static String getFormat(File file) {
        return IngestRasterCommand$.MODULE$.getFormat(file);
    }

    public String name() {
        return this.name;
    }

    public IngestRasterParameters params() {
        return this.params;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void execute() {
        String ext = ((String)Option$.MODULE$.apply((Object)this.params().format()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IngestRasterCommand $outer;

            public final String apply() {
                return IngestRasterCommand$.MODULE$.getFileExtension(this.$outer.params().file());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).toLowerCase(Locale.US);
        if (!((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tif", "tiff", "geotiff", "dt0", "dt1", "dt2"}))).contains((Object)ext)) {
            Command$.MODULE$.user().error(new StringBuilder().append((Object)"Error: File format not supported for file ").append((Object)this.params().file()).append((Object)". Supported formats ").append((Object)"are geotiff and DTED").toString());
            return;
        }
        LocalRasterIngest localIngester = new LocalRasterIngest((Map<String, Option<String>>)this.getRasterIngestParams().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.FILE_PATH()), (Object)new Some((Object)this.params().file()))));
        Try<BoxedUnit> try_ = localIngester.runIngestTask();
        if (try_ instanceof Success) {
            Command$.MODULE$.user().info("Local ingestion is done.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (!(try_ instanceof Failure)) throw new MatchError(try_);
        Failure failure = (Failure)try_;
        Throwable e = failure.exception();
        throw new RuntimeException(e);
    }

    public Map<String, Option<String>> getRasterIngestParams() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.ZOOKEEPERS()), (Object)Option$.MODULE$.apply((Object)this.params().zookeepers())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.ACCUMULO_INSTANCE()), (Object)Option$.MODULE$.apply((Object)this.params().instance())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.ACCUMULO_USER()), (Object)Option$.MODULE$.apply((Object)this.params().user())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.ACCUMULO_PASSWORD()), (Object)Option$.MODULE$.apply((Object)this.params().password())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.AUTHORIZATIONS()), (Object)Option$.MODULE$.apply((Object)this.params().auths())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.VISIBILITIES()), (Object)Option$.MODULE$.apply((Object)this.params().visibilities())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.ACCUMULO_MOCK()), (Object)new Some((Object)((Object)BoxesRunTime.boxToBoolean((boolean)this.params().mock())).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.TABLE()), (Object)Option$.MODULE$.apply((Object)this.params().table())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.FORMAT()), (Object)Option$.MODULE$.apply((Object)this.params().format()).orElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IngestRasterCommand $outer;

            public final Some<String> apply() {
                return new Some((Object)IngestRasterCommand$.MODULE$.getFormat(new File(this.$outer.params().file())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.TIME()), (Object)Option$.MODULE$.apply((Object)this.params().timeStamp())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.WRITE_MEMORY()), (Object)Option$.MODULE$.apply((Object)this.params().writeMemory())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.WRITE_THREADS()), (Object)Option$.MODULE$.apply((Object)this.params().writeThreads()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Integer x$1) {
                return x$1.toString();
            }
        })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.QUERY_THREADS()), (Object)Option$.MODULE$.apply((Object)this.params().queryThreads()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Integer x$2) {
                return x$2.toString();
            }
        })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RasterUtils.IngestRasterParams$.MODULE$.PARLEVEL()), (Object)new Some((Object)this.params().parLevel().toString()))}));
    }

    public IngestRasterCommand() {
        this.name = "ingest-raster";
    }

    @Parameters(commandDescription="Ingest raster files into GeoMesa")
    public static class IngestRasterParameters
    implements AccumuloConnectionParams,
    AccumuloRasterTableParam {
        @Parameter(names={"--write-memory"}, description="Memory allocation for ingestion operation")
        private String writeMemory;
        @Parameter(names={"--write-threads"}, description="Threads for writing raster data")
        private Integer writeThreads;
        @Parameter(names={"--query-threads"}, description="Threads for quering raster data")
        private Integer queryThreads;
        @Parameter(names={"-F", "--format"}, description="Format of incoming raster data (geotiff | DTED) to override file extension recognition")
        private String format;
        @Parameter(names={"-f", "--file"}, description="Single raster file or directory of raster files to be ingested", validateWith=PathValidator.class, required=true)
        private String file;
        @Parameter(names={"-T", "--timestamp"}, description="Ingestion time (default to current time)")
        private String timeStamp;
        @Parameter(names={"-P", "--parallel-level"}, description="Maximum number of local threads for ingesting multiple raster files (default to 1)")
        private Integer parLevel;
        @Parameter(names={"-t", "--raster-table"}, description="Accumulo table for storing raster data", required=true)
        private String table;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--visibilities"}, description="Default feature visibilities")
        private String visibilities;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name", required=true)
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"--mock"}, description="Run everything with a mock accumulo instance instead of a real one")
        private boolean mock;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;

        @Override
        public String table() {
            return this.table;
        }

        @Override
        @TraitSetter
        public void table_$eq(String x$1) {
            this.table = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        @Override
        public String visibilities() {
            return this.visibilities;
        }

        @Override
        @TraitSetter
        public void visibilities_$eq(String x$1) {
            this.visibilities = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        @TraitSetter
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public boolean mock() {
            return this.mock;
        }

        @Override
        @TraitSetter
        public void mock_$eq(boolean x$1) {
            this.mock = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String writeMemory() {
            return this.writeMemory;
        }

        public void writeMemory_$eq(String x$1) {
            this.writeMemory = x$1;
        }

        public Integer writeThreads() {
            return this.writeThreads;
        }

        public void writeThreads_$eq(Integer x$1) {
            this.writeThreads = x$1;
        }

        public Integer queryThreads() {
            return this.queryThreads;
        }

        public void queryThreads_$eq(Integer x$1) {
            this.queryThreads = x$1;
        }

        public String format() {
            return this.format;
        }

        public void format_$eq(String x$1) {
            this.format = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public String timeStamp() {
            return this.timeStamp;
        }

        public void timeStamp_$eq(String x$1) {
            this.timeStamp = x$1;
        }

        public Integer parLevel() {
            return this.parLevel;
        }

        public void parLevel_$eq(Integer x$1) {
            this.parLevel = x$1;
        }

        public IngestRasterParameters() {
            OptionalZookeepersParam$class.$init$(this);
            InstanceNameParams$class.$init$(this);
            PasswordParams.class.$init$((PasswordParams)this);
            RequiredCredentialsParams.class.$init$((RequiredCredentialsParams)this);
            KerberosParams.class.$init$((KerberosParams)this);
            AccumuloConnectionParams$class.$init$(this);
            AccumuloRasterTableParam$class.$init$(this);
            this.writeMemory = null;
            this.writeThreads = null;
            this.queryThreads = null;
            this.format = null;
            this.file = null;
            this.timeStamp = null;
            this.parLevel = Predef$.MODULE$.int2Integer(1);
        }
    }
}

