/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.data;

import java.util.Map;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.index.AccumuloFeatureIndex;
import org.locationtech.geomesa.accumulo.index.AccumuloFeatureIndex$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class TableConfCommand$ {
    public static final TableConfCommand$ MODULE$;

    static {
        new TableConfCommand$();
    }

    public String getProp(AccumuloDataStore ds, String table, String key) {
        return (String)this.getProperties(ds, table).getOrElse((Object)new Tuple2((Object)table, (Object)key), (Function0)new Serializable(table, key){
            public static final long serialVersionUID = 0L;
            private final String table$2;
            private final String key$1;

            public final Nothing$ apply() {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parameter '", "' not found in table '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1, this.table$2})));
            }
            {
                this.table$2 = table$2;
                this.key$1 = key$1;
            }
        });
    }

    public void setValue(AccumuloDataStore ds, String table, String key, String value) {
        try {
            ds.connector().tableOperations().setProperty(table, key, value);
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error updating table property: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})), exception);
        }
    }

    public Map<Tuple2<String, String>, String> getProperties(AccumuloDataStore ds, String table) {
        try {
            return ((TraversableOnce)JavaConversions$.MODULE$.iterableAsScalaIterable(ds.connector().tableOperations().getProperties(table)).map((Function1)new Serializable(table){
                public static final long serialVersionUID = 0L;
                private final String table$1;

                public final Tuple2<Tuple2<String, String>, String> apply(Map.Entry<String, String> e) {
                    return new Tuple2((Object)new Tuple2((Object)this.table$1, (Object)e.getKey()), (Object)e.getValue());
                }
                {
                    this.table$1 = table$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (TableNotFoundException tableNotFoundException) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: table ", " does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, tableNotFoundException.getMessage()})), tableNotFoundException);
        }
    }

    public Seq<String> getTableNames(AccumuloDataStore ds, SimpleFeatureType sft, String index) {
        Seq indices = AccumuloFeatureIndex$.MODULE$.indices(sft, AccumuloFeatureIndex$.MODULE$.indices$default$2(), AccumuloFeatureIndex$.MODULE$.indices$default$3());
        return (Seq)indices.find((Function1)new Serializable(index){
            public static final long serialVersionUID = 0L;
            private final String index$1;

            public final boolean apply(AccumuloFeatureIndex x$6) {
                return x$6.name().equalsIgnoreCase(this.index$1);
            }
            {
                this.index$1 = index$1;
            }
        }).map((Function1)new Serializable(ds, sft){
            public static final long serialVersionUID = 0L;
            private final AccumuloDataStore ds$1;
            private final SimpleFeatureType sft$1;

            public final Seq<String> apply(AccumuloFeatureIndex x$7) {
                return x$7.getTableNames(this.sft$1, this.ds$1, (Option)None$.MODULE$);
            }
            {
                this.ds$1 = ds$1;
                this.sft$1 = sft$1;
            }
        }).getOrElse((Function0)new Serializable(sft, index, indices){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;
            private final String index$1;
            private final Seq indices$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index '", "' does not exist for schema '", "'. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.index$1, this.sft$1.getTypeName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Available indices: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.indices$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AccumuloFeatureIndex x$8) {
                        return x$8.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).toString());
            }
            {
                this.sft$1 = sft$1;
                this.index$1 = index$1;
                this.indices$1 = indices$1;
            }
        });
    }

    private TableConfCommand$() {
        MODULE$ = this;
    }
}

