/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.data;

import com.beust.jcommander.ParameterException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloFeature;
import org.locationtech.geomesa.accumulo.index.AccumuloFeatureIndex;
import org.locationtech.geomesa.accumulo.index.AccumuloFeatureIndex$;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$class;
import org.locationtech.geomesa.accumulo.tools.data.AddIndexCommand;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata$;
import org.locationtech.geomesa.jobs.accumulo.AccumuloJobUtils$;
import org.locationtech.geomesa.jobs.accumulo.index.WriteIndexArgs;
import org.locationtech.geomesa.jobs.accumulo.index.WriteIndexJob;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u001f\t9\u0012\t\u001a3J]\u0012,\u0007pQ8n[\u0006tG-\u0012=fGV$xN\u001d\u0006\u0003\u0007\u0011\tA\u0001Z1uC*\u0011QAB\u0001\u0006i>|Gn\u001d\u0006\u0003\u000f!\t\u0001\"Y2dk6,Hn\u001c\u0006\u0003\u0013)\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\f\u0019\u0005aAn\\2bi&|g\u000e^3dQ*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!aY\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005EI\u0012B\u0001\u000e\u0013\u0005!\u0011VO\u001c8bE2,\u0007C\u0001\u000f\u001e\u001b\u0005!\u0011B\u0001\u0010\u0005\u0005a\t5mY;nk2|G)\u0019;b'R|'/Z\"p[6\fg\u000e\u001a\u0005\tA\u0001\u0011)\u0019!C!C\u00051\u0001/\u0019:b[N,\u0012A\t\t\u0003GUr!\u0001J\u001a\u000f\u0005\u0015\u0012dB\u0001\u00142\u001d\t9\u0003G\u0004\u0002)_9\u0011\u0011F\f\b\u0003U5j\u0011a\u000b\u0006\u0003Y9\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003i\t\tq\"\u00113e\u0013:$W\r_\"p[6\fg\u000eZ\u0005\u0003m]\u0012!#\u00113e\u0013:$W\r\u001f)be\u0006lW\r^3sg*\u0011AG\u0001\u0005\ts\u0001\u0011\t\u0011)A\u0005E\u00059\u0001/\u0019:b[N\u0004\u0003\"B\u001e\u0001\t\u0003a\u0014A\u0002\u001fj]&$h\b\u0006\u0002>\u007fA\u0011a\bA\u0007\u0002\u0005!)\u0001E\u000fa\u0001E!9\u0011\t\u0001b\u0001\n\u0003\u0012\u0015\u0001\u00028b[\u0016,\u0012a\u0011\t\u0003#\u0011K!!\u0012\n\u0003\rM#(/\u001b8h\u0011\u00199\u0005\u0001)A\u0005\u0007\u0006)a.Y7fA!)\u0011\n\u0001C!\u0015\u00069Q\r_3dkR,G#A&\u0011\u00051{U\"A'\u000b\u00039\u000bQa]2bY\u0006L!\u0001U'\u0003\tUs\u0017\u000e\u001e\u0005\u0006%\u0002!\tES\u0001\u0004eVt\u0007\"\u0002+\u0001\t\u0003)\u0016\u0001C1eI&sG-\u001a=\u0015\u0005-3\u0006\"B,T\u0001\u0004A\u0016A\u00013t!\tI6,D\u0001[\u0015\t\u0019a!\u0003\u0002]5\n\t\u0012iY2v[Vdw\u000eR1uCN#xN]3")
public class AddIndexCommandExecutor
implements Runnable,
AccumuloDataStoreCommand {
    private final AddIndexCommand.AddIndexParameters params;
    private final String name;
    private final Map<String, String> org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults;
    private volatile boolean bitmap$0;

    private Map org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults$lzycompute() {
        AddIndexCommandExecutor addIndexCommandExecutor = this;
        synchronized (addIndexCommandExecutor) {
            if (!this.bitmap$0) {
                this.org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults = AccumuloDataStoreCommand$class.org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults(this);
                this.bitmap$0 = true;
            }
            return this.org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults;
        }
    }

    @Override
    public Map<String, String> org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults() {
        return this.bitmap$0 ? this.org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults : this.org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults$lzycompute();
    }

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand$class.connection(this);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    @Override
    public AddIndexCommand.AddIndexParameters params() {
        return this.params;
    }

    public String name() {
        return this.name;
    }

    public void execute() {
    }

    @Override
    public void run() {
        this.withDataStore((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddIndexCommandExecutor $outer;

            public final void apply(AccumuloDataStore ds) {
                this.$outer.addIndex(ds);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addIndex(AccumuloDataStore ds) {
        Object x$12;
        Object x$9;
        List x$8;
        String x$7;
        SimpleFeatureType sft = ds.getSchema(this.params().featureName());
        Predef$.MODULE$.require(sft != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddIndexCommandExecutor $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' does not exist in the specified data store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.params().featureName()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Buffer indices = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(this.params().indexNames()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AccumuloFeatureIndex apply(String name) {
                return (AccumuloFeatureIndex)AccumuloFeatureIndex$.MODULE$.CurrentIndices().find((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final boolean apply(AccumuloFeatureIndex x$1) {
                        String string = x$1.name();
                        String string2 = this.name$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.name$1 = name$1;
                    }
                }).getOrElse((Function0)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final Nothing$ apply() {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid index '", "'. Valid values are "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)AccumuloFeatureIndex$.MODULE$.CurrentIndices().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(AccumuloFeatureIndex x$2) {
                                return x$2.name();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).toString());
                    }
                    {
                        this.name$1 = name$1;
                    }
                });
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Seq existing = AccumuloFeatureIndex$.MODULE$.indices(sft, AccumuloFeatureIndex$.MODULE$.indices$default$2(), AccumuloFeatureIndex$.MODULE$.indices$default$3());
        Predef$.MODULE$.require(indices.forall((Function1)new Serializable(this, existing){
            public static final long serialVersionUID = 0L;
            private final Seq existing$1;

            public final boolean apply(AccumuloFeatureIndex i) {
                return !this.existing$1.contains((Object)i);
            }
            {
                this.existing$1 = existing$1;
            }
        }), (Function0)new Serializable(this, existing){
            public static final long serialVersionUID = 0L;
            private final Seq existing$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested indices already exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.existing$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AccumuloFeatureIndex x$3) {
                        return x$3.identifier();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("[", "][", "]")}));
            }
            {
                this.existing$1 = existing$1;
            }
        });
        Predef$.MODULE$.require(indices.forall((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final boolean apply(AccumuloFeatureIndex x$4) {
                return x$4.supports(this.sft$1);
            }
            {
                this.sft$1 = sft$1;
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Requested indices are not compatible with the simple feature type";
            }
        });
        Buffer toDisable = (Buffer)indices.flatMap((Function1)new Serializable(this, existing){
            public static final long serialVersionUID = 0L;
            private final Seq existing$1;

            public final Iterable<Tuple2<AccumuloFeatureIndex, GeoMesaFeatureIndex<AccumuloDataStore, AccumuloFeature, Mutation>>> apply(AccumuloFeatureIndex i) {
                return Option$.MODULE$.option2Iterable(AccumuloFeatureIndex$.MODULE$.replaces((GeoMesaFeatureIndex)i, this.existing$1).map((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final AccumuloFeatureIndex i$1;

                    public final Tuple2<AccumuloFeatureIndex, GeoMesaFeatureIndex<AccumuloDataStore, AccumuloFeature, Mutation>> apply(GeoMesaFeatureIndex<AccumuloDataStore, AccumuloFeature, Mutation> r) {
                        return new Tuple2((Object)this.i$1, r);
                    }
                    {
                        this.i$1 = i$1;
                    }
                }));
            }
            {
                this.existing$1 = existing$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        if (toDisable.nonEmpty() && !Prompt$.MODULE$.confirm(x$7 = new StringBuilder().append((Object)"The following index versions will be replaced: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)toDisable.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<AccumuloFeatureIndex, GeoMesaFeatureIndex<AccumuloDataStore, AccumuloFeature, Mutation>> x0$1) {
                Tuple2<AccumuloFeatureIndex, GeoMesaFeatureIndex<AccumuloDataStore, AccumuloFeature, Mutation>> tuple2 = x0$1;
                if (tuple2 != null) {
                    AccumuloFeatureIndex n = (AccumuloFeatureIndex)tuple2._1();
                    GeoMesaFeatureIndex o = (GeoMesaFeatureIndex)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] by [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{o.identifier(), n.identifier()}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(", ")}))).append((Object)"Continue? (y/n): ").toString(), x$8 = Prompt$.MODULE$.confirm$default$2(), x$9 = Prompt$.MODULE$.confirm$default$3(x$7, x$8))) {
            return;
        }
        String x$10 = "If you are ingesting streaming data, you will be required to restart the streaming ingestion when prompted. Continue? (y/n): ";
        List x$11 = Prompt$.MODULE$.confirm$default$2();
        if (!Prompt$.MODULE$.confirm(x$10, x$11, x$12 = Prompt$.MODULE$.confirm$default$3(x$10, x$11))) return;
        String backupKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".bak"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GeoMesaMetadata$.MODULE$.ATTRIBUTES_KEY()}));
        ds.metadata().insert(sft.getTypeName(), backupKey, ds.metadata().readRequired(sft.getTypeName(), GeoMesaMetadata$.MODULE$.ATTRIBUTES_KEY()));
        Seq toKeep = (Seq)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).filter((Function1)new Serializable(this, toDisable){
            public static final long serialVersionUID = 0L;
            private final Buffer toDisable$1;

            public final boolean apply(Tuple3<String, Object, IndexMode.IndexMode> x0$2) {
                Tuple3<String, Object, IndexMode.IndexMode> tuple3 = x0$2;
                if (tuple3 != null) {
                    String n = (String)tuple3._1();
                    int v = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    boolean bl = !((SeqLike)this.toDisable$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final GeoMesaFeatureIndex<AccumuloDataStore, AccumuloFeature, Mutation> apply(Tuple2<AccumuloFeatureIndex, GeoMesaFeatureIndex<AccumuloDataStore, AccumuloFeature, Mutation>> x$5) {
                            return (GeoMesaFeatureIndex)x$5._2();
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).contains(AccumuloFeatureIndex$.MODULE$.lookup().apply((Object)new Tuple2((Object)n, (Object)BoxesRunTime.boxToInteger((int)v))));
                    return bl;
                }
                throw new MatchError(tuple3);
            }
            {
                this.toDisable$1 = toDisable$1;
            }
        });
        if (this.params().noBackFill() != null && Predef$.MODULE$.Boolean2boolean(this.params().noBackFill())) {
            Command$.MODULE$.user().info("Adding new indices and disabling old ones");
            RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft), (Seq)((BufferLike)indices.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple3<String, Object, IndexMode.IndexMode> apply(AccumuloFeatureIndex i) {
                    return new Tuple3((Object)i.name(), (Object)BoxesRunTime.boxToInteger((int)i.version()), (Object)IndexMode$.MODULE$.ReadWrite());
                }
            }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)toKeep));
            ds.updateSchema(sft.getTypeName(), sft);
        } else {
            int result;
            int n;
            Command$.MODULE$.user().info("Adding new indices in write-only mode");
            RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft), (Seq)((BufferLike)indices.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple3<String, Object, IndexMode.IndexMode> apply(AccumuloFeatureIndex i) {
                    return new Tuple3((Object)i.name(), (Object)BoxesRunTime.boxToInteger((int)i.version()), (Object)IndexMode$.MODULE$.Write());
                }
            }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))));
            ds.updateSchema(sft.getTypeName(), sft);
            String x$13 = "Indices have been added in write-only mode. To pick up the changes, please bounce any streaming ingestion. Once ingestion has resumed, press 'enter' to continue.";
            Object x$14 = Prompt$.MODULE$.acknowledge$default$2(x$13);
            Prompt$.MODULE$.acknowledge(x$13, x$14);
            Command$.MODULE$.user().info("Running index back-fill job");
            WriteIndexArgs args = new WriteIndexArgs((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            args.inZookeepers_$eq(this.params().zookeepers());
            args.inInstanceId_$eq(this.params().instance());
            args.inUser_$eq(this.params().user());
            args.inPassword_$eq(this.params().password());
            args.inTableName_$eq(this.params().catalog());
            args.inFeature_$eq(this.params().featureName());
            args.inCql_$eq((String)Option$.MODULE$.apply((Object)this.params().cqlFilter()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Filter x$1) {
                    return ECQL.toCQL((Filter)x$1);
                }
            }).orNull(Predef$.MODULE$.$conforms()));
            args.indexNames().addAll(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)indices.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(AccumuloFeatureIndex x$6) {
                    return x$6.identifier();
                }
            }, Buffer$.MODULE$.canBuildFrom())));
            Some libjars = new Some((Object)new Tuple2((Object)AccumuloJobUtils$.MODULE$.defaultLibJars(), (Object)AccumuloJobUtils$.MODULE$.defaultSearchPath()));
            try {
                n = ToolRunner.run((Tool)new WriteIndexJob((Option)libjars), (String[])args.unparse());
            }
            catch (Throwable throwable) {
                int n2;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                Command$.MODULE$.user().error("Error running back-fill job:", e);
                n = result = (n2 = -1);
            }
            if (result == 0) {
                this.setReadWrite$1(ds, sft, indices, toKeep);
            } else {
                String string;
                String string2;
                String string3;
                String response = null;
                do {
                    String x$15 = "Index back-fill job failed. You may:\n  1. Switch the indices to read-write mode without existing data (you may manually back-fill later)\n  2. Roll-back index creation\nSelect an option: ";
                    Object x$16 = Prompt$.MODULE$.read$default$2(x$15);
                    String string4 = response = Prompt$.MODULE$.read(x$15, x$16);
                    String string5 = "1";
                    if (!(string4 == null ? string5 != null : !string4.equals(string5))) break;
                    string3 = response;
                    string2 = "2";
                } while (string3 != null ? !string3.equals(string2) : string2 != null);
                if ("1".equals(string = response)) {
                    this.setReadWrite$1(ds, sft, indices, toKeep);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (!"2".equals(string)) throw new MatchError((Object)string);
                    String bak = (String)ds.metadata().readRequired(sft.getTypeName(), backupKey);
                    ds.metadata().insert(sft.getTypeName(), GeoMesaMetadata$.MODULE$.ATTRIBUTES_KEY(), (Object)bak);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        Command$.MODULE$.user().info("Operation complete. Please bounce any streaming ingestion to pick up the changes.");
    }

    private final void setReadWrite$1(AccumuloDataStore ds$1, SimpleFeatureType sft$1, Buffer indices$1, Seq toKeep$1) {
        Command$.MODULE$.user().info("Setting index to read-write mode and disabling old indices");
        RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1), (Seq)((BufferLike)indices$1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<String, Object, IndexMode.IndexMode> apply(AccumuloFeatureIndex i) {
                return new Tuple3((Object)i.name(), (Object)BoxesRunTime.boxToInteger((int)i.version()), (Object)IndexMode$.MODULE$.ReadWrite());
            }
        }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)toKeep$1));
        Command$.MODULE$.user().info(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1)).toString());
        ds$1.updateSchema(sft$1.getTypeName(), sft$1);
    }

    public AddIndexCommandExecutor(AddIndexCommand.AddIndexParameters params) {
        this.params = params;
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        AccumuloDataStoreCommand$class.$init$(this);
        this.name = "";
    }
}

