/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams$class;
import org.locationtech.geomesa.accumulo.tools.OptionalZookeepersParam$class;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredCredentialsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u001f\t)\u0012iY2v[Vdw.\u0012=q_J$8i\\7nC:$'BA\u0002\u0005\u0003\u0019)\u0007\u0010]8si*\u0011QAB\u0001\u0006i>|Gn\u001d\u0006\u0003\u000f!\t\u0001\"Y2dk6,Hn\u001c\u0006\u0003\u0013)\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\f\u0019\u0005aAn\\2bi&|g\u000e^3dQ*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!Y\u0011\u0003CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rE\u0002\u00185qi\u0011\u0001\u0007\u0006\u0003\u0007eQ!!\u0002\u0005\n\u0005mA\"!D#ya>\u0014HoQ8n[\u0006tG\r\u0005\u0002\u001eA5\taD\u0003\u0002 \r\u0005!A-\u0019;b\u0013\t\tcDA\tBG\u000e,X.\u001e7p\t\u0006$\u0018m\u0015;pe\u0016\u0004\"a\t\u0013\u000e\u0003\u0011I!!\n\u0003\u00031\u0005\u001b7-^7vY>$\u0015\r^1Ti>\u0014XmQ8n[\u0006tG\rC\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u0002\u0005!9A\u0006\u0001b\u0001\n\u0003j\u0013A\u00029be\u0006l7/F\u0001/!\tycI\u0004\u00021\u007f9\u0011\u0011G\u0010\b\u0003eur!a\r\u001f\u000f\u0005QZdBA\u001b;\u001d\t1\u0014(D\u00018\u0015\tAd\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u000f\u0015\u0001%\u0001#\u0001B\u0003U\t5mY;nk2|W\t\u001f9peR\u001cu.\\7b]\u0012\u0004\"A\u000b\"\u0007\u000b\u0005\u0011\u0001\u0012A\"\u0014\u0005\t\u0003\u0002\"B\u0014C\t\u0003)E#A!\u0007\t\u001d\u0013\u0005\u0001\u0013\u0002\u0015\u0003\u000e\u001cW/\\;m_\u0016C\bo\u001c:u!\u0006\u0014\u0018-\\:\u0014\r\u0019\u0003\u0012\nV,\\!\tQ\u0015K\u0004\u0002L\u001f:\u0011AJ\u0014\b\u0003g5K!!\u0002\u0005\n\u0005\rI\u0012B\u0001)\u0019\u00035)\u0005\u0010]8si\u000e{W.\\1oI&\u0011!k\u0015\u0002\r\u000bb\u0004xN\u001d;QCJ\fWn\u001d\u0006\u0003!b\u0001\"aI+\n\u0005Y#!aF!dGVlW\u000f\\8ECR\f7\u000b^8sKB\u000b'/Y7t!\tA\u0016,D\u0001\u001a\u0013\tQ\u0016DA\u000bSKF,\u0018N]3e)f\u0004XMT1nKB\u000b'/Y7\u0011\u0005ac\u0016BA/\u001a\u0005Iy\u0005\u000f^5p]\u0006d\u0017J\u001c3fqB\u000b'/Y7\t\u000b\u001d2E\u0011A0\u0015\u0003\u0001\u0004\"!\u0019$\u000e\u0003\tCCAR2n]B\u0011Am[\u0007\u0002K*\u0011amZ\u0001\u000bU\u000e|W.\\1oI\u0016\u0014(B\u00015j\u0003\u0015\u0011W-^:u\u0015\u0005Q\u0017aA2p[&\u0011A.\u001a\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018AE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0013a\\\u0001*\u000bb\u0004xN\u001d;!M\u0016\fG/\u001e:fg\u00022'o\\7!C\u0002:Um\\'fg\u0006\u0004C-\u0019;bAM$xN]3\t\rE\u0004\u0001\u0015!\u0003/\u0003\u001d\u0001\u0018M]1ng\u0002\u0002")
public class AccumuloExportCommand
implements ExportCommand<AccumuloDataStore>,
AccumuloDataStoreCommand {
    private final AccumuloExportParams params;
    private final scala.collection.immutable.Map<String, String> org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults;
    private final String name;
    private final Logger logger;
    private volatile byte bitmap$0;

    private scala.collection.immutable.Map org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults$lzycompute() {
        AccumuloExportCommand accumuloExportCommand = this;
        synchronized (accumuloExportCommand) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults = AccumuloDataStoreCommand$class.org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults;
        }
    }

    @Override
    public scala.collection.immutable.Map<String, String> org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults$lzycompute() : this.org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$$mockDefaults;
    }

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return AccumuloDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds);
    }

    public Option<Object> export(FeatureExporter exporter, SimpleFeatureCollection collection) {
        return ExportCommand.class.export((ExportCommand)this, (FeatureExporter)exporter, (SimpleFeatureCollection)collection);
    }

    public SimpleFeatureType getSchema(DataStore ds) {
        return ExportCommand.class.getSchema((ExportCommand)this, (DataStore)ds);
    }

    public SimpleFeatureCollection getFeatures(DataStore ds, Query query) {
        return ExportCommand.class.getFeatures((ExportCommand)this, (DataStore)ds, (Query)query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        AccumuloExportCommand accumuloExportCommand = this;
        synchronized (accumuloExportCommand) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public AccumuloExportParams params() {
        return this.params;
    }

    public AccumuloExportCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        AccumuloDataStoreCommand$class.$init$(this);
        this.params = new AccumuloExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class AccumuloExportParams
    implements ExportCommand.ExportParams,
    AccumuloDataStoreParams,
    RequiredTypeNameParam,
    OptionalIndexParam {
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--visibilities"}, description="Default feature visibilities")
        private String visibilities;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name", required=true)
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"--mock"}, description="Run everything with a mock accumulo instance instead of a real one")
        private boolean mock;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", required=false, converter=ParameterConverters.ExportFormatConverter.class)
        private Enumeration.Value outputFormat;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header", required=false)
        private boolean noHeader;
        @Parameter(names={"-m", "--max-features"}, description="Maximum number of features to return. default: Unlimited")
        private Integer maxFeatures;
        @Parameter(names={"-a", "--attributes"}, description="Attributes from feature to export (comma-separated)...Comma-separated expressions with each in the format attribute[=filter_function_expression]|derived-attribute=filter_function_expression|'id'. 'id' will export the feature ID, filter_function_expression is an expression of filter function applied to attributes, literals and filter functions, i.e. can be nested")
        private List<String> attributes;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        @Override
        public String visibilities() {
            return this.visibilities;
        }

        @Override
        @TraitSetter
        public void visibilities_$eq(String x$1) {
            this.visibilities = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        @TraitSetter
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public boolean mock() {
            return this.mock;
        }

        @Override
        @TraitSetter
        public void mock_$eq(boolean x$1) {
            this.mock = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public Enumeration.Value outputFormat() {
            return this.outputFormat;
        }

        public void outputFormat_$eq(Enumeration.Value x$1) {
            this.outputFormat = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public AccumuloExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            OptionalZookeepersParam$class.$init$(this);
            InstanceNameParams$class.$init$(this);
            PasswordParams.class.$init$((PasswordParams)this);
            RequiredCredentialsParams.class.$init$((RequiredCredentialsParams)this);
            KerberosParams.class.$init$((KerberosParams)this);
            AccumuloConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.class.$init$((OptionalIndexParam)this);
        }
    }
}

