/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools;

import com.beust.jcommander.ParameterException;
import java.util.concurrent.TimeoutException;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams;
import org.locationtech.geomesa.accumulo.tools.RunnerWithAccumuloEnvironment;
import org.locationtech.geomesa.accumulo.tools.RunnerWithAccumuloEnvironment$;
import org.locationtech.geomesa.tools.Command;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.xml.Node;
import scala.xml.XML$;

public abstract class RunnerWithAccumuloEnvironment$class {
    public static void resolveEnvironment(RunnerWithAccumuloEnvironment $this, Command command) {
        Option params = Option$.MODULE$.apply(command.params());
        params.collect((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                AccumuloConnectionParams accumuloConnectionParams = null;
                A1 A1 = x1;
                if (A1 instanceof AccumuloConnectionParams) {
                    bl = true;
                    accumuloConnectionParams = (AccumuloConnectionParams)A1;
                    if (accumuloConnectionParams.password() != null && accumuloConnectionParams.keytab() != null) {
                        throw new ParameterException("Cannot specify both password and keytab");
                    }
                }
                Object object = bl && accumuloConnectionParams.password() == null && accumuloConnectionParams.keytab() == null && !accumuloConnectionParams.mock() ? accumuloConnectionParams : function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                boolean bl = false;
                AccumuloConnectionParams accumuloConnectionParams = null;
                Object object = x1;
                if (object instanceof AccumuloConnectionParams) {
                    bl = true;
                    accumuloConnectionParams = (AccumuloConnectionParams)object;
                    if (accumuloConnectionParams.password() != null && accumuloConnectionParams.keytab() != null) {
                        return true;
                    }
                }
                if (!bl) return false;
                if (accumuloConnectionParams.password() != null) return false;
                if (accumuloConnectionParams.keytab() != null) return false;
                if (accumuloConnectionParams.mock()) return false;
                return true;
            }
        }).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(AccumuloConnectionParams x$1) {
                x$1.password_$eq(Prompt$.MODULE$.readPassword(Prompt$.MODULE$.readPassword$default$1()));
            }
        });
        params.collect((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                InstanceNameParams instanceNameParams;
                A1 A1 = x2;
                Object object = A1 instanceof InstanceNameParams && !(instanceNameParams = (InstanceNameParams)A1).mock() ? instanceNameParams : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                InstanceNameParams instanceNameParams;
                Object object = x2;
                boolean bl = object instanceof InstanceNameParams && !(instanceNameParams = (InstanceNameParams)object).mock();
                return bl;
            }
        }).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(InstanceNameParams p) {
                if (p.zookeepers() == null) {
                    String accumuloSiteXml = (String)new GeoMesaSystemProperties.SystemProperty("geomesa.tools.accumulo.site.xml", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/conf/accumulo-site.xml"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{System.getenv("ACCUMULO_HOME")}));
                        }
                    });
                    p.zookeepers_$eq(this.liftedTree1$1(accumuloSiteXml));
                }
                if (p.instance() == null) {
                    p.instance_$eq(this.liftedTree2$1());
                }
            }

            private final String liftedTree1$1(String accumuloSiteXml$1) {
                try {
                    return (String)((IterableLike)((TraversableLike)XML$.MODULE$.loadFile(accumuloSiteXml$1).$bslash$bslash("property").filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Node x) {
                            String string = x.$bslash("name").text();
                            String string2 = "instance.zookeeper.host";
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Node y) {
                            return y.$bslash("value").text();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).head();
                }
                catch (Throwable throwable) {
                    throw new ParameterException("Accumulo Site XML was not found or was unable to be read, unable to locate zookeepers. Please provide the --zookeepers parameter or ensure the file $ACCUMULO_HOME/conf/accumulo-site.xml exists or optionally, specify a different configuration file with the System Property 'geomesa.tools.accumulo.site.xml'.", throwable);
                }
            }

            private final Either liftedTree3$1() {
                Left left;
                try {
                    String i = HdfsZooInstance.getInstance().getInstanceName();
                    left = package$.MODULE$.Right().apply((Object)i);
                }
                catch (Throwable throwable) {
                    left = package$.MODULE$.Left().apply((Object)throwable);
                }
                return left;
            }

            private final Either ff$lzycompute$1(ObjectRef ff$lzy$1, VolatileByteRef bitmap$0$1) {
                RunnerWithAccumuloEnvironment$.anonfun.resolveEnvironment.4 var3_3 = this;
                synchronized (var3_3) {
                    if ((byte)(bitmap$0$1.elem & 1) == 0) {
                        ff$lzy$1.elem = this.liftedTree3$1();
                        bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
                    }
                    return (Either)ff$lzy$1.elem;
                }
            }

            public final Either org$locationtech$geomesa$accumulo$tools$RunnerWithAccumuloEnvironment$class$$anonfun$$ff$1(ObjectRef ff$lzy$1, VolatileByteRef bitmap$0$1) {
                return (byte)(bitmap$0$1.elem & 1) == 0 ? this.ff$lzycompute$1(ff$lzy$1, bitmap$0$1) : (Either)ff$lzy$1.elem;
            }

            private final String liftedTree2$1() {
                VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
                try {
                    Either future;
                    ObjectRef ff$lzy = ObjectRef.zero();
                    long lookupTime = BoxesRunTime.unboxToLong((Object)new GeoMesaSystemProperties.SystemProperty("instance.zookeeper.timeout", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Option<Object> apply(String p) {
                            return Try$.MODULE$.apply((Function0)new Serializable(this, p){
                                public static final long serialVersionUID = 0L;
                                private final String p$1;

                                public final long apply() {
                                    return this.apply$mcJ$sp();
                                }

                                public long apply$mcJ$sp() {
                                    return Long.parseLong(this.p$1);
                                }
                                {
                                    this.p$1 = p$1;
                                }
                            }).toOption();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 5000L;
                        }
                    }));
                    Command$.MODULE$.user().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Looking up Accumulo Instance Id in Zookeeper for ", " milliseconds."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lookupTime)})));
                    Command$.MODULE$.user().debug("You can specify the Instance Id via the command line or\nchange the Zookeeper timeout by setting the system property 'instance.zookeeper.timeout'.");
                    Either either = future = (Either)Await$.MODULE$.result((Awaitable)Future$.MODULE$.apply((Function0)new Serializable(this, ff$lzy, bitmap$0){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ RunnerWithAccumuloEnvironment$.anonfun.resolveEnvironment.4 $outer;
                        private final ObjectRef ff$lzy$1;
                        private final VolatileByteRef bitmap$0$1;

                        public final Either<Throwable, String> apply() {
                            return this.$outer.org$locationtech$geomesa$accumulo$tools$RunnerWithAccumuloEnvironment$class$$anonfun$$ff$1(this.ff$lzy$1, this.bitmap$0$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.ff$lzy$1 = ff$lzy$1;
                            this.bitmap$0$1 = bitmap$0$1;
                        }
                    }, (ExecutionContext)ExecutionContext$.MODULE$.global()), (Duration)new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(lookupTime)).millis());
                    if (either instanceof Right) {
                        String instanceId;
                        Right right = (Right)either;
                        String string = instanceId = (String)right.b();
                        return string;
                    }
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Throwable e = (Throwable)left.a();
                        throw e;
                    }
                    throw new MatchError((Object)either);
                }
                catch (Throwable throwable) {
                    throw new ParameterException("Unable to locate Accumulo instance. Please ensure that $ACCUMULO_HOME is set correctly and/or provide the instance name with the parameter --instance.", throwable);
                }
                catch (TimeoutException timeoutException) {
                    throw new ParameterException("Unable to connect to Zookeeper instance within timeout period. Consider increasing the Zookeeper timeout by setting the system property 'instance.zookeeper.timeout' (default: 5000ms).", (Throwable)timeoutException);
                }
            }
        });
    }

    public static Option environmentErrorInfo(RunnerWithAccumuloEnvironment $this) {
        return scala.sys.package$.MODULE$.env().get((Object)"ACCUMULO_HOME").isEmpty() || scala.sys.package$.MODULE$.env().get((Object)"HADOOP_HOME").isEmpty() ? Option$.MODULE$.apply((Object)"\nWarning: ACCUMULO_HOME and/or HADOOP_HOME are not set as environment variables.\nGeoMesa tools will not run without the appropriate Accumulo and Hadoop jars in the tools classpath.\nPlease ensure that those jars are present in the classpath by running 'geomesa classpath'.\nTo take corrective action, please place the necessary jar files in the lib directory of geomesa-tools.") : None$.MODULE$;
    }

    public static void $init$(RunnerWithAccumuloEnvironment $this) {
    }
}

