/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.data;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.common.primitives.UnsignedBytes;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.hadoop.io.Text;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams$class;
import org.locationtech.geomesa.accumulo.tools.OptionalZookeepersParam$class;
import org.locationtech.geomesa.accumulo.tools.data.AccumuloCompactCommand$;
import org.locationtech.geomesa.accumulo.tools.data.AccumuloCompactCommand$$anonfun$execute$1$;
import org.locationtech.geomesa.accumulo.tools.data.AccumuloCompactCommand$$anonfun$execute$1$$anonfun$apply$5$;
import org.locationtech.geomesa.accumulo.tools.data.AccumuloCompactCommand$$anonfun$execute$1$$anonfun$org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.index.id.IdIndex$;
import org.locationtech.geomesa.index.index.z3.Z3Index$;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.RequiredCredentialsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.locationtech.geomesa.utils.uuid.Z3UuidGenerator$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.expression.Expression;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u0001=\u0011a#Q2dk6,Hn\\\"p[B\f7\r^\"p[6\fg\u000e\u001a\u0006\u0003\u0007\u0011\tA\u0001Z1uC*\u0011QAB\u0001\u0006i>|Gn\u001d\u0006\u0003\u000f!\t\u0001\"Y2dk6,Hn\u001c\u0006\u0003\u0013)\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\f\u0019\u0005aAn\\2bi&|g\u000e^3dQ*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u0005a\t5mY;nk2|G)\u0019;b'R|'/Z\"p[6\fg\u000e\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013\u0005\u0013%\u0001\u0003oC6,W#\u0001\u0012\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001\u00027b]\u001eT\u0011aJ\u0001\u0005U\u00064\u0018-\u0003\u0002*I\t11\u000b\u001e:j]\u001eDaa\u000b\u0001!\u0002\u0013\u0011\u0013!\u00028b[\u0016\u0004\u0003bB\u0017\u0001\u0005\u0004%\tEL\u0001\u0007a\u0006\u0014\u0018-\\:\u0016\u0003=\u0002\"\u0001M$\u000f\u0005E\u0002eB\u0001\u001a@\u001d\t\u0019dH\u0004\u00025{9\u0011Q\u0007\u0010\b\u0003mmr!a\u000e\u001e\u000e\u0003aR!!\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u00119Q!\u0011\u0002\t\u0002\t\u000ba#Q2dk6,Hn\\\"p[B\f7\r^\"p[6\fg\u000e\u001a\t\u0003=\r3Q!\u0001\u0002\t\u0002\u0011\u001b\"a\u0011\t\t\u000bm\u0019E\u0011\u0001$\u0015\u0003\t3A\u0001S\"\u0001\u0013\ni1i\\7qC\u000e$\b+\u0019:b[N\u001cBa\u0012\tK\u001fB\u00111*T\u0007\u0002\u0019*\u0011Q\u0001C\u0005\u0003\u001d2\u0013QCU3rk&\u0014X\r\u001a+za\u0016t\u0015-\\3QCJ\fW\u000e\u0005\u0002\u0018!&\u0011\u0011\u000b\u0002\u0002\u0018\u0003\u000e\u001cW/\\;m_\u0012\u000bG/Y*u_J,\u0007+\u0019:b[NDQaG$\u0005\u0002M#\u0012\u0001\u0016\t\u0003+\u001ek\u0011a\u0011\u0005\b/\u001e\u0003\r\u0011\"\u0001Y\u0003\u001d!\bN]3bIN,\u0012!\u0017\t\u0003GiK!a\u0017\u0013\u0003\u000f%sG/Z4fe\"9Ql\u0012a\u0001\n\u0003q\u0016a\u0003;ie\u0016\fGm]0%KF$\"a\u00182\u0011\u0005E\u0001\u0017BA1\u0013\u0005\u0011)f.\u001b;\t\u000f\rd\u0016\u0011!a\u00013\u0006\u0019\u0001\u0010J\u0019\t\r\u0015<\u0005\u0015)\u0003Z\u0003!!\bN]3bIN\u0004\u0003F\u00023hcJ,h\u000f\u0005\u0002i_6\t\u0011N\u0003\u0002kW\u0006Q!nY8n[\u0006tG-\u001a:\u000b\u00051l\u0017!\u00022fkN$(\"\u00018\u0002\u0007\r|W.\u0003\u0002qS\nI\u0001+\u0019:b[\u0016$XM]\u0001\u0006]\u0006lWm\u001d\u0017\u0002g\u0006\nA/A\u0005.[QD'/Z1eg\u0006YA-Z:de&\u0004H/[8oC\u00059\u0018A\u000b(v[\n,'\u000fI8gAI\fgnZ3tAQ|\u0007eY8na\u0006\u001cG\u000fI:j[VdG/\u00198f_V\u001cH.\u001f\u0005\ns\u001e\u0003\r\u00111A\u0005\u0002i\fAA\u001a:p[V\t1\u0010E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\f\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0003\u0003\u0011\u0012AC2p]\u000e,(O]3oi&\u0019\u0011QA?\u0003\u0011\u0011+(/\u0019;j_:D1\"!\u0003H\u0001\u0004\u0005\r\u0011\"\u0001\u0002\f\u0005AaM]8n?\u0012*\u0017\u000fF\u0002`\u0003\u001bA\u0001bYA\u0004\u0003\u0003\u0005\ra\u001f\u0005\b\u0003#9\u0005\u0015)\u0003|\u0003\u00151'o\\7!Q5\tyaZ9\u0002\u0016U\fY\"a\b\u0002\"1\u0012\u0011qC\u0011\u0003\u00033\ta!L\u0017ge>l\u0017EAA\u000f\u0003\u0005%\u0001j\\<!Y>tw\rI1h_\u0002\"x\u000eI2p[B\f7\r\u001e\u0011eCR\fG\u0006\t2bg\u0016$\u0007e\u001c8!i\",\u0007\u0005Z3gCVdG\u000f\t3bi\u0016\u0004\u0013\r\u001e;sS\n,H/\u001a\u0017!e\u0016d\u0017\r^5wK\u0002\"x\u000eI2veJ,g\u000e\u001e\u0011uS6,g\u0006I#/O:\u0002s%\r\u0011eCf<C\u0006I\u00143A],Wm[:!C:$\u0007%\r\u0011i_V\u0014x\u0005\f\u0011fi\u000e\f\u0011bY8om\u0016\u0014H/\u001a:$\u0005\u0005\r\u0002\u0003BA\u0013\u0003oqA!a\n\u000229!\u0011\u0011FA\u0017\u001d\r!\u00141F\u0005\u0003\u000b!I1!a\fM\u0003\u0015)H/\u001b7t\u0013\u0011\t\u0019$!\u000e\u0002'A\u000b'/Y7fi\u0016\u00148i\u001c8wKJ$XM]:\u000b\u0007\u0005=B*\u0003\u0003\u0002:\u0005m\"!\u0005#ve\u0006$\u0018n\u001c8D_:4XM\u001d;fe*!\u00111GA\u001b\u0011%qx\t1AA\u0002\u0013\u0005!\u0010C\u0006\u0002B\u001d\u0003\r\u00111A\u0005\u0002\u0005\r\u0013\u0001\u00043ve\u0006$\u0018n\u001c8`I\u0015\fHcA0\u0002F!A1-a\u0010\u0002\u0002\u0003\u00071\u0010C\u0004\u0002J\u001d\u0003\u000b\u0015B>\u0002\u0013\u0011,(/\u0019;j_:\u0004\u0003&DA$OF\fi%^A*\u0003?\t\t\u0003\f\u0002\u0002P\u0005\u0012\u0011\u0011K\u0001\u000b[5\"WO]1uS>t\u0017EAA+\u0003\u0005\u0015\u0011)\\8v]R\u0004sN\u001a\u0011uS6,\u0007\u0005^8!G>l\u0007/Y2uA\u0011\fG/\u0019\u0017!E\u0006\u001cX\r\u001a\u0011p]\u0002\"\b.\u001a\u0011eK\u001a\fW\u000f\u001c;!I\u0006$X\rI1uiJL'-\u001e;fY\u0001\u0012X\r\\1uSZ,\u0007\u0005^8!O5jcM]8nO9\u0002SIL4/A\u001d\n\u0004\u0005Z1zO1\u0002sE\r\u0011xK\u0016\\7\u000fI1oI\u0002\n\u0004\u0005[8ve\u001eb\u0003%\u001a;d\u0011%\tIf\u0012a\u0001\n\u0003\tY&A\u0003{g%#7/\u0006\u0002\u0002^A\u0019\u0011#a\u0018\n\u0007\u0005\u0005$CA\u0004C_>dW-\u00198\t\u0013\u0005\u0015t\t1A\u0005\u0002\u0005\u001d\u0014!\u0003>4\u0013\u0012\u001cx\fJ3r)\ry\u0016\u0011\u000e\u0005\nG\u0006\r\u0014\u0011!a\u0001\u0003;B\u0001\"!\u001cHA\u0003&\u0011QL\u0001\u0007uNJEm\u001d\u0011)\u0013\u0005-t-]A9k\u0006]DFAA:C\t\t)(\u0001\t.[i\u001cTFZ3biV\u0014X-L5eg\u0006\u0012\u0011\u0011P\u0001\u0002\u0002]KG\u000e\u001c\u0011p]2L\beY8na\u0006\u001cG\u000fI%EAI,7m\u001c:eg\u0002\"\b.\u0019;!G>\u0014(/Z:q_:$\u0007e^5uQ\u0002\"\b.\u001a\u0011uS6,\u0007\u0005]3sS>$G\u0006\t2bg\u0016$\u0007e\u001c8!M\u0016\fG/\u001e:fg\u0002\u0012W-\u001b8hA]\u0014\u0018\u000e\u001e;f]\u0002:\u0018\u000e\u001e5!i\",\u0007EW\u001aGK\u0006$XO]3JI\u001e+g.\u001a:bi>\u0014\bfB$\u0002~\u0005\r\u0015Q\u0011\t\u0004Q\u0006}\u0014bAAAS\nQ\u0001+\u0019:b[\u0016$XM]:\u0002%\r|W.\\1oI\u0012+7o\u0019:jaRLwN\\\u0011\u0003\u0003\u000f\u000bq'\u00138de\u0016lWM\u001c;bY2L\beY8na\u0006\u001cG\u000f\t;bE2,7\u000f\t4pe\u0002\n\u0007eR3p\u001b\u0016\u001c\u0018\r\t4fCR,(/\u001a\u0011usB,gABAF\u0007\u0002\tiIA\bSC:<WmQ8na\u0006\u001cG/[8o'\u0019\tI)a$\u0002\u0016B\u00191%!%\n\u0007\u0005MEE\u0001\u0004PE*,7\r\u001e\t\u0004G\u0005]\u0015bAAMI\tA!+\u001e8oC\ndW\rC\u0006\u0002\u001e\u0006%%\u0011!Q\u0001\n\u0005}\u0015aA8qgB!\u0011\u0011UA[\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016!B1e[&t'\u0002BAU\u0003W\u000baa\u00197jK:$(\u0002BAW\u0003_\u000bAaY8sK*\u0019q!!-\u000b\u0007\u0005MF\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003o\u000b\u0019KA\bUC\ndWm\u00149fe\u0006$\u0018n\u001c8t\u0011-\tY,!#\u0003\u0002\u0003\u0006I!!0\u0002\u000bQ\f'\r\\3\u0011\t\u0005}\u0016Q\u0019\b\u0004#\u0005\u0005\u0017bAAb%\u00051\u0001K]3eK\u001aL1!KAd\u0015\r\t\u0019M\u0005\u0005\f\u0003\u0017\fII!A!\u0002\u0013\ti-A\u0003ti\u0006\u0014H\u000f\u0005\u0003\u0002P\u0006eWBAAi\u0015\u0011\t\u0019.!6\u0002\u0005%|'\u0002BAl\u0003c\u000ba\u0001[1e_>\u0004\u0018\u0002BAn\u0003#\u0014A\u0001V3yi\"Y\u0011q\\AE\u0005\u0003\u0005\u000b\u0011BAg\u0003\r)g\u000e\u001a\u0005\b7\u0005%E\u0011AAr))\t)/a:\u0002j\u0006-\u0018Q\u001e\t\u0004+\u0006%\u0005\u0002CAO\u0003C\u0004\r!a(\t\u0011\u0005m\u0016\u0011\u001da\u0001\u0003{C\u0001\"a3\u0002b\u0002\u0007\u0011Q\u001a\u0005\t\u0003?\f\t\u000f1\u0001\u0002N\"A\u0011\u0011_AE\t\u0003\n\u00190A\u0002sk:$\u0012a\u0018\u0005\b\u0003o\u001cE\u0011BA}\u0003-\u0011xn\u001e+p'R\u0014\u0018N\\4\u0015\t\u0005u\u00161 \u0005\t\u0003{\f)\u00101\u0001\u0002N\u0006\u0019!o\\<\t\u000f\t\u0005\u0001\u0001)A\u0005_\u00059\u0001/\u0019:b[N\u0004\u0003b\u0002B\u0003\u0001\u0011\u0005\u00131_\u0001\bKb,7-\u001e;f\u0001")
public class AccumuloCompactCommand
implements AccumuloDataStoreCommand {
    private final String name;
    private final CompactParams params;

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand$class.connection(this);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    public String name() {
        return this.name;
    }

    @Override
    public CompactParams params() {
        return this.params;
    }

    public void execute() {
        this.withDataStore((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccumuloCompactCommand $outer;

            public final void apply(AccumuloDataStore ds) {
                SimpleFeatureType sft = ds.getSchema(this.$outer.params().featureName());
                if (sft == null) {
                    throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' does not exist in the data store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.params().featureName()})));
                }
                long start = System.currentTimeMillis();
                ExecutorService executor = Executors.newFixedThreadPool(Predef$.MODULE$.Integer2int(this.$outer.params().threads()));
                TableOperations ops = ds.connector().tableOperations();
                StringBuilder msg = new StringBuilder(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting incremental compaction using ", " simultaneous threads"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.params().threads()})));
                Option interval = Option$.MODULE$.apply((Object)this.$outer.params().from()).map((Function1)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$execute$1 $outer;
                    private final StringBuilder msg$1;

                    public final Tuple2<Object, Object> apply(Duration from) {
                        long now = System.currentTimeMillis();
                        long start = now - from.toMillis();
                        long end = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$$outer().params().duration()).map((Function1)new Serializable(this, start){
                            public static final long serialVersionUID = 0L;
                            private final long start$1;

                            public final long apply(Duration d) {
                                return this.start$1 + d.toMillis();
                            }
                            {
                                this.start$1 = start$1;
                            }
                        }).getOrElse((Function0)new Serializable(this, now){
                            public static final long serialVersionUID = 0L;
                            private final long now$1;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return this.now$1;
                            }
                            {
                                this.now$1 = now$1;
                            }
                        }));
                        this.msg$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" from ", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString$1(start), this.toString$1(end)})));
                        return new Tuple2.mcJJ.sp(start, end);
                    }

                    private final String toString$1(long millis) {
                        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.msg$1 = msg$1;
                    }
                });
                Option z3Bins = interval.map((Function1)new Serializable(this, sft){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$1;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            long s = tuple2._1$mcJ$sp();
                            long e = tuple2._2$mcJ$sp();
                            Function1 toBin = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1)));
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)((BinnedTime)toBin.apply((Object)BoxesRunTime.boxToLong((long)s))).bin()), (Object)BoxesRunTime.boxToShort((short)((BinnedTime)toBin.apply((Object)BoxesRunTime.boxToLong((long)e))).bin()));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.sft$1 = sft$1;
                    }
                });
                Option filter = interval.flatMap((Function1)new Serializable(this, sft){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$1;

                    public final Option<PropertyIsBetween> apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            long s = tuple2._1$mcJ$sp();
                            long e = tuple2._2$mcJ$sp();
                            Option option = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1)).map((Function1)new Serializable(this, s, e){
                                public static final long serialVersionUID = 0L;
                                private final long s$1;
                                private final long e$1;

                                public final PropertyIsBetween apply(String dtg) {
                                    return org.locationtech.geomesa.filter.package$.MODULE$.ff().between((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().property(dtg), (Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().literal((Object)new Date(this.s$1)), (Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().literal((Object)new Date(this.e$1)));
                                }
                                {
                                    this.s$1 = s$1;
                                    this.e$1 = e$1;
                                }
                            });
                            return option;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.sft$1 = sft$1;
                    }
                });
                Command$.MODULE$.user().info(msg.toString());
                ds.manager().indices(sft, ds.manager().indices$default$2()).foreach((Function1)new Serializable(this, sft, executor, ops, z3Bins, filter){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$execute$1 $outer;
                    public final SimpleFeatureType sft$1;
                    public final ExecutorService executor$1;
                    public final TableOperations ops$1;
                    private final Option z3Bins$1;
                    private final Option filter$1;

                    public final void apply(GeoMesaFeatureIndex<?, ?> index) {
                        Function1 filtering = this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$filterSplits$1(index, this.sft$1, this.z3Bins$1);
                        index.getTablesForQuery(this.filter$1).foreach((Function1)new Serializable(this, filtering){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$execute$1$$anonfun$apply$5 $outer;
                            private final Function1 filtering$1;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final void apply(String table) {
                                List tableSplits = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.ops$1.listSplits(table)).asScala()).toList();
                                IntRef count = IntRef.create((int)0);
                                if (tableSplits.isEmpty()) {
                                    this.$outer.executor$1.submit(new RangeCompaction(this.$outer.ops$1, table, null, null));
                                    ++count.elem;
                                } else {
                                    Iterator iterator;
                                    Iterator middle;
                                    Iterator head = package$.MODULE$.Iterator().single((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Text[]{null, (Text)tableSplits.head()})));
                                    Iterator last = package$.MODULE$.Iterator().single((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Text[]{(Text)tableSplits.last(), null})));
                                    Iterator iterator2 = middle = tableSplits.lengthCompare(1) == 0 ? package$.MODULE$.Iterator().empty() : tableSplits.sliding(2);
                                    if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.$outer.sft$1))) {
                                        byte prefix;
                                        byte by;
                                        byte[] byArray = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.$outer.sft$1));
                                        Option option = Array$.MODULE$.unapplySeq((Object)byArray);
                                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) throw new MatchError((Object)byArray);
                                        byte prefix2 = by = (prefix = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(0)));
                                        iterator = head.$plus$plus((Function0)new Serializable(this, middle){
                                            public static final long serialVersionUID = 0L;
                                            private final Iterator middle$1;

                                            public final Iterator<List<Text>> apply() {
                                                return this.middle$1;
                                            }
                                            {
                                                this.middle$1 = middle$1;
                                            }
                                        }).$plus$plus((Function0)new Serializable(this, last){
                                            public static final long serialVersionUID = 0L;
                                            private final Iterator last$1;

                                            public final Iterator<Seq<Text>> apply() {
                                                return this.last$1;
                                            }
                                            {
                                                this.last$1 = last$1;
                                            }
                                        }).filter((Function1)new Serializable(this, prefix2){
                                            public static final long serialVersionUID = 0L;
                                            private final byte prefix$1;

                                            public final boolean apply(Seq<Text> x0$6) {
                                                Seq<Text> seq = x0$6;
                                                Some some = Seq$.MODULE$.unapplySeq(seq);
                                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                                    Text s = (Text)((SeqLike)some.get()).apply(0);
                                                    Text e = (Text)((SeqLike)some.get()).apply(1);
                                                    boolean bl = !(s != null && UnsignedBytes.compare((byte)s.getBytes()[0], (byte)this.prefix$1) > 0 || e != null && UnsignedBytes.compare((byte)e.getBytes()[0], (byte)this.prefix$1) < 0);
                                                    return bl;
                                                }
                                                throw new MatchError(seq);
                                            }
                                            {
                                                this.prefix$1 = prefix$1;
                                            }
                                        });
                                    } else {
                                        iterator = head.$plus$plus((Function0)new Serializable(this, middle){
                                            public static final long serialVersionUID = 0L;
                                            private final Iterator middle$1;

                                            public final Iterator<List<Text>> apply() {
                                                return this.middle$1;
                                            }
                                            {
                                                this.middle$1 = middle$1;
                                            }
                                        }).$plus$plus((Function0)new Serializable(this, last){
                                            public static final long serialVersionUID = 0L;
                                            private final Iterator last$1;

                                            public final Iterator<Seq<Text>> apply() {
                                                return this.last$1;
                                            }
                                            {
                                                this.last$1 = last$1;
                                            }
                                        });
                                    }
                                    Iterator splits = iterator;
                                    ((Iterator)this.filtering$1.apply((Object)splits)).foreach((Function1)new Serializable(this, count, table){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$execute$1$$anonfun$apply$5$$anonfun$apply$6 $outer;
                                        private final IntRef count$1;
                                        private final String table$1;

                                        public final void apply(Seq<Text> x0$7) {
                                            Seq<Text> seq = x0$7;
                                            Some some = Seq$.MODULE$.unapplySeq(seq);
                                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                                Text s = (Text)((SeqLike)some.get()).apply(0);
                                                Text e = (Text)((SeqLike)some.get()).apply(1);
                                                this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$anonfun$$$outer().executor$1.submit(new RangeCompaction(this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$anonfun$$$outer().ops$1, this.table$1, s, e));
                                                ++this.count$1.elem;
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                return;
                                            }
                                            throw new MatchError(seq);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.count$1 = count$1;
                                            this.table$1 = table$1;
                                        }
                                    });
                                }
                                Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " splits for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count.elem), table})));
                            }

                            public /* synthetic */ $anonfun$execute$1$$anonfun$apply$5 org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.filtering$1 = filtering$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sft$1 = sft$1;
                        this.executor$1 = executor$1;
                        this.ops$1 = ops$1;
                        this.z3Bins$1 = z3Bins$1;
                        this.filter$1 = filter$1;
                    }
                });
                executor.shutdown();
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compactions complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start)})));
            }

            public /* synthetic */ AccumuloCompactCommand org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$$outer() {
                return this.$outer;
            }

            public final boolean org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareStart$1(Text s, short max$1, int offset$1) {
                return s == null || s.getLength() < offset$1 + 2 || ByteArrays$.MODULE$.readShort(s.getBytes(), offset$1) <= max$1;
            }

            public final boolean org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareEnd$1(Text e, short min$1, int offset$1) {
                return e == null || e.getLength() < offset$1 + 2 || ByteArrays$.MODULE$.readShort(e.getBytes(), offset$1) >= min$1;
            }

            public final boolean org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareStart$2(Text s, short max$2, int offset$2) {
                return s == null || s.getLength() < offset$2 + 3 || Z3UuidGenerator$.MODULE$.timeBin(s.getBytes(), offset$2) <= max$2;
            }

            public final boolean org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareEnd$2(Text e, short min$2, int offset$2) {
                return e == null || e.getLength() < offset$2 + 3 || Z3UuidGenerator$.MODULE$.timeBin(e.getBytes(), offset$2) >= min$2;
            }

            public final boolean org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareStart$3(Text s, short max$2, int offset$2) {
                boolean bl;
                if (s == null) {
                    bl = true;
                } else {
                    try {
                        String uuidString = new String(s.getBytes(), offset$2, s.getLength() - offset$2, StandardCharsets.UTF_8);
                        UUID uuid = UUID.fromString(uuidString);
                        bl = Z3UuidGenerator$.MODULE$.timeBin(ByteArrays$.MODULE$.toBytes(uuid.getMostSignificantBits()), Z3UuidGenerator$.MODULE$.timeBin$default$2()) <= max$2;
                    }
                    catch (Throwable throwable) {
                        boolean bl2;
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        bl = bl2 = true;
                    }
                }
                return bl;
            }

            public final boolean org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareEnd$3(Text e, short min$2, int offset$2) {
                boolean bl;
                if (e == null) {
                    bl = true;
                } else {
                    try {
                        String uuidString = new String(e.getBytes(), offset$2, e.getLength() - offset$2, StandardCharsets.UTF_8);
                        UUID uuid = UUID.fromString(uuidString);
                        bl = Z3UuidGenerator$.MODULE$.timeBin(ByteArrays$.MODULE$.toBytes(uuid.getMostSignificantBits()), Z3UuidGenerator$.MODULE$.timeBin$default$2()) >= min$2;
                    }
                    catch (Throwable throwable) {
                        boolean bl2;
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        bl = bl2 = true;
                    }
                }
                return bl;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Function1 org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$filterSplits$1(GeoMesaFeatureIndex index, SimpleFeatureType sft$1, Option z3Bins$1) {
                Tuple2 tuple2;
                void var11_15;
                boolean bl = false;
                Some some = null;
                Option option = z3Bins$1;
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    Tuple2 tuple22 = (Tuple2)some.x();
                    if (tuple22 != null) {
                        short min = BoxesRunTime.unboxToShort((Object)tuple22._1());
                        short max = BoxesRunTime.unboxToShort((Object)tuple22._2());
                        String string = index.name();
                        String string2 = Z3Index$.MODULE$.name();
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            int offset = index.keySpace().sharding().length() + index.keySpace().sharing().length;
                            Serializable serializable = new Serializable(this, min, max, offset){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$execute$1 $outer;
                                public final short min$1;
                                public final short max$1;
                                public final int offset$1;

                                public final Iterator<Seq<Text>> apply(Iterator<Seq<Text>> iter) {
                                    return iter.filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$execute$1$$anonfun$org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$filterSplits$1$1 $outer;

                                        public final boolean apply(Seq<Text> x0$3) {
                                            Seq<Text> seq = x0$3;
                                            Some some = Seq$.MODULE$.unapplySeq(seq);
                                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                                Text s = (Text)((SeqLike)some.get()).apply(0);
                                                Text e = (Text)((SeqLike)some.get()).apply(1);
                                                boolean bl = this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareStart$1(s, this.$outer.max$1, this.$outer.offset$1) && this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareEnd$1(e, this.$outer.min$1, this.$outer.offset$1);
                                                return bl;
                                            }
                                            throw new MatchError(seq);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ $anonfun$execute$1 org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.min$1 = min$1;
                                    this.max$1 = max$1;
                                    this.offset$1 = offset$1;
                                }
                            };
                            return var11_15;
                        }
                    }
                }
                if (bl && (tuple2 = (Tuple2)some.x()) != null) {
                    short min = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    short max = BoxesRunTime.unboxToShort((Object)tuple2._2());
                    if (this.$outer.params().z3Ids()) {
                        String string = index.name();
                        String string3 = IdIndex$.MODULE$.name();
                        if (!(string != null ? !string.equals(string3) : string3 != null)) {
                            int offset = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1)) ? 1 : 0;
                            Object object = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isUuidEncoded$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1)) ? new Serializable(this, min, max, offset){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$execute$1 $outer;
                                public final short min$2;
                                public final short max$2;
                                public final int offset$2;

                                public final Iterator<Seq<Text>> apply(Iterator<Seq<Text>> iter) {
                                    return iter.filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$execute$1$$anonfun$org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$filterSplits$1$2 $outer;

                                        public final boolean apply(Seq<Text> x0$4) {
                                            Seq<Text> seq = x0$4;
                                            Some some = Seq$.MODULE$.unapplySeq(seq);
                                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                                Text s = (Text)((SeqLike)some.get()).apply(0);
                                                Text e = (Text)((SeqLike)some.get()).apply(1);
                                                boolean bl = this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareStart$2(s, this.$outer.max$2, this.$outer.offset$2) && this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareEnd$2(e, this.$outer.min$2, this.$outer.offset$2);
                                                return bl;
                                            }
                                            throw new MatchError(seq);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ $anonfun$execute$1 org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.min$2 = min$2;
                                    this.max$2 = max$2;
                                    this.offset$2 = offset$2;
                                }
                            } : new Serializable(this, min, max, offset){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$execute$1 $outer;
                                public final short min$2;
                                public final short max$2;
                                public final int offset$2;

                                public final Iterator<Seq<Text>> apply(Iterator<Seq<Text>> iter) {
                                    return iter.filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$execute$1$$anonfun$org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$filterSplits$1$3 $outer;

                                        public final boolean apply(Seq<Text> x0$5) {
                                            Seq<Text> seq = x0$5;
                                            Some some = Seq$.MODULE$.unapplySeq(seq);
                                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                                Text s = (Text)((SeqLike)some.get()).apply(0);
                                                Text e = (Text)((SeqLike)some.get()).apply(1);
                                                boolean bl = this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareStart$3(s, this.$outer.max$2, this.$outer.offset$2) && this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$compareEnd$3(e, this.$outer.min$2, this.$outer.offset$2);
                                                return bl;
                                            }
                                            throw new MatchError(seq);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ $anonfun$execute$1 org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.min$2 = min$2;
                                    this.max$2 = max$2;
                                    this.offset$2 = offset$2;
                                }
                            };
                            return var11_15;
                        }
                    }
                }
                Serializable serializable = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<Seq<Text>> apply(Iterator<Seq<Text>> iter) {
                        return iter;
                    }
                };
                return var11_15;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public AccumuloCompactCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        AccumuloDataStoreCommand$class.$init$(this);
        this.name = "compact";
        this.params = new CompactParams();
    }

    @Parameters(commandDescription="Incrementally compact tables for a GeoMesa feature type")
    public static class CompactParams
    implements RequiredTypeNameParam,
    AccumuloDataStoreParams {
        @Parameter(names={"--threads"}, description="Number of ranges to compact simultaneously")
        private Integer threads;
        @Parameter(names={"--from"}, description="How long ago to compact data, based on the default date attribute, relative to current time. E.g. '1 day', '2 weeks and 1 hour', etc", converter=ParameterConverters.DurationConverter.class)
        private Duration from;
        @Parameter(names={"--duration"}, description="Amount of time to compact data, based on the default date attribute, relative to '--from'. E.g. '1 day', '2 weeks and 1 hour', etc", converter=ParameterConverters.DurationConverter.class)
        private Duration duration;
        @Parameter(names={"--z3-feature-ids"}, description="Will only compact ID records that correspond with the time period, based on features being written with the Z3FeatureIdGenerator")
        private boolean z3Ids;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--visibilities"}, description="Default feature visibilities")
        private String visibilities;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name", required=true)
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"--mock"}, description="Run everything with a mock accumulo instance instead of a real one")
        private boolean mock;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        @Override
        public String visibilities() {
            return this.visibilities;
        }

        @Override
        @TraitSetter
        public void visibilities_$eq(String x$1) {
            this.visibilities = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        @TraitSetter
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public boolean mock() {
            return this.mock;
        }

        @Override
        @TraitSetter
        public void mock_$eq(boolean x$1) {
            this.mock = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public Duration from() {
            return this.from;
        }

        public void from_$eq(Duration x$1) {
            this.from = x$1;
        }

        public Duration duration() {
            return this.duration;
        }

        public void duration_$eq(Duration x$1) {
            this.duration = x$1;
        }

        public boolean z3Ids() {
            return this.z3Ids;
        }

        public void z3Ids_$eq(boolean x$1) {
            this.z3Ids = x$1;
        }

        public CompactParams() {
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalZookeepersParam$class.$init$(this);
            InstanceNameParams$class.$init$(this);
            PasswordParams.class.$init$((PasswordParams)this);
            RequiredCredentialsParams.class.$init$((RequiredCredentialsParams)this);
            KerberosParams.class.$init$((KerberosParams)this);
            AccumuloConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
            this.threads = BoxesRunTime.boxToInteger((int)4);
            this.z3Ids = false;
        }
    }

    public static class RangeCompaction
    implements Runnable {
        private final TableOperations ops;
        private final String table;
        private final Text start;
        private final Text end;

        @Override
        public void run() {
            Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting compaction of ", " [ ", " :: ", " ]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table, AccumuloCompactCommand$.MODULE$.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$rowToString(this.start), AccumuloCompactCommand$.MODULE$.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$rowToString(this.end)})));
            this.ops.compact(this.table, this.start, this.end, false, true);
        }

        public RangeCompaction(TableOperations ops, String table, Text start, Text end) {
            this.ops = ops;
            this.table = table;
            this.start = start;
            this.end = end;
        }
    }
}

