/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$AccumuloDistributedCommand$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams$class;
import org.locationtech.geomesa.accumulo.tools.OptionalZookeepersParam$class;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.jobs.accumulo.AccumuloJobUtils$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaAccumuloInputFormat$;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.DistributedCommand;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InteractiveCommand;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredCredentialsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001=\u0011Q#Q2dk6,Hn\\#ya>\u0014HoQ8n[\u0006tGM\u0003\u0002\u0004\t\u00051Q\r\u001f9peRT!!\u0002\u0004\u0002\u000bQ|w\u000e\\:\u000b\u0005\u001dA\u0011\u0001C1dGVlW\u000f\\8\u000b\u0005%Q\u0011aB4f_6,7/\u0019\u0006\u0003\u00171\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A1\"\u0005\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0004/iaR\"\u0001\r\u000b\u0005\rI\"BA\u0003\t\u0013\tY\u0002DA\u0007FqB|'\u000f^\"p[6\fg\u000e\u001a\t\u0003;\u0001j\u0011A\b\u0006\u0003?\u0019\tA\u0001Z1uC&\u0011\u0011E\b\u0002\u0012\u0003\u000e\u001cW/\\;m_\u0012\u000bG/Y*u_J,\u0007CA\u00124\u001d\t!\u0013G\u0004\u0002&a9\u0011ae\f\b\u0003O9r!\u0001K\u0017\u000f\u0005%bS\"\u0001\u0016\u000b\u0005-r\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!A\r\u0003\u00021\u0005\u001b7-^7vY>$\u0015\r^1Ti>\u0014XmQ8n[\u0006tG-\u0003\u00025k\tQ\u0012iY2v[Vdw\u000eR5tiJL'-\u001e;fI\u000e{W.\\1oI*\u0011!\u0007\u0002\u0005\u0006o\u0001!\t\u0001O\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003\tAq\u0001\u0010\u0001C\u0002\u0013\u0005S(\u0001\u0004qCJ\fWn]\u000b\u0002}A\u0011q(\u0013\b\u0003\u0001\ns!\u0001J!\n\u0005\r!q!B\"\u0003\u0011\u0003!\u0015!F!dGVlW\u000f\\8FqB|'\u000f^\"p[6\fg\u000e\u001a\t\u0003u\u00153Q!\u0001\u0002\t\u0002\u0019\u001b\"!\u0012\t\t\u000b]*E\u0011\u0001%\u0015\u0003\u00113AAS#\u0001\u0017\n!\u0012iY2v[Vdw.\u0012=q_J$\b+\u0019:b[N\u001cb!\u0013\tM/n{\u0006CA'U\u001d\tq%K\u0004\u0002P#:\u0011a\u0005U\u0005\u0003\u000b!I!aA\r\n\u0005MC\u0012!D#ya>\u0014HoQ8n[\u0006tG-\u0003\u0002V-\naQ\t\u001f9peR\u0004\u0016M]1ng*\u00111\u000b\u0007\t\u00031fk\u0011\u0001B\u0005\u00035\u0012\u0011q#Q2dk6,Hn\u001c#bi\u0006\u001cFo\u001c:f!\u0006\u0014\u0018-\\:\u0011\u0005qkV\"A\r\n\u0005yK\"!\u0006*fcVL'/\u001a3UsB,g*Y7f!\u0006\u0014\u0018-\u001c\t\u00039\u0002L!!Y\r\u0003%=\u0003H/[8oC2Le\u000eZ3y!\u0006\u0014\u0018-\u001c\u0005\u0006o%#\ta\u0019\u000b\u0002IB\u0011Q-S\u0007\u0002\u000b\"\"\u0011jZ9s!\tAw.D\u0001j\u0015\tQ7.\u0001\u0006kG>lW.\u00198eKJT!\u0001\\7\u0002\u000b\t,Wo\u001d;\u000b\u00039\f1aY8n\u0013\t\u0001\u0018N\u0001\u0006QCJ\fW.\u001a;feN\f!cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\u0006\n1/A\u0015FqB|'\u000f\u001e\u0011gK\u0006$XO]3tA\u0019\u0014x.\u001c\u0011bA\u001d+w.T3tC\u0002\"\u0017\r^1!gR|'/\u001a\u0005\u0007k\u0002\u0001\u000b\u0011\u0002 \u0002\u000fA\f'/Y7tA!)q\u000f\u0001C)q\u0006I1m\u001c8gS\u001e,(/\u001a\u000b\u0007sr\f\t\"!\u0006\u0011\u0005EQ\u0018BA>\u0013\u0005\u0011)f.\u001b;\t\u000bu4\b\u0019\u0001@\u0002\u0007)|'\rE\u0002\u0000\u0003\u001bi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\n[\u0006\u0004(/\u001a3vG\u0016TA!a\u0002\u0002\n\u00051\u0001.\u00193p_BT1!a\u0003\r\u0003\u0019\t\u0007/Y2iK&!\u0011qBA\u0001\u0005\rQuN\u0019\u0005\u0007\u0003'1\b\u0019\u0001\u000f\u0002\u0005\u0011\u001c\bbBA\fm\u0002\u0007\u0011\u0011D\u0001\u0006cV,'/\u001f\t\u0005\u00037\t\u0019#\u0004\u0002\u0002\u001e)\u0019q$a\b\u000b\u0007\u0005\u0005B\"\u0001\u0005hK>$xn\u001c7t\u0013\u0011\t)#!\b\u0003\u000bE+XM]=")
public class AccumuloExportCommand
implements ExportCommand<AccumuloDataStore>,
AccumuloDataStoreCommand.AccumuloDistributedCommand {
    private final AccumuloExportParams params;
    private final String name;
    private final Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ Seq org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$AccumuloDistributedCommand$$super$libjarsFiles() {
        return ExportCommand.class.libjarsFiles((ExportCommand)this);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$AccumuloDistributedCommand$$super$libjarsPaths() {
        return DistributedCommand.class.libjarsPaths((DistributedCommand)this);
    }

    @Override
    public Seq<String> libjarsFiles() {
        return AccumuloDataStoreCommand$AccumuloDistributedCommand$class.libjarsFiles(this);
    }

    @Override
    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return AccumuloDataStoreCommand$AccumuloDistributedCommand$class.libjarsPaths(this);
    }

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return AccumuloDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds, Query query, FeatureExporter exporter) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds, (Query)query, (FeatureExporter)exporter);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        AccumuloExportCommand accumuloExportCommand = this;
        synchronized (accumuloExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return InteractiveCommand.class.console((InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        InteractiveCommand.class.setConsole((InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public AccumuloExportParams params() {
        return this.params;
    }

    public void configure(Job job, AccumuloDataStore ds, Query query) {
        GeoMesaAccumuloInputFormat$.MODULE$.configure(job, (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.connection()).asJava(), AccumuloJobUtils$.MODULE$.getSingleQueryPlan(ds, query));
    }

    public AccumuloExportCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        DistributedCommand.class.$init$((DistributedCommand)this);
        InteractiveCommand.class.$init$((InteractiveCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        AccumuloDataStoreCommand$class.$init$(this);
        AccumuloDataStoreCommand$AccumuloDistributedCommand$class.$init$(this);
        this.params = new AccumuloExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class AccumuloExportParams
    implements ExportCommand.ExportParams,
    AccumuloDataStoreParams,
    RequiredTypeNameParam,
    OptionalIndexParam {
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--visibilities"}, description="Default feature visibilities")
        private String visibilities;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name", required=true)
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"--mock"}, description="Run everything with a mock accumulo instance instead of a real one")
        private boolean mock;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed export)", validateWith=PositiveInteger.class)
        private Integer reducers;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private final ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private final Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        @Override
        public String visibilities() {
            return this.visibilities;
        }

        @Override
        @TraitSetter
        public void visibilities_$eq(String x$1) {
            this.visibilities = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        @TraitSetter
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public boolean mock() {
            return this.mock;
        }

        @Override
        @TraitSetter
        public void mock_$eq(boolean x$1) {
            this.mock = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            AccumuloExportParams accumuloExportParams = this;
            synchronized (accumuloExportParams) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.class.outputFormat((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.outputFormat;
            }
        }

        public ExportFormat outputFormat() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.outputFormat$lzycompute() : this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option mode$lzycompute() {
            AccumuloExportParams accumuloExportParams = this;
            synchronized (accumuloExportParams) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.class.mode((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.mode;
            }
        }

        public Option<Enumeration.Value> mode() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.mode$lzycompute() : this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public AccumuloExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            OptionalZookeepersParam$class.$init$(this);
            InstanceNameParams$class.$init$(this);
            PasswordParams.class.$init$((PasswordParams)this);
            RequiredCredentialsParams.class.$init$((RequiredCredentialsParams)this);
            KerberosParams.class.$init$((KerberosParams)this);
            AccumuloConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.class.$init$((OptionalIndexParam)this);
        }
    }
}

