/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.raster;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloRasterTableParam;
import org.locationtech.geomesa.accumulo.tools.AccumuloRasterTableParam$class;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams$class;
import org.locationtech.geomesa.accumulo.tools.OptionalZookeepersParam$class;
import org.locationtech.geomesa.accumulo.tools.raster.DeleteRasterCommand$;
import org.locationtech.geomesa.raster.data.AccumuloRasterStore;
import org.locationtech.geomesa.raster.data.AccumuloRasterStore$;
import org.locationtech.geomesa.tools.Command;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.RequiredCredentialsParams;
import scala.Function0;
import scala.Option$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001=\u00111\u0003R3mKR,'+Y:uKJ\u001cu.\\7b]\u0012T!a\u0001\u0003\u0002\rI\f7\u000f^3s\u0015\t)a!A\u0003u_>d7O\u0003\u0002\b\u0011\u0005A\u0011mY2v[VdwN\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011-m\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u001a\u001b\u0005A\"BA\u0003\t\u0013\tQ\u0002DA\u0004D_6l\u0017M\u001c3\u0011\u0005q\u0019S\"A\u000f\u000b\u0005yy\u0012\u0001D:dC2\fGn\\4hS:<'B\u0001\u0011\"\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0012\u0002\u0007\r|W.\u0003\u0002%;\tYA*\u0019>z\u0019><w-\u001b8h\u0011\u00151\u0003\u0001\"\u0001(\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002*\u00015\t!\u0001C\u0004,\u0001\t\u0007I\u0011\t\u0017\u0002\t9\fW.Z\u000b\u0002[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005Y\u0006twMC\u00013\u0003\u0011Q\u0017M^1\n\u0005Qz#AB*ue&tw\r\u0003\u00047\u0001\u0001\u0006I!L\u0001\u0006]\u0006lW\r\t\u0005\bq\u0001\u0011\r\u0011\"\u0011:\u0003\u0019\u0001\u0018M]1ngV\t!\b\u0005\u0002<A:\u0011Ah\u0013\b\u0003{)s!AP%\u000f\u0005}BeB\u0001!H\u001d\t\teI\u0004\u0002C\u000b6\t1I\u0003\u0002E\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019AaB\u0003M\u0005!\u0005Q*A\nEK2,G/\u001a*bgR,'oQ8n[\u0006tG\r\u0005\u0002*\u001d\u001a)\u0011A\u0001E\u0001\u001fN\u0011a\n\u0005\u0005\u0006M9#\t!\u0015\u000b\u0002\u001b\")1K\u0014C\u0001)\u0006i\u0001O]8naR\u001cuN\u001c4je6$\"!\u0016-\u0011\u0005E1\u0016BA,\u0013\u0005\u001d\u0011un\u001c7fC:DQ!\u0017*A\u0002i\u000bQa\u001d;pe\u0016\u0004\"a\u00170\u000f\u0005Ea\u0016BA/\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011Ag\u0018\u0006\u0003;J1A!\u0019(\u0001E\n\u0011B)\u001a7fi\u0016\u0014\u0016m\u001d;feB\u000b'/Y7t'\u0015\u0001\u0007cY4k!\t!W-D\u0001\u0005\u0013\t1GA\u0001\rBG\u000e,X.\u001e7p\u0007>tg.Z2uS>t\u0007+\u0019:b[N\u0004\"\u0001\u001a5\n\u0005%$!\u0001G!dGVlW\u000f\\8SCN$XM\u001d+bE2,\u0007+\u0019:b[B\u0011qc[\u0005\u0003Yb\u0011!c\u00149uS>t\u0017\r\u001c$pe\u000e,\u0007+\u0019:b[\")a\u0005\u0019C\u0001]R\tq\u000e\u0005\u0002qA6\ta\n\u000b\u0003aej\\\bCA:y\u001b\u0005!(BA;w\u0003)Q7m\\7nC:$WM\u001d\u0006\u0003o\u0006\nQAY3vgRL!!\u001f;\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0017%\u0001?\u0002;\u0011+G.\u001a;fA\u0005\u0004s)Z8NKN\f\u0007EU1ti\u0016\u0014\b\u0005^1cY\u0016DaA \u0001!\u0002\u0013Q\u0014a\u00029be\u0006l7\u000f\t\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0003\u001d)\u00070Z2vi\u0016$\"!!\u0002\u0011\u0007E\t9!C\u0002\u0002\nI\u0011A!\u00168ji\u0002")
public class DeleteRasterCommand
implements Command,
LazyLogging {
    private final String name;
    private final DeleteRasterParams params;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static boolean promptConfirm(String string) {
        return DeleteRasterCommand$.MODULE$.promptConfirm(string);
    }

    private Logger logger$lzycompute() {
        DeleteRasterCommand deleteRasterCommand = this;
        synchronized (deleteRasterCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String name() {
        return this.name;
    }

    public DeleteRasterParams params() {
        return this.params;
    }

    public void execute() {
        BoxedUnit boxedUnit;
        ObjectRef RasterStore$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String user = this.params().user();
        String pass = this.params().password();
        String table = this.params().table();
        String instance = this.params().instance();
        String zookeepers = this.params().zookeepers();
        String authsParam = (String)Option$.MODULE$.apply((Object)this.params().auths()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String visibilities = (String)Option$.MODULE$.apply((Object)this.params().visibilities()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        boolean useMock = this.params().mock();
        if (this.params().force() || DeleteRasterCommand$.MODULE$.promptConfirm(table)) {
            this.RasterStore$1(user, pass, table, instance, zookeepers, authsParam, visibilities, useMock, RasterStore$lzy, bitmap$0).deleteRasterTable();
            boxedUnit = BoxedUnit.UNIT;
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Cancelled deletion of GeoMesa Raster Table: '{}'", new Object[]{table});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.RasterStore$1(user, pass, table, instance, zookeepers, authsParam, visibilities, useMock, RasterStore$lzy, bitmap$0).close();
    }

    private final AccumuloRasterStore RasterStore$lzycompute$1(String user$1, String pass$1, String table$1, String instance$1, String zookeepers$1, String authsParam$1, String visibilities$1, boolean useMock$1, ObjectRef RasterStore$lzy$1, VolatileByteRef bitmap$0$1) {
        DeleteRasterCommand deleteRasterCommand = this;
        synchronized (deleteRasterCommand) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                RasterStore$lzy$1.elem = AccumuloRasterStore$.MODULE$.apply(user$1, pass$1, instance$1, zookeepers$1, table$1, authsParam$1, visibilities$1, useMock$1, AccumuloRasterStore$.MODULE$.apply$default$9(), AccumuloRasterStore$.MODULE$.apply$default$10(), AccumuloRasterStore$.MODULE$.apply$default$11(), AccumuloRasterStore$.MODULE$.apply$default$12());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (AccumuloRasterStore)RasterStore$lzy$1.elem;
        }
    }

    private final AccumuloRasterStore RasterStore$1(String user$1, String pass$1, String table$1, String instance$1, String zookeepers$1, String authsParam$1, String visibilities$1, boolean useMock$1, ObjectRef RasterStore$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.RasterStore$lzycompute$1(user$1, pass$1, table$1, instance$1, zookeepers$1, authsParam$1, visibilities$1, useMock$1, RasterStore$lzy$1, bitmap$0$1) : (AccumuloRasterStore)RasterStore$lzy$1.elem;
    }

    public DeleteRasterCommand() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.name = "delete-raster";
        this.params = new DeleteRasterParams();
    }

    @Parameters(commandDescription="Delete a GeoMesa Raster table")
    public static class DeleteRasterParams
    implements AccumuloConnectionParams,
    AccumuloRasterTableParam,
    OptionalForceParam {
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"-t", "--raster-table"}, description="Accumulo table for storing raster data", required=true)
        private String table;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--visibilities"}, description="Default feature visibilities")
        private String visibilities;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name", required=true)
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"--mock"}, description="Run everything with a mock accumulo instance instead of a real one")
        private boolean mock;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        @Override
        public String table() {
            return this.table;
        }

        @Override
        @TraitSetter
        public void table_$eq(String x$1) {
            this.table = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        @Override
        public String visibilities() {
            return this.visibilities;
        }

        @Override
        @TraitSetter
        public void visibilities_$eq(String x$1) {
            this.visibilities = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        @TraitSetter
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public boolean mock() {
            return this.mock;
        }

        @Override
        @TraitSetter
        public void mock_$eq(boolean x$1) {
            this.mock = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public DeleteRasterParams() {
            OptionalZookeepersParam$class.$init$(this);
            InstanceNameParams$class.$init$(this);
            PasswordParams.class.$init$((PasswordParams)this);
            RequiredCredentialsParams.class.$init$((RequiredCredentialsParams)this);
            KerberosParams.class.$init$((KerberosParams)this);
            AccumuloConnectionParams$class.$init$(this);
            AccumuloRasterTableParam$class.$init$(this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
        }
    }
}

