/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.geometry.Envelope2D;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.accumulo.tools.raster.IngestRasterCommand$;
import org.locationtech.geomesa.accumulo.tools.raster.LocalRasterIngest$;
import org.locationtech.geomesa.accumulo.tools.raster.RasterIngest;
import org.locationtech.geomesa.accumulo.tools.raster.RasterIngest$class;
import org.locationtech.geomesa.raster.data.AccumuloRasterStore;
import org.locationtech.geomesa.raster.data.Raster;
import org.locationtech.geomesa.raster.data.Raster$;
import org.locationtech.geomesa.raster.data.RenderedImageRaster;
import org.locationtech.geomesa.raster.index.RasterEntryDecoder;
import org.locationtech.geomesa.raster.util.RasterUtils;
import org.locationtech.geomesa.utils.geohash.BoundingBox;
import org.locationtech.geomesa.utils.geohash.BoundingBox$;
import org.opengis.geometry.Envelope;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.mutable.ParArray;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u001f\t\tBj\\2bYJ\u000b7\u000f^3s\u0013:<Wm\u001d;\u000b\u0005\r!\u0011A\u0002:bgR,'O\u0003\u0002\u0006\r\u0005)Ao\\8mg*\u0011q\u0001C\u0001\tC\u000e\u001cW/\\;m_*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!\u0001\u0004*bgR,'/\u00138hKN$\b\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\r\r|gNZ5h!\u0011i\u0002e\t\u0014\u000f\u0005Eq\u0012BA\u0010\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011E\t\u0002\u0004\u001b\u0006\u0004(BA\u0010\u0013!\tiB%\u0003\u0002&E\t11\u000b\u001e:j]\u001e\u00042!E\u0014$\u0013\tA#C\u0001\u0004PaRLwN\u001c\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051j\u0003CA\f\u0001\u0011\u0015Y\u0012\u00061\u0001\u001d\u0011!y\u0003\u0001#b\u0001\n\u0003\u0001\u0014\u0001\u00029bi\",\u0012a\t\u0005\te\u0001A\t\u0011)Q\u0005G\u0005)\u0001/\u0019;iA!AA\u0007\u0001EC\u0002\u0013\u0005\u0001'\u0001\u0005gS2,G+\u001f9f\u0011!1\u0004\u0001#A!B\u0013\u0019\u0013!\u00034jY\u0016$\u0016\u0010]3!\u0011!A\u0004\u0001#b\u0001\n\u0003\u0001\u0014A\u0003:bgR,'OT1nK\"A!\b\u0001E\u0001B\u0003&1%A\u0006sCN$XM\u001d(b[\u0016\u0004\u0003\u0002\u0003\u001f\u0001\u0011\u000b\u0007I\u0011A\u001f\u0002\u0011A\f'\u000fT3wK2,\u0012A\u0010\t\u0003#}J!\u0001\u0011\n\u0003\u0007%sG\u000f\u0003\u0005C\u0001!\u0005\t\u0015)\u0003?\u0003%\u0001\u0018M\u001d'fm\u0016d\u0007\u0005\u0003\u0005E\u0001!\u0015\r\u0011\"\u0001F\u0003\t\u00118/F\u0001G!\t95*D\u0001I\u0015\tI%*\u0001\u0003eCR\f'BA\u0002\t\u0013\ta\u0005JA\nBG\u000e,X.\u001e7p%\u0006\u001cH/\u001a:Ti>\u0014X\r\u0003\u0005O\u0001!\u0005\t\u0015)\u0003G\u0003\r\u00118\u000f\t\u0005\b!\u0002\u0011\r\u0011\"\u0001R\u0003\t!g-F\u0001S!\t\u0019&,D\u0001U\u0015\t)f+\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003/b\u000bA\u0001^5nK*\t\u0011,\u0001\u0003kCZ\f\u0017BA.U\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM\u001d\u0005\u0007;\u0002\u0001\u000b\u0011\u0002*\u0002\u0007\u00114\u0007\u0005C\u0003`\u0001\u0011\u0005\u0001-A\u0007sk:LenZ3tiR\u000b7o\u001b\u000b\u0002CB\u0019!-Z4\u000e\u0003\rT!\u0001\u001a\n\u0002\tU$\u0018\u000e\\\u0005\u0003M\u000e\u00141\u0001\u0016:z!\t\t\u0002.\u0003\u0002j%\t!QK\\5u\u0011\u0015Y\u0007\u0001\"\u0001m\u0003QIgnZ3tiJ\u000b7\u000f^3s\rJ|WNR5mKR\u0011q-\u001c\u0005\u0006]*\u0004\ra\\\u0001\u0005M&dW\r\u0005\u0002qg6\t\u0011O\u0003\u0002s1\u0006\u0011\u0011n\\\u0005\u0003iF\u0014AAR5mK\u0002")
public class LocalRasterIngest
implements RasterIngest {
    private final scala.collection.immutable.Map<String, Option<String>> config;
    private String path;
    private String fileType;
    private String rasterName;
    private int parLevel;
    private AccumuloRasterStore rs;
    private final DateTimeFormatter df;
    private final Hints defaultHints;
    private final Logger logger;
    private volatile byte bitmap$0;

    private String path$lzycompute() {
        LocalRasterIngest localRasterIngest = this;
        synchronized (localRasterIngest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.path = (String)((Option)this.config.apply((Object)RasterUtils.IngestRasterParams$.MODULE$.FILE_PATH())).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.path;
        }
    }

    private String fileType$lzycompute() {
        LocalRasterIngest localRasterIngest = this;
        synchronized (localRasterIngest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.fileType = (String)((Option)this.config.apply((Object)RasterUtils.IngestRasterParams$.MODULE$.FORMAT())).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.fileType;
        }
    }

    private String rasterName$lzycompute() {
        LocalRasterIngest localRasterIngest = this;
        synchronized (localRasterIngest) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.rasterName = (String)((Option)this.config.apply((Object)RasterUtils.IngestRasterParams$.MODULE$.TABLE())).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.rasterName;
        }
    }

    private int parLevel$lzycompute() {
        LocalRasterIngest localRasterIngest = this;
        synchronized (localRasterIngest) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.parLevel = new StringOps(Predef$.MODULE$.augmentString((String)((Option)this.config.apply((Object)RasterUtils.IngestRasterParams$.MODULE$.PARLEVEL())).get())).toInt();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.parLevel;
        }
    }

    private AccumuloRasterStore rs$lzycompute() {
        LocalRasterIngest localRasterIngest = this;
        synchronized (localRasterIngest) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.rs = this.createRasterStore(this.config);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.rs;
        }
    }

    @Override
    public Hints defaultHints() {
        return this.defaultHints;
    }

    @Override
    public void org$locationtech$geomesa$accumulo$tools$raster$RasterIngest$_setter_$defaultHints_$eq(Hints x$1) {
        this.defaultHints = x$1;
    }

    @Override
    public Map<String, Serializable> getAccumuloRasterStoreConf(scala.collection.immutable.Map<String, Option<String>> config) {
        return RasterIngest$class.getAccumuloRasterStoreConf(this, config);
    }

    @Override
    public AccumuloRasterStore createRasterStore(scala.collection.immutable.Map<String, Option<String>> config) {
        return RasterIngest$class.createRasterStore(this, config);
    }

    @Override
    public AbstractGridCoverage2DReader getReader(File imageFile, String imageType) {
        return RasterIngest$class.getReader(this, imageFile, imageType);
    }

    private Logger logger$lzycompute() {
        LocalRasterIngest localRasterIngest = this;
        synchronized (localRasterIngest) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String path() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.path$lzycompute() : this.path;
    }

    public String fileType() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.fileType$lzycompute() : this.fileType;
    }

    public String rasterName() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.rasterName$lzycompute() : this.rasterName;
    }

    public int parLevel() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.parLevel$lzycompute() : this.parLevel;
    }

    public AccumuloRasterStore rs() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.rs$lzycompute() : this.rs;
    }

    public DateTimeFormatter df() {
        return this.df;
    }

    public Try<BoxedUnit> runIngestTask() {
        return Try$.MODULE$.apply((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalRasterIngest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File fileOrDir = new File(this.$outer.path());
                ParArray files = Predef$.MODULE$.refArrayOps(fileOrDir.isDirectory() ? (Object[])fileOrDir.listFiles(new FilenameFilter(this){
                    private final /* synthetic */ $anonfun$runIngestTask$1 $outer;

                    public boolean accept(File dir, String name) {
                        return IngestRasterCommand$.MODULE$.getFileExtension(name).endsWith(this.$outer.org$locationtech$geomesa$accumulo$tools$raster$LocalRasterIngest$$anonfun$$$outer().fileType());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }) : (Object[])new File[]{fileOrDir}).par();
                files.tasksupport_$eq((TaskSupport)new ForkJoinTaskSupport(new ForkJoinPool(this.$outer.parLevel())));
                files.foreach((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$runIngestTask$1 $outer;

                    public final void apply(File file) {
                        this.$outer.org$locationtech$geomesa$accumulo$tools$raster$LocalRasterIngest$$anonfun$$$outer().ingestRasterFromFile(file);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.rs().close();
            }

            public /* synthetic */ LocalRasterIngest org$locationtech$geomesa$accumulo$tools$raster$LocalRasterIngest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void ingestRasterFromFile(File file) {
        void var4_4;
        String projection;
        AbstractGridCoverage2DReader rasterReader = this.getReader(file, this.fileType());
        GridCoverage2D rasterGrid = rasterReader.read(null);
        String string = projection = rasterGrid.getCoordinateReferenceSystem().getName().toString();
        String string2 = "EPSG:WGS 84";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Envelope2D envelope = rasterGrid.getEnvelope2D();
            BoundingBox bbox = BoundingBox$.MODULE$.apply(envelope.getMinX(), envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY());
            ZonedDateTime ingestTime = (ZonedDateTime)((Option)this.config.apply((Object)RasterUtils.IngestRasterParams$.MODULE$.TIME())).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LocalRasterIngest $outer;

                public final ZonedDateTime apply(String x$1) {
                    return ZonedDateTime.parse(x$1, this.$outer.df());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).getOrElse((Function0)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ZonedDateTime apply() {
                    return ZonedDateTime.now(ZoneOffset.UTC);
                }
            });
            RasterEntryDecoder.DecodedIndexValue metadata = new RasterEntryDecoder.DecodedIndexValue(Raster$.MODULE$.getRasterId(this.rasterName()), bbox.geom(), (Option)new Some((Object)Date.from(ingestTime.toInstant())), null);
            double res = new RasterUtils.sharedRasterParams(rasterGrid.getGridGeometry(), (Envelope)envelope).suggestedQueryResolution();
            RenderedImageRaster raster = Raster$.MODULE$.apply(rasterGrid.getRenderedImage(), metadata, res);
            this.rs().putRaster((Raster)raster);
            return;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error, Projection: ", " is unsupported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4})));
    }

    public LocalRasterIngest(scala.collection.immutable.Map<String, Option<String>> config) {
        this.config = config;
        LazyLogging.class.$init$((LazyLogging)this);
        RasterIngest$class.$init$(this);
        this.df = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }
}

