/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.data;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.iterators.AgeOffIterator$;
import org.locationtech.geomesa.accumulo.iterators.DtgAgeOffIterator$;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams$class;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam$class;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.OptionalDtgParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.conf.FeatureExpiration;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u0001=\u0011Q#Q2dk6,Hn\\!hK>3gmQ8n[\u0006tGM\u0003\u0002\u0004\t\u0005!A-\u0019;b\u0015\t)a!A\u0003u_>d7O\u0003\u0002\b\u0011\u0005A\u0011mY2v[VdwN\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\u0011I!!\u0007\u0003\u00031\u0005\u001b7-^7vY>$\u0015\r^1Ti>\u0014XmQ8n[\u0006tG\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0003\n\u0013\u0001\u00028b[\u0016,\u0012A\t\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nA\u0001\\1oO*\tq%\u0001\u0003kCZ\f\u0017BA\u0015%\u0005\u0019\u0019FO]5oO\"11\u0006\u0001Q\u0001\n\t\nQA\\1nK\u0002Bq!\f\u0001C\u0002\u0013\u0005c&\u0001\u0004qCJ\fWn]\u000b\u0002_A\u0011\u0001g\u0012\b\u0003c\u0001s!AM \u000f\u0005MrdB\u0001\u001b>\u001d\t)DH\u0004\u00027w9\u0011qGO\u0007\u0002q)\u0011\u0011HD\u0001\u0007yI|w\u000e\u001e \n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t\u001d)\u0011I\u0001E\u0001\u0005\u0006)\u0012iY2v[Vdw.Q4f\u001f\u001a47i\\7nC:$\u0007C\u0001\u0010D\r\u0015\t!\u0001#\u0001E'\t\u0019\u0005\u0003C\u0003\u001c\u0007\u0012\u0005a\tF\u0001C\r\u0011A5\tA%\u0003)\u0005\u001b7-^7vY>\fu-Z(gMB\u000b'/Y7t'\u00159\u0005CS'S!\t92*\u0003\u0002M\t\t9\u0012iY2v[Vdw\u000eR1uCN#xN]3QCJ\fWn\u001d\t\u0003\u001dBk\u0011a\u0014\u0006\u0003\u000b!I!!U(\u0003+I+\u0017/^5sK\u0012$\u0016\u0010]3OC6,\u0007+\u0019:b[B\u0011ajU\u0005\u0003)>\u0013\u0001c\u00149uS>t\u0017\r\u001c#uOB\u000b'/Y7\t\u000bm9E\u0011\u0001,\u0015\u0003]\u0003\"\u0001W$\u000e\u0003\rC\u0011BW$A\u0002\u0003\u0007I\u0011A.\u0002\r\u0015D\b/\u001b:z+\u0005a\u0006CA/c\u001b\u0005q&BA0a\u0003!!WO]1uS>t'BA1\u0013\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003Gz\u0013\u0001\u0002R;sCRLwN\u001c\u0005\nK\u001e\u0003\r\u00111A\u0005\u0002\u0019\f!\"\u001a=qSJLx\fJ3r)\t9'\u000e\u0005\u0002\u0012Q&\u0011\u0011N\u0005\u0002\u0005+:LG\u000fC\u0004lI\u0006\u0005\t\u0019\u0001/\u0002\u0007a$\u0013\u0007\u0003\u0004n\u000f\u0002\u0006K\u0001X\u0001\bKb\u0004\u0018N]=!Q-aw.\u001f>\u0000\u0003\u0003\t)!a\u0002\u0011\u0005A<X\"A9\u000b\u0005I\u001c\u0018A\u00036d_6l\u0017M\u001c3fe*\u0011A/^\u0001\u0006E\u0016,8\u000f\u001e\u0006\u0002m\u0006\u00191m\\7\n\u0005a\f(!\u0003)be\u0006lW\r^3s\u0003\u0015q\u0017-\\3tY\tYX0I\u0001}\u0003\tiS-I\u0001\u007f\u0003!iS&\u001a=qSJL\u0018a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f#!a\u0001\u0002\u001b\u0012+(/\u0019;j_:\u0004#-\u001a4pe\u0016\u0004SM\u001c;sS\u0016\u001c\b%\u0019:fA\u0005<W\rZ\u0017pM\u001ad\u0003%\u001a\u0018h]\u0001:\u0013\u0007\t3bs\u001eb\u0003e\n\u001a!o\u0016,7n\u001d\u0011b]\u0012\u0004\u0013\u0007\t5pkJ<C\u0006I3uG\u0006I1m\u001c8wKJ$XM]\u0012\u0003\u0003\u0013\u0001B!a\u0003\u0002\u001e9!\u0011QBA\f\u001d\u0011\ty!a\u0005\u000f\u0007Q\n\t\"\u0003\u0002\u0006\u0011%\u0019\u0011QC(\u0002\u000bU$\u0018\u000e\\:\n\t\u0005e\u00111D\u0001\u0014!\u0006\u0014\u0018-\\3uKJ\u001cuN\u001c<feR,'o\u001d\u0006\u0004\u0003+y\u0015\u0002BA\u0010\u0003C\u0011\u0011\u0003R;sCRLwN\\\"p]Z,'\u000f^3s\u0015\u0011\tI\"a\u0007\t\u0017\u0005\u0015r\t1AA\u0002\u0013\u0005\u0011qE\u0001\u0005Y&\u001cH/\u0006\u0002\u0002*A\u0019\u0011#a\u000b\n\u0007\u00055\"CA\u0004C_>dW-\u00198\t\u0017\u0005Er\t1AA\u0002\u0013\u0005\u00111G\u0001\tY&\u001cHo\u0018\u0013fcR\u0019q-!\u000e\t\u0013-\fy#!AA\u0002\u0005%\u0002\u0002CA\u001d\u000f\u0002\u0006K!!\u000b\u0002\u000b1L7\u000f\u001e\u0011)\u0013\u0005]r._A\u001f\u007f\u0006\u001dC\u0006BA \u0003\u0007\n#!!\u0011\u0002\u00055b\u0017EAA#\u0003\u0019iS\u0006\\5ti\u0006\u0012\u0011\u0011J\u00010\u0019&\u001cH\u000fI3ySN$\u0018N\\4!C\u001e,Wf\u001c4gA\u0019|'\u000fI1!g&l\u0007\u000f\\3!M\u0016\fG/\u001e:fAQL\b/\u001a\u0005\f\u0003\u001b:\u0005\u0019!a\u0001\n\u0003\t9#A\u0002tKRD1\"!\u0015H\u0001\u0004\u0005\r\u0011\"\u0001\u0002T\u000591/\u001a;`I\u0015\fHcA4\u0002V!I1.a\u0014\u0002\u0002\u0003\u0007\u0011\u0011\u0006\u0005\t\u00033:\u0005\u0015)\u0003\u0002*\u0005!1/\u001a;!Q%\t9f\\=\u0002^}\f9\u0007\f\u0003\u0002`\u0005\r\u0014EAA1\u0003\ti3/\t\u0002\u0002f\u0005)Q&L:fi\u0006\u0012\u0011\u0011N\u0001&'\u0016$\b%Y4f[=4g\r\t4pe\u0002\n\u0007e]5na2,\u0007EZ3biV\u0014X\r\t;za\u0016D1\"!\u001cH\u0001\u0004\u0005\r\u0011\"\u0001\u0002(\u00051!/Z7pm\u0016D1\"!\u001dH\u0001\u0004\u0005\r\u0011\"\u0001\u0002t\u0005Q!/Z7pm\u0016|F%Z9\u0015\u0007\u001d\f)\bC\u0005l\u0003_\n\t\u00111\u0001\u0002*!A\u0011\u0011P$!B\u0013\tI#A\u0004sK6|g/\u001a\u0011)\u0013\u0005]t._A?\u007f\u0006\u001dE\u0006BA@\u0003\u0007\u000b#!!!\u0002\u00055\u0012\u0018EAAC\u0003!iSF]3n_Z,\u0017EAAE\u0003E\u0012V-\\8wK\u0002*\u00070[:uS:<\u0007%Y4f[=4g\r\t4pe\u0002\n\u0007e]5na2,\u0007EZ3biV\u0014X\r\t;za\u0016DsaRAG\u0003'\u000b)\nE\u0002q\u0003\u001fK1!!%r\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0013G>lW.\u00198e\t\u0016\u001c8M]5qi&|g.\t\u0002\u0002\u0018\u0006\u0011D*[:u_M,Go\f:f[>4X\rI1hK6zgM\u001a\u0011g_J\u0004\u0013\rI$f_6+7/\u0019\u0011gK\u0006$XO]3!if\u0004X\rC\u0004\u0002\u001c\u0002\u0001\u000b\u0011B\u0018\u0002\u000fA\f'/Y7tA!9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0016aB3yK\u000e,H/\u001a\u000b\u0002O\"9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0016\u0001B3yK\u000e$2aZAU\u0011!\tY+a)A\u0002\u00055\u0016A\u00013t!\u0011\ty+a-\u000e\u0005\u0005E&BA\u0002\u0007\u0013\u0011\t),!-\u0003#\u0005\u001b7-^7vY>$\u0015\r^1Ti>\u0014X\r")
public class AccumuloAgeOffCommand
implements AccumuloDataStoreCommand {
    private final String name;
    private final AccumuloAgeOffParams params;

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand$class.connection(this);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    public String name() {
        return this.name;
    }

    @Override
    public AccumuloAgeOffParams params() {
        return this.params;
    }

    public void execute() {
        if (((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{this.params().set(), this.params().remove(), this.params().list()}))).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x$1) {
                return x$1;
            }
        }) != 1) {
            throw new ParameterException("Must specify exactly one of 'list', 'set' or 'remove'");
        }
        if (this.params().set() && this.params().expiry() == null) {
            throw new ParameterException("Must specify 'expiry' when setting age-off");
        }
        this.withDataStore((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccumuloAgeOffCommand $outer;

            public final void apply(AccumuloDataStore ds) {
                this.$outer.org$locationtech$geomesa$accumulo$tools$data$AccumuloAgeOffCommand$$exec(ds);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void org$locationtech$geomesa$accumulo$tools$data$AccumuloAgeOffCommand$$exec(AccumuloDataStore ds) {
        ObjectRef mutable$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        SimpleFeatureType sft = ds.getSchema(this.params().featureName());
        if (sft == null) {
            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SimpleFeatureType '", "' does not exist in the data store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().featureName()})));
        }
        if (this.params().list()) {
            Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute age-off: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DtgAgeOffIterator$.MODULE$.list(ds, sft).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "None";
                }
            })})));
            Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamp age-off: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AgeOffIterator$.MODULE$.list(ds, sft).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "None";
                }
            })})));
        } else if (this.params().set() && this.params().dtgField() == null) {
            Object x$4;
            List x$3;
            String x$2 = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configuring ingest-time-based age-off for schema '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().featureName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with expiry ", ". Continue (y/n)? "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().expiry()}))).toString();
            if (Prompt$.MODULE$.confirm(x$2, x$3 = Prompt$.MODULE$.confirm$default$2(), x$4 = Prompt$.MODULE$.confirm$default$3(x$2, x$3))) {
                RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setFeatureExpiration$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.mutable$1(sft, mutable$lzy, bitmap$0)), (FeatureExpiration)new FeatureExpiration.IngestTimeExpiration(this.params().expiry()));
                ds.updateSchema(sft.getTypeName(), this.mutable$1(sft, mutable$lzy, bitmap$0));
            }
        } else if (this.params().set()) {
            Object x$7;
            List x$6;
            String x$5 = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configuring attribute-based age-off for schema '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().featureName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on field '", "' with expiry ", ". Continue (y/n)? "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().dtgField(), this.params().expiry()}))).toString();
            if (Prompt$.MODULE$.confirm(x$5, x$6 = Prompt$.MODULE$.confirm$default$2(), x$7 = Prompt$.MODULE$.confirm$default$3(x$5, x$6))) {
                FeatureExpiration.FeatureTimeExpiration expiry = new FeatureExpiration.FeatureTimeExpiration(this.params().dtgField(), sft.indexOf(this.params().dtgField()), this.params().expiry());
                RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setFeatureExpiration$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.mutable$1(sft, mutable$lzy, bitmap$0)), (FeatureExpiration)expiry);
                ds.updateSchema(sft.getTypeName(), this.mutable$1(sft, mutable$lzy, bitmap$0));
            }
        } else {
            Object x$10;
            List x$9;
            String x$8 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing age-off for schema '", "'. Continue (y/n)? "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().featureName()}));
            if (Prompt$.MODULE$.confirm(x$8, x$9 = Prompt$.MODULE$.confirm$default$2(), x$10 = Prompt$.MODULE$.confirm$default$3(x$8, x$9))) {
                if (this.mutable$1(sft, mutable$lzy, bitmap$0).getUserData().remove(SimpleFeatureTypes.Configs$.MODULE$.FeatureExpiration()) == null) {
                    AgeOffIterator$.MODULE$.clear(ds, sft);
                    DtgAgeOffIterator$.MODULE$.clear(ds, sft);
                } else {
                    ds.updateSchema(sft.getTypeName(), this.mutable$1(sft, mutable$lzy, bitmap$0));
                }
            }
        }
    }

    private final SimpleFeatureType mutable$lzycompute$1(SimpleFeatureType sft$1, ObjectRef mutable$lzy$1, VolatileByteRef bitmap$0$1) {
        AccumuloAgeOffCommand accumuloAgeOffCommand = this;
        synchronized (accumuloAgeOffCommand) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                mutable$lzy$1.elem = SimpleFeatureTypes$.MODULE$.mutable(sft$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (SimpleFeatureType)mutable$lzy$1.elem;
        }
    }

    private final SimpleFeatureType mutable$1(SimpleFeatureType sft$1, ObjectRef mutable$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.mutable$lzycompute$1(sft$1, mutable$lzy$1, bitmap$0$1) : (SimpleFeatureType)mutable$lzy$1.elem;
    }

    public AccumuloAgeOffCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        AccumuloDataStoreCommand$class.$init$(this);
        this.name = "configure-age-off";
        this.params = new AccumuloAgeOffParams();
    }

    @Parameters(commandDescription="List/set/remove age-off for a GeoMesa feature type")
    public static class AccumuloAgeOffParams
    implements AccumuloDataStoreParams,
    RequiredTypeNameParam,
    OptionalDtgParam {
        @Parameter(names={"-e", "--expiry"}, description="Duration before entries are aged-off, e.g. '1 day', '2 weeks and 1 hour', etc", converter=ParameterConverters.DurationConverter.class)
        private Duration expiry;
        @Parameter(names={"-l", "--list"}, description="List existing age-off for a simple feature type")
        private boolean list;
        @Parameter(names={"-s", "--set"}, description="Set age-off for a simple feature type")
        private boolean set;
        @Parameter(names={"-r", "--remove"}, description="Remove existing age-off for a simple feature type")
        private boolean remove;
        @Parameter(names={"--dtg"}, description="DateTime field name to use as the default dtg")
        private String dtgField;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;

        public String dtgField() {
            return this.dtgField;
        }

        public void dtgField_$eq(String x$1) {
            this.dtgField = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        @TraitSetter
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        @TraitSetter
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public Duration expiry() {
            return this.expiry;
        }

        public void expiry_$eq(Duration x$1) {
            this.expiry = x$1;
        }

        public boolean list() {
            return this.list;
        }

        public void list_$eq(boolean x$1) {
            this.list = x$1;
        }

        public boolean set() {
            return this.set;
        }

        public void set_$eq(boolean x$1) {
            this.set = x$1;
        }

        public boolean remove() {
            return this.remove;
        }

        public void remove_$eq(boolean x$1) {
            this.remove = x$1;
        }

        public AccumuloAgeOffParams() {
            ZookeepersParam$class.$init$(this);
            InstanceNameParams$class.$init$(this);
            PasswordParams.class.$init$((PasswordParams)this);
            CredentialsParams.class.$init$((CredentialsParams)this);
            KerberosParams.class.$init$((KerberosParams)this);
            AccumuloConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalDtgParam.class.$init$((OptionalDtgParam)this);
        }
    }
}

