/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.data;

import com.beust.jcommander.ParameterException;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.geotools.data.DataStore;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$class;
import org.locationtech.geomesa.accumulo.tools.data.AddIndexCommand;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndexFactory$;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata$;
import org.locationtech.geomesa.jobs.accumulo.AccumuloJobUtils$;
import org.locationtech.geomesa.jobs.accumulo.index.WriteIndexJob;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.conf.IndexId;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u001f\t9\u0012\t\u001a3J]\u0012,\u0007pQ8n[\u0006tG-\u0012=fGV$xN\u001d\u0006\u0003\u0007\u0011\tA\u0001Z1uC*\u0011QAB\u0001\u0006i>|Gn\u001d\u0006\u0003\u000f!\t\u0001\"Y2dk6,Hn\u001c\u0006\u0003\u0013)\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\f\u0019\u0005aAn\\2bi&|g\u000e^3dQ*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!aY\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005EI\u0012B\u0001\u000e\u0013\u0005!\u0011VO\u001c8bE2,\u0007C\u0001\u000f\u001e\u001b\u0005!\u0011B\u0001\u0010\u0005\u0005a\t5mY;nk2|G)\u0019;b'R|'/Z\"p[6\fg\u000e\u001a\u0005\tA\u0001\u0011)\u0019!C!C\u00051\u0001/\u0019:b[N,\u0012A\t\t\u0003GUr!\u0001J\u001a\u000f\u0005\u0015\u0012dB\u0001\u00142\u001d\t9\u0003G\u0004\u0002)_9\u0011\u0011F\f\b\u0003U5j\u0011a\u000b\u0006\u0003Y9\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003i\t\tq\"\u00113e\u0013:$W\r_\"p[6\fg\u000eZ\u0005\u0003m]\u0012!#\u00113e\u0013:$W\r\u001f)be\u0006lW\r^3sg*\u0011AG\u0001\u0005\ts\u0001\u0011\t\u0011)A\u0005E\u00059\u0001/\u0019:b[N\u0004\u0003\"B\u001e\u0001\t\u0003a\u0014A\u0002\u001fj]&$h\b\u0006\u0002>\u007fA\u0011a\bA\u0007\u0002\u0005!)\u0001E\u000fa\u0001E!9\u0011\t\u0001b\u0001\n\u0003\u0012\u0015\u0001\u00028b[\u0016,\u0012a\u0011\t\u0003#\u0011K!!\u0012\n\u0003\rM#(/\u001b8h\u0011\u00199\u0005\u0001)A\u0005\u0007\u0006)a.Y7fA!)\u0011\n\u0001C!\u0015\u00069Q\r_3dkR,G#A&\u0011\u00051{U\"A'\u000b\u00039\u000bQa]2bY\u0006L!\u0001U'\u0003\tUs\u0017\u000e\u001e\u0005\u0006%\u0002!\tES\u0001\u0004eVt\u0007\"\u0002+\u0001\t\u0003)\u0016\u0001C1eI&sG-\u001a=\u0015\u0005-3\u0006\"B,T\u0001\u0004A\u0016A\u00013t!\tI6,D\u0001[\u0015\t\u0019a!\u0003\u0002]5\n\t\u0012iY2v[Vdw\u000eR1uCN#xN]3")
public class AddIndexCommandExecutor
implements Runnable,
AccumuloDataStoreCommand {
    private final AddIndexCommand.AddIndexParameters params;
    private final String name;

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand$class.connection(this);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public AddIndexCommand.AddIndexParameters params() {
        return this.params;
    }

    public String name() {
        return this.name;
    }

    public void execute() {
    }

    @Override
    public void run() {
        this.withDataStore((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddIndexCommandExecutor $outer;

            public final void apply(AccumuloDataStore ds) {
                this.$outer.addIndex(ds);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addIndex(AccumuloDataStore ds) {
        Object x$11;
        Object x$8;
        List x$7;
        String x$6;
        SimpleFeatureType sft = (SimpleFeatureType)Option$.MODULE$.apply((Object)ds.getSchema(this.params().featureName())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleFeatureType apply(SimpleFeatureType sft) {
                return SimpleFeatureTypes$.MODULE$.mutable(sft);
            }
        }).orNull(Predef$.MODULE$.$conforms());
        Predef$.MODULE$.require(sft != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddIndexCommandExecutor $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' does not exist in the specified data store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.params().featureName()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(sft);
        SimpleFeatureType copy = builder.buildFeatureType();
        copy.getUserData().putAll(sft.getUserData());
        copy.getUserData().remove(SimpleFeatureTypes.InternalConfigs$.MODULE$.IndexVersions());
        copy.getUserData().put(SimpleFeatureTypes.Configs$.MODULE$.EnabledIndices(), JavaConversions$.MODULE$.asScalaBuffer(this.params().indexNames()).mkString(","));
        Seq indices = GeoMesaFeatureIndexFactory$.MODULE$.indices(copy);
        Seq existing = ds.manager().indices(sft, ds.manager().indices$default$2());
        Predef$.MODULE$.require(((IterableLike)indices.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(IndexId id) {
                return GeoMesaFeatureIndex$.MODULE$.identifier(id);
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this, existing){
            public static final long serialVersionUID = 0L;
            private final Seq existing$1;

            public final boolean apply(String i) {
                return !((SeqLike)this.existing$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(GeoMesaFeatureIndex<?, ?> x$1) {
                        return x$1.identifier();
                    }
                }, Seq$.MODULE$.canBuildFrom())).contains((Object)i);
            }
            {
                this.existing$1 = existing$1;
            }
        }), (Function0)new Serializable(this, existing){
            public static final long serialVersionUID = 0L;
            private final Seq existing$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested indices already exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.existing$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(GeoMesaFeatureIndex<?, ?> x$2) {
                        return x$2.identifier();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("[", "][", "]")}));
            }
            {
                this.existing$1 = existing$1;
            }
        });
        Seq toDisable = (Seq)indices.flatMap((Function1)new Serializable(this, existing){
            public static final long serialVersionUID = 0L;
            private final Seq existing$1;

            public final Iterable<Tuple2<IndexId, IndexId>> apply(IndexId i) {
                return Option$.MODULE$.option2Iterable(this.existing$1.find((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final IndexId i$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(GeoMesaFeatureIndex<?, ?> e) {
                        String string = e.name();
                        String string2 = this.i$1.name();
                        if (string == null) {
                            if (string2 != null) {
                                return false;
                            }
                        } else if (!string.equals(string2)) return false;
                        Seq seq = e.attributes();
                        Seq seq2 = this.i$1.attributes();
                        if (seq == null) {
                            if (seq2 == null) return true;
                            return false;
                        } else {
                            if (!seq.equals(seq2)) return false;
                            return true;
                        }
                    }
                    {
                        this.i$1 = i$1;
                    }
                }).map((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final IndexId i$1;

                    public final Tuple2<IndexId, IndexId> apply(GeoMesaFeatureIndex<?, ?> e) {
                        return new Tuple2((Object)this.i$1, (Object)new IndexId(e.name(), e.version(), e.attributes(), e.mode()));
                    }
                    {
                        this.i$1 = i$1;
                    }
                }));
            }
            {
                this.existing$1 = existing$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (toDisable.nonEmpty() && !Prompt$.MODULE$.confirm(x$6 = new StringBuilder().append((Object)"The following index versions will be replaced: ").append((Object)((TraversableOnce)toDisable.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<IndexId, IndexId> x0$1) {
                Tuple2<IndexId, IndexId> tuple2 = x0$1;
                if (tuple2 != null) {
                    IndexId n = (IndexId)tuple2._1();
                    IndexId o = (IndexId)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] by [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{o, GeoMesaFeatureIndex$.MODULE$.identifier(n)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")).append((Object)"Continue (y/n)? ").toString(), x$7 = Prompt$.MODULE$.confirm$default$2(), x$8 = Prompt$.MODULE$.confirm$default$3(x$6, x$7))) {
            return;
        }
        String x$9 = "If you are ingesting streaming data, you will be required to restart the streaming ingestion when prompted. Continue (y/n)? ";
        List x$10 = Prompt$.MODULE$.confirm$default$2();
        if (!Prompt$.MODULE$.confirm(x$9, x$10, x$11 = Prompt$.MODULE$.confirm$default$3(x$9, x$10))) return;
        String backupKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".bak"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GeoMesaMetadata$.MODULE$.AttributesKey()}));
        ds.metadata().insert(sft.getTypeName(), backupKey, ds.metadata().readRequired(sft.getTypeName(), GeoMesaMetadata$.MODULE$.AttributesKey()));
        Seq toKeep = (Seq)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).filter((Function1)new Serializable(this, toDisable){
            public static final long serialVersionUID = 0L;
            private final Seq toDisable$1;

            public final boolean apply(IndexId i) {
                return !((SeqLike)this.toDisable$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final IndexId apply(Tuple2<IndexId, IndexId> x$3) {
                        return (IndexId)x$3._2();
                    }
                }, Seq$.MODULE$.canBuildFrom())).contains((Object)i);
            }
            {
                this.toDisable$1 = toDisable$1;
            }
        });
        if (this.params().noBackFill() != null && this.params().noBackFill().booleanValue()) {
            Command$.MODULE$.user().info("Adding new indices and disabling old ones");
            RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft), (Seq)indices.$plus$plus((GenTraversableOnce)toKeep, Seq$.MODULE$.canBuildFrom()));
            ds.updateSchema(sft.getTypeName(), sft);
        } else {
            int result;
            int n;
            Command$.MODULE$.user().info("Adding new indices in write-only mode");
            RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft), (Seq)((TraversableLike)indices.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final IndexId apply(IndexId x$4) {
                    IndexMode.IndexMode x$12 = IndexMode$.MODULE$.Write();
                    String x$13 = x$4.copy$default$1();
                    int x$14 = x$4.copy$default$2();
                    Seq x$15 = x$4.copy$default$3();
                    return x$4.copy(x$13, x$14, x$15, x$12);
                }
            }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), Seq$.MODULE$.canBuildFrom()));
            ds.updateSchema(sft.getTypeName(), sft);
            String x$16 = "Indices have been added in write-only mode. To pick up the changes, please bounce any streaming ingestion. Once ingestion has resumed, press 'enter' to continue.";
            Object x$17 = Prompt$.MODULE$.acknowledge$default$2(x$16);
            Prompt$.MODULE$.acknowledge(x$16, x$17);
            Command$.MODULE$.user().info("Running index back-fill job");
            WriteIndexJob.WriteIndexArgs args = new WriteIndexJob.WriteIndexArgs((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            args.inZookeepers_$eq(this.params().zookeepers());
            args.inInstanceId_$eq(this.params().instance());
            args.inUser_$eq(this.params().user());
            args.inPassword_$eq(this.params().password());
            args.inTableName_$eq(this.params().catalog());
            args.inFeature_$eq(this.params().featureName());
            args.inCql_$eq((String)Option$.MODULE$.apply((Object)this.params().cqlFilter()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Filter x$1) {
                    return ECQL.toCQL((Filter)x$1);
                }
            }).orNull(Predef$.MODULE$.$conforms()));
            args.indexNames().addAll(JavaConversions$.MODULE$.seqAsJavaList((Seq)indices.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(IndexId id) {
                    return GeoMesaFeatureIndex$.MODULE$.identifier(id);
                }
            }, Seq$.MODULE$.canBuildFrom())));
            Some libjars = new Some((Object)new Tuple2((Object)AccumuloJobUtils$.MODULE$.defaultLibJars(), (Object)AccumuloJobUtils$.MODULE$.defaultSearchPath()));
            try {
                n = ToolRunner.run((Tool)new WriteIndexJob((Option)libjars), (String[])args.unparse());
            }
            catch (Throwable throwable) {
                int n2;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                Command$.MODULE$.user().error("Error running back-fill job:", e);
                n = result = (n2 = -1);
            }
            if (result == 0) {
                this.setReadWrite$1(ds, sft, indices, toKeep);
            } else {
                String string;
                String string2;
                String string3;
                String response = null;
                do {
                    String x$22 = "Index back-fill job failed. You may:\n  1. Switch the indices to read-write mode without existing data (you may manually back-fill later)\n  2. Roll-back index creation\nSelect an option: ";
                    Object x$23 = Prompt$.MODULE$.read$default$2(x$22);
                    String string4 = response = Prompt$.MODULE$.read(x$22, x$23);
                    String string5 = "1";
                    if (!(string4 == null ? string5 != null : !string4.equals(string5))) break;
                    string3 = response;
                    string2 = "2";
                } while (string3 != null ? !string3.equals(string2) : string2 != null);
                if ("1".equals(string = response)) {
                    this.setReadWrite$1(ds, sft, indices, toKeep);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (!"2".equals(string)) throw new MatchError((Object)string);
                    String bak = (String)ds.metadata().readRequired(sft.getTypeName(), backupKey);
                    ds.metadata().insert(sft.getTypeName(), GeoMesaMetadata$.MODULE$.AttributesKey(), (Object)bak);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        Command$.MODULE$.user().info("Operation complete. Please bounce any streaming ingestion to pick up the changes.");
    }

    private final void setReadWrite$1(AccumuloDataStore ds$1, SimpleFeatureType sft$1, Seq indices$1, Seq toKeep$1) {
        Command$.MODULE$.user().info("Setting index to read-write mode and disabling old indices");
        RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1), (Seq)((TraversableLike)indices$1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IndexId apply(IndexId x$5) {
                IndexMode.IndexMode x$18 = IndexMode$.MODULE$.ReadWrite();
                String x$19 = x$5.copy$default$1();
                int x$20 = x$5.copy$default$2();
                Seq x$21 = x$5.copy$default$3();
                return x$5.copy(x$19, x$20, x$21, x$18);
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)toKeep$1, Seq$.MODULE$.canBuildFrom()));
        Command$.MODULE$.user().info(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1)).toString());
        ds$1.updateSchema(sft$1.getTypeName(), sft$1);
    }

    public AddIndexCommandExecutor(AddIndexCommand.AddIndexParameters params) {
        this.params = params;
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        AccumuloDataStoreCommand$class.$init$(this);
        this.name = "";
    }
}

