/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.stats;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.data.stats.StatsCombiner$;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams$class;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam$class;
import org.locationtech.geomesa.index.utils.Releasable;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.stats.StatsConfigureCommand;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u001f\ti\u0012iY2v[Vdwn\u0015;biN\u001cuN\u001c4jOV\u0014XmQ8n[\u0006tGM\u0003\u0002\u0004\t\u0005)1\u000f^1ug*\u0011QAB\u0001\u0006i>|Gn\u001d\u0006\u0003\u000f!\t\u0001\"Y2dk6,Hn\u001c\u0006\u0003\u0013)\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\f\u0019\u0005aAn\\2bi&|g\u000e^3dQ*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!Y\u0011\u0003CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rE\u0002\u00185qi\u0011\u0001\u0007\u0006\u0003\u0007eQ!!\u0002\u0005\n\u0005mA\"!F*uCR\u001c8i\u001c8gS\u001e,(/Z\"p[6\fg\u000e\u001a\t\u0003;\u0001j\u0011A\b\u0006\u0003?\u0019\tA\u0001Z1uC&\u0011\u0011E\b\u0002\u0012\u0003\u000e\u001cW/\\;m_\u0012\u000bG/Y*u_J,\u0007CA\u0012%\u001b\u0005!\u0011BA\u0013\u0005\u0005a\t5mY;nk2|G)\u0019;b'R|'/Z\"p[6\fg\u000e\u001a\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"A\u000b\u0001\u000e\u0003\tAq\u0001\f\u0001C\u0002\u0013\u0005S&\u0001\u0004qCJ\fWn]\u000b\u0002]A\u0011qF\u0012\b\u0003a}r!!\r \u000f\u0005IjdBA\u001a=\u001d\t!4H\u0004\u00026u9\u0011a'O\u0007\u0002o)\u0011\u0001HD\u0001\u0007yI|w\u000e\u001e \n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t\u001d)\u0001I\u0001E\u0001\u0003\u0006i\u0012iY2v[Vdwn\u0015;biN\u001cuN\u001c4jOV\u0014XmQ8n[\u0006tG\r\u0005\u0002+\u0005\u001a)\u0011A\u0001E\u0001\u0007N\u0011!\t\u0005\u0005\u0006O\t#\t!\u0012\u000b\u0002\u0003\u001a!qI\u0011\u0001I\u0005q\t5mY;nk2|7\u000b^1ug\u000e{gNZ5hkJ,\u0007+\u0019:b[N\u001cBA\u0012\tJ)B\u0011!*\u0015\b\u0003\u0017>s!\u0001\u0014(\u000f\u0005Mj\u0015BA\u0003\t\u0013\t\u0019\u0011$\u0003\u0002Q1\u0005)2\u000b^1ug\u000e{gNZ5hkJ,7i\\7nC:$\u0017B\u0001*T\u0005Q\u0019F/\u0019;t\u0007>tg-[4ve\u0016\u0004\u0016M]1ng*\u0011\u0001\u000b\u0007\t\u0003GUK!A\u0016\u0003\u0003/\u0005\u001b7-^7vY>$\u0015\r^1Ti>\u0014X\rU1sC6\u001c\b\"B\u0014G\t\u0003AF#A-\u0011\u0005i3U\"\u0001\")\t\u0019cfm\u001a\t\u0003;\u0012l\u0011A\u0018\u0006\u0003?\u0002\f!B[2p[6\fg\u000eZ3s\u0015\t\t'-A\u0003cKV\u001cHOC\u0001d\u0003\r\u0019w.\\\u0005\u0003Kz\u0013!\u0002U1sC6,G/\u001a:t\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\"\u0003!\f1IV5fo2\u0002\u0013\r\u001a3!_J\u0004#/Z7pm\u0016\u0004\u0013iY2v[Vdw\u000eI:uCR\u001c\beY8nE&t\u0017N\\4!SR,'/\u0019;pe\u00022wN\u001d\u0011bA\r\fG/\u00197pO\"1!\u000e\u0001Q\u0001\n9\nq\u0001]1sC6\u001c\b\u0005C\u0003m\u0001\u0011ES.\u0001\u0003mSN$HC\u00018r!\t\tr.\u0003\u0002q%\t!QK\\5u\u0011\u0015\u00118\u000e1\u0001\u001d\u0003\t!7\u000fC\u0003u\u0001\u0011ES/A\u0002bI\u0012$\"A\u001c<\t\u000bI\u001c\b\u0019\u0001\u000f\t\u000ba\u0004A\u0011K=\u0002\rI,Wn\u001c<f)\tq'\u0010C\u0003so\u0002\u0007A\u0004")
public class AccumuloStatsConfigureCommand
implements StatsConfigureCommand<AccumuloDataStore>,
AccumuloDataStoreCommand {
    private final AccumuloStatsConfigureParams params;
    private final String name;

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$stats$StatsConfigureCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        StatsConfigureCommand.class.execute((StatsConfigureCommand)this);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public AccumuloStatsConfigureParams params() {
        return this.params;
    }

    public void list(AccumuloDataStore ds) {
        Iterable configured = (Iterable)StatsCombiner$.MODULE$.list(ds.connector(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_stats"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ds.config().catalog()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configured stats iterator: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configured.mkString("\n  ", "\n  ", "")})));
    }

    /*
     * WARNING - void declaration
     */
    public void add(AccumuloDataStore ds) {
        Releasable lock = ds.acquireCatalogLock();
        try {
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ds.getTypeNames()).map((Function1)new Serializable(this, ds){
                public static final long serialVersionUID = 0L;
                private final AccumuloDataStore ds$1;

                public final SimpleFeatureType apply(String typeName) {
                    return this.ds$1.getSchema(typeName);
                }
                {
                    this.ds$1 = ds$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeatureType.class)))).foreach((Function1)new Serializable(this, ds){
                public static final long serialVersionUID = 0L;
                private final AccumuloDataStore ds$1;

                public final void apply(SimpleFeatureType sft) {
                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configuring stats iterator for '", "'..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
                    this.ds$1.stats().configureStatCombiner(this.ds$1.connector(), sft);
                }
                {
                    this.ds$1 = ds$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.release();
            throw throwable;
        }
        lock.release();
        Command$.MODULE$.user().info("done");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(AccumuloDataStore ds) {
        Object x$3;
        List x$2;
        String x$1 = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing stats iterator configuration for catalog '", "'. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ds.config().catalog()}))).append((Object)"Continue (y/n)? ").toString();
        boolean confirm = Prompt$.MODULE$.confirm(x$1, x$2 = Prompt$.MODULE$.confirm$default$2(), x$3 = Prompt$.MODULE$.confirm$default$3(x$1, x$2));
        if (!confirm) return;
        Releasable lock = ds.acquireCatalogLock();
        try {
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ds.getTypeNames()).map((Function1)new Serializable(this, ds){
                public static final long serialVersionUID = 0L;
                private final AccumuloDataStore ds$2;

                public final SimpleFeatureType apply(String typeName) {
                    return this.ds$2.getSchema(typeName);
                }
                {
                    this.ds$2 = ds$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeatureType.class)))).foreach((Function1)new Serializable(this, ds){
                public static final long serialVersionUID = 0L;
                private final AccumuloDataStore ds$2;

                public final void apply(SimpleFeatureType sft) {
                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing stats iterator for '", "'..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
                    this.ds$2.stats().removeStatCombiner(this.ds$2.connector(), sft);
                }
                {
                    this.ds$2 = ds$2;
                }
            });
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.release();
            throw throwable;
        }
        lock.release();
        Command$.MODULE$.user().info("done");
    }

    public AccumuloStatsConfigureCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        StatsConfigureCommand.class.$init$((StatsConfigureCommand)this);
        AccumuloDataStoreCommand$class.$init$(this);
        this.params = new AccumuloStatsConfigureParams();
    }

    @Parameters(commandDescription="View, add or remove Accumulo stats combining iterator for a catalog")
    public static class AccumuloStatsConfigureParams
    implements StatsConfigureCommand.StatsConfigureParams,
    AccumuloDataStoreParams {
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;
        @Parameter(names={"-l", "--list"}, description="List current stats table configuration for a catalog")
        private boolean list;
        @Parameter(names={"-a", "--add"}, description="Configure the stats table for a catalog")
        private boolean add;
        @Parameter(names={"-r", "--remove"}, description="Remove current stats table configuration for a catalog")
        private boolean remove;

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        @TraitSetter
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        @TraitSetter
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public boolean list() {
            return this.list;
        }

        public void list_$eq(boolean x$1) {
            this.list = x$1;
        }

        public boolean add() {
            return this.add;
        }

        public void add_$eq(boolean x$1) {
            this.add = x$1;
        }

        public boolean remove() {
            return this.remove;
        }

        public void remove_$eq(boolean x$1) {
            this.remove = x$1;
        }

        public AccumuloStatsConfigureParams() {
            StatsConfigureCommand.StatsConfigureParams.class.$init$((StatsConfigureCommand.StatsConfigureParams)this);
            ZookeepersParam$class.$init$(this);
            InstanceNameParams$class.$init$(this);
            PasswordParams.class.$init$((PasswordParams)this);
            CredentialsParams.class.$init$((CredentialsParams)this);
            KerberosParams.class.$init$((KerberosParams)this);
            AccumuloConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
        }
    }
}

