/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.config.Config;
import java.io.File;
import java.net.URI;
import java.util.List;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$AccumuloDistributedCommand$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams$class;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam$class;
import org.locationtech.geomesa.accumulo.tools.ingest.AccumuloBulkIngestCommand$BulkConverterIngest$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.partition.TablePartition;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.jobs.accumulo.mapreduce.GeoMesaAccumuloFileOutputFormat$;
import org.locationtech.geomesa.jobs.mapreduce.ConverterCombineInputFormat;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.DistributedCombineParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.OutputPathParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.TempPathParam;
import org.locationtech.geomesa.tools.data.CreateSchemaCommand;
import org.locationtech.geomesa.tools.ingest.ConverterIngestJob;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.tools.utils.StorageJobUtils$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.fs.HadoopDelegate$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001B\u0001\u0003\u0001=\u0011\u0011$Q2dk6,Hn\u001c\"vY.LenZ3ti\u000e{W.\\1oI*\u00111\u0001B\u0001\u0007S:<Wm\u001d;\u000b\u0005\u00151\u0011!\u0002;p_2\u001c(BA\u0004\t\u0003!\t7mY;nk2|'BA\u0005\u000b\u0003\u001d9Wm\\7fg\u0006T!a\u0003\u0007\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u0019IA\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000fE\u0002\u001a9yi\u0011A\u0007\u0006\u0003\u0007mQ!!\u0002\u0005\n\u0005uQ\"!D%oO\u0016\u001cHoQ8n[\u0006tG\r\u0005\u0002 E5\t\u0001E\u0003\u0002\"\r\u0005!A-\u0019;b\u0013\t\u0019\u0003EA\tBG\u000e,X.\u001e7p\t\u0006$\u0018m\u0015;pe\u0016\u0004\"!J\u001b\u000f\u0005\u0019\u001adBA\u00143\u001d\tA\u0013G\u0004\u0002*a9\u0011!f\f\b\u0003W9j\u0011\u0001\f\u0006\u0003[9\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011A\u0007B\u0001\u0019\u0003\u000e\u001cW/\\;m_\u0012\u000bG/Y*u_J,7i\\7nC:$\u0017B\u0001\u001c8\u0005i\t5mY;nk2|G)[:ue&\u0014W\u000f^3e\u0007>lW.\u00198e\u0015\t!D\u0001C\u0003:\u0001\u0011\u0005!(\u0001\u0004=S:LGO\u0010\u000b\u0002wA\u0011A\bA\u0007\u0002\u0005!9a\b\u0001b\u0001\n\u0003z\u0014\u0001\u00028b[\u0016,\u0012\u0001\u0011\t\u0003#\u0005K!A\u0011\n\u0003\rM#(/\u001b8h\u0011\u0019!\u0005\u0001)A\u0005\u0001\u0006)a.Y7fA!9a\t\u0001b\u0001\n\u0003:\u0015A\u00029be\u0006l7/F\u0001I!\tI\u0015L\u0004\u0002K\u0019:\u0011aeS\u0005\u0003\u0007\u00119Q!\u0014\u0002\t\u00029\u000b\u0011$Q2dk6,Hn\u001c\"vY.LenZ3ti\u000e{W.\\1oIB\u0011Ah\u0014\u0004\u0006\u0003\tA\t\u0001U\n\u0003\u001fF\u0003\"AU+\u000e\u0003MS\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-N\u0013a!\u00118z%\u00164\u0007\"B\u001dP\t\u0003AF#\u0001(\u0007\ti{\u0005a\u0017\u0002\u0019\u0003\u000e\u001cW/\\;m_\n+Hn[%oO\u0016\u001cH\u000fU1sC6\u001c8\u0003C-R9\u001e\\wN];\u0011\u0005u#gB\u00010c\u001d\ty\u0016M\u0004\u0002)A&\u0011Q\u0001C\u0005\u0003\u0007mI!a\u0019\u000e\u0002\u001b%sw-Z:u\u0007>lW.\u00198e\u0013\t)gM\u0001\u0007J]\u001e,7\u000f\u001e)be\u0006l7O\u0003\u0002d5A\u0011\u0001.[\u0007\u0002\t%\u0011!\u000e\u0002\u0002\u0018\u0003\u000e\u001cW/\\;m_\u0012\u000bG/Y*u_J,\u0007+\u0019:b[N\u0004\"\u0001\\7\u000e\u0003mI!A\\\u000e\u0003\u001f=+H\u000f];u!\u0006$\b\u000eU1sC6\u0004\"\u0001\u001c9\n\u0005E\\\"AE(qi&|g.\u00197J]\u0012,\u0007\u0010U1sC6\u0004\"\u0001\\:\n\u0005Q\\\"AF(qi&|g.\u00197Dc24\u0015\u000e\u001c;feB\u000b'/Y7\u0011\u000514\u0018BA<\u001c\u00055!V-\u001c9QCRD\u0007+\u0019:b[\")\u0011(\u0017C\u0001sR\t!\u0010\u0005\u0002|36\tq\nC\u0004~3\u0002\u0007I\u0011\u0001@\u0002\u0015M\\\u0017\u000e]%na>\u0014H/F\u0001\u0000!\r\u0011\u0016\u0011A\u0005\u0004\u0003\u0007\u0019&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u000fI\u0006\u0019!C\u0001\u0003\u0013\tab]6ja&k\u0007o\u001c:u?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005E\u0001c\u0001*\u0002\u000e%\u0019\u0011qB*\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003'\t)!!AA\u0002}\f1\u0001\u001f\u00132\u0011\u001d\t9\"\u0017Q!\n}\f1b]6ja&k\u0007o\u001c:uA!b\u0011QCA\u000e\u0003_\t\t$a\u000e\u0002:A!\u0011QDA\u0016\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012A\u00036d_6l\u0017M\u001c3fe*!\u0011QEA\u0014\u0003\u0015\u0011W-^:u\u0015\t\tI#A\u0002d_6LA!!\f\u0002 \tI\u0001+\u0019:b[\u0016$XM]\u0001\u0006]\u0006lWm\u001d\u0017\u0003\u0003g\t#!!\u000e\u0002\u001b5j3o[5q[%l\u0007o\u001c:u\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0005\u0005m\u0012!O$f]\u0016\u0014\u0018\r^3!i\",\u0007EZ5mKN\u0004#-\u001e;!g.L\u0007\u000f\t;iK\u0002\u0012W\u000f\\6!S6\u0004xN\u001d;!S:$x\u000eI!dGVlW\u000f\\8)\u000fe\u000by$!\u0012\u0002HA!\u0011QDA!\u0013\u0011\t\u0019%a\b\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0017EAA%\u0003u\u001auN\u001c<feR\u0004c/\u0019:j_V\u001c\bEZ5mK\u00022wN]7biN\u0004\u0013N\u001c;pA\t,Hn\u001b\u0011m_\u0006$W\r\u001a\u0011BG\u000e,X.\u001e7pAI3\u0015\u000e\\3t\u0011\u001d\ti\u0005\u0001Q\u0001\n!\u000bq\u0001]1sC6\u001c\b\u0005C\u0004\u0002R\u0001!\t&a\u0015\u0002\u0017M$\u0018M\u001d;J]\u001e,7\u000f\u001e\u000b\r\u0003+\nY'!\"\u0002\n\u0006\u0005\u0016Q\u0017\t\u0005\u0003/\n)G\u0004\u0003\u0002Z\u0005}cb\u0001\u0015\u0002\\%\u0019\u0011Q\f\u0005\u0002\t)|'m]\u0005\u0005\u0003C\n\u0019'A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005u\u0003\"\u0003\u0003\u0002h\u0005%$!C!xC&$\u0018M\u00197f\u0015\u0011\t\t'a\u0019\t\u0011\u00055\u0014q\na\u0001\u0003_\nA!\\8eKB!\u0011\u0011OA@\u001d\u0011\t\u0019(!\u001f\u000f\u0007}\u000b)(C\u0002\u0002xm\t1\u0003R5tiJL'-\u001e;fIJ+h\u000eU1sC6LA!a\u001f\u0002~\u0005A!+\u001e8N_\u0012,7OC\u0002\u0002xmIA!!!\u0002\u0004\n9!+\u001e8N_\u0012,'\u0002BA>\u0003{Bq!a\"\u0002P\u0001\u0007a$\u0001\u0002eg\"A\u00111RA(\u0001\u0004\ti)A\u0002tMR\u0004B!a$\u0002\u001e6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003/\u000bI*A\u0004gK\u0006$XO]3\u000b\u0007\u0005mE\"A\u0004pa\u0016tw-[:\n\t\u0005}\u0015\u0011\u0013\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007\u0002CAR\u0003\u001f\u0002\r!!*\u0002\u0013\r|gN^3si\u0016\u0014\b\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\u0007G>tg-[4\u000b\t\u0005=\u0016qE\u0001\tif\u0004Xm]1gK&!\u00111WAU\u0005\u0019\u0019uN\u001c4jO\"A\u0011qWA(\u0001\u0004\tI,\u0001\u0004j]B,Ho\u001d\t\u0004;\u0006m\u0016bAA_M\n1\u0011J\u001c9viN4a!!1\u0001\u0001\u0005\r'a\u0005\"vY.\u001cuN\u001c<feR,'/\u00138hKN$8\u0003BA`\u0003\u000b\u00042!GAd\u0013\r\tIM\u0007\u0002\u0013\u0007>tg/\u001a:uKJLenZ3ti*{'\r\u0003\u0006\u0002\b\u0006}&\u0011!Q\u0001\nyA1\"a4\u0002@\n\u0005\t\u0015!\u0003\u0002R\u0006AAm\u001d)be\u0006l7\u000f\u0005\u0005\u0002T\u0006e\u0017q\\Ap\u001d\r\u0011\u0016Q[\u0005\u0004\u0003/\u001c\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\\\u0006u'aA'ba*\u0019\u0011q[*\u0011\t\u0005M\u0017\u0011]\u0005\u0004\u0005\u0006u\u0007bCAF\u0003\u007f\u0013\t\u0011)A\u0005\u0003\u001bC1\"a:\u0002@\n\u0005\t\u0015!\u0003\u0002&\u0006y1m\u001c8wKJ$XM]\"p]\u001aLw\rC\u0006\u0002l\u0006}&\u0011!Q\u0001\n\u00055\u0018!\u00029bi\"\u001c\bCBAx\u0003o\fyN\u0004\u0003\u0002r\u0006UhbA\u0016\u0002t&\tA+C\u0002\u0002bMKA!!?\u0002|\n\u00191+Z9\u000b\u0007\u0005\u00054\u000bC\u0006\u0002\u0000\u0006}&\u0011!Q\u0001\n\t\u0005\u0011AB8viB,H\u000f\u0005\u0003\u0003\u0004\tEQB\u0001B\u0003\u0015\u0011\u00119A!\u0003\u0002\u0005\u0019\u001c(\u0002\u0002B\u0006\u0005\u001b\ta\u0001[1e_>\u0004(b\u0001B\b\u0019\u00051\u0011\r]1dQ\u0016LAAa\u0005\u0003\u0006\t!\u0001+\u0019;i\u0011-\u00119\"a0\u0003\u0002\u0003\u0006IA!\u0007\u0002\u0015Q,W\u000e](viB,H\u000fE\u0003S\u00057\u0011\t!C\u0002\u0003\u001eM\u0013aa\u00149uS>t\u0007b\u0003B\u0011\u0003\u007f\u0013\t\u0011)A\u0005\u0005G\tA\"\\1y'Bd\u0017\u000e^*ju\u0016\u0004RA\u0015B\u000e\u0005K\u00012A\u0015B\u0014\u0013\r\u0011Ic\u0015\u0002\u0004\u0013:$\bb\u0003B\u0017\u0003\u007f\u0013\t\u0011)A\u0005\u0005_\tQ!\u001b8eKb\u0004RA\u0015B\u000e\u0003?D1Ba\r\u0002@\n\u0005\t\u0015!\u0003\u00036\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000bI\u0013Y\"!<\t\u0017\te\u0012q\u0018B\u0001B\u0003%\u0011Q^\u0001\rY&\u0014'.\u0019:t\r&dWm\u001d\u0005\f\u0005{\tyL!A!\u0002\u0013\u0011y$\u0001\u0007mS\nT\u0017M]:QCRD7\u000f\u0005\u0004\u0002p\n\u0005#QI\u0005\u0005\u0005\u0007\nYP\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0015\u0011&q\tB&\u0013\r\u0011Ie\u0015\u0002\n\rVt7\r^5p]B\u0002b!a<\u0002x\n5\u0003\u0003\u0002B(\u0005+j!A!\u0015\u000b\u0007\tMC#\u0001\u0002j_&!!q\u000bB)\u0005\u00111\u0015\u000e\\3\t\u000fe\ny\f\"\u0001\u0003\\QQ\"Q\fB1\u0005G\u0012)Ga\u001a\u0003j\t-$Q\u000eB8\u0005c\u0012\u0019H!\u001e\u0003xA!!qLA`\u001b\u0005\u0001\u0001bBAD\u00053\u0002\rA\b\u0005\t\u0003\u001f\u0014I\u00061\u0001\u0002R\"A\u00111\u0012B-\u0001\u0004\ti\t\u0003\u0005\u0002h\ne\u0003\u0019AAS\u0011!\tYO!\u0017A\u0002\u00055\b\u0002CA\u0000\u00053\u0002\rA!\u0001\t\u0011\t]!\u0011\fa\u0001\u00053A\u0001B!\t\u0003Z\u0001\u0007!1\u0005\u0005\t\u0005[\u0011I\u00061\u0001\u00030!A!1\u0007B-\u0001\u0004\u0011)\u0004\u0003\u0005\u0003:\te\u0003\u0019AAw\u0011!\u0011iD!\u0017A\u0002\t}\u0002\u0002\u0004B>\u0003\u007f\u0003\r\u00111A\u0005\n\tu\u0014a\u00027jE*\f'o]\u000b\u0003\u0003?DAB!!\u0002@\u0002\u0007\t\u0019!C\u0005\u0005\u0007\u000b1\u0002\\5cU\u0006\u00148o\u0018\u0013fcR!\u00111\u0002BC\u0011)\t\u0019Ba \u0002\u0002\u0003\u0007\u0011q\u001c\u0005\n\u0005\u0013\u000by\f)Q\u0005\u0003?\f\u0001\u0002\\5cU\u0006\u00148\u000f\t\u0005\t\u0005\u001b\u000by\f\"\u0011\u0003\u0010\u0006a1m\u001c8gS\u001e,(/\u001a&pER!\u00111\u0002BI\u0011!\u0011\u0019Ja#A\u0002\tU\u0015a\u00016pEB!!q\u0013BO\u001b\t\u0011IJ\u0003\u0003\u0003\u001c\n%\u0011!C7baJ,G-^2f\u0013\u0011\u0011yJ!'\u0003\u0007){'\r\u0003\u0005\u0003$\u0006}F\u0011\tBS\u0003\u0015\tw/Y5u)\u0011\u00119K!,\u0011\t\u0005]#\u0011V\u0005\u0005\u0005W\u000bIGA\u0005K_\n\u0014Vm];mi\"A!q\u0016BQ\u0001\u0004\u0011\t,\u0001\u0005sKB|'\u000f^3s!\u0011\t9Fa-\n\t\tU\u0016\u0011\u000e\u0002\u000f'R\fG/^:DC2d'-Y2l\u0001")
public class AccumuloBulkIngestCommand
implements IngestCommand<AccumuloDataStore>,
AccumuloDataStoreCommand.AccumuloDistributedCommand {
    private final String name;
    private final AccumuloBulkIngestParams params;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;

    @Override
    public /* synthetic */ Seq org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$AccumuloDistributedCommand$$super$libjarsFiles() {
        return IngestCommand.class.libjarsFiles((IngestCommand)this);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$AccumuloDistributedCommand$$super$libjarsPaths() {
        return package.DistributedCommand.class.libjarsPaths((package.DistributedCommand)this);
    }

    @Override
    public Seq<String> libjarsFiles() {
        return AccumuloDataStoreCommand$AccumuloDistributedCommand$class.libjarsFiles(this);
    }

    @Override
    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return AccumuloDataStoreCommand$AccumuloDistributedCommand$class.libjarsPaths(this);
    }

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand$class.connection(this);
    }

    public void org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq(String x$1) {
    }

    public void execute() {
        IngestCommand.class.execute((IngestCommand)this);
    }

    public void setBackendSpecificOptions(SimpleFeatureType sft) {
        CreateSchemaCommand.SchemaOptionsCommand.class.setBackendSpecificOptions((CreateSchemaCommand.SchemaOptionsCommand)this, (SimpleFeatureType)sft);
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return package.InteractiveCommand.class.console((package.InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        package.InteractiveCommand.class.setConsole((package.InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.class.withDataStore((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.class.loadDataStore((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.class.subCommands((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.class.validate((package.Command)this);
    }

    public void run() {
        package.Command.class.run((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    @Override
    public AccumuloBulkIngestParams params() {
        return this.params;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public package.Awaitable startIngest(Enumeration.Value mode, AccumuloDataStore ds, SimpleFeatureType sft, Config converter, IngestCommand.Inputs inputs) {
        Object object;
        None$ maxSplitSize = this.params().combineInputs() ? Option$.MODULE$.apply((Object)this.params().maxSplitSize()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }).orElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Some<Object> apply() {
                return new Some((Object)BoxesRunTime.boxToInteger((int)0));
            }
        }) : None$.MODULE$;
        Option index = this.params().loadIndex(ds, sft.getTypeName(), IndexMode$.MODULE$.Write()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(GeoMesaFeatureIndex<?, ?> x$2) {
                return x$2.identifier();
            }
        });
        Option partitions = TablePartition$.MODULE$.apply((package.HasGeoMesaMetadata)ds, sft).map((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccumuloBulkIngestCommand $outer;
            private final SimpleFeatureType sft$1;

            public final Seq<String> apply(TablePartition tp) {
                if (this.$outer.params().cqlFilter() == null) {
                    throw new ParameterException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' is a partitioned store. In order to bulk load, the '--cql' parameter "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sft$1.getTypeName()}))).append((Object)"must be used to specify the range of the input data set").toString());
                }
                return (Seq)tp.partitions(this.$outer.params().cqlFilter()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Seq<String> x$3) {
                        return x$3.nonEmpty();
                    }
                }).getOrElse((Function0)new Serializable(this, tp){
                    public static final long serialVersionUID = 0L;
                    private final TablePartition tp$1;

                    public final Nothing$ apply() {
                        throw new ParameterException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition filter does not correspond to partition scheme ", ". Please specify "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1.getClass().getSimpleName()}))).append((Object)"a valid filter using the '--cql' parameter").toString());
                    }
                    {
                        this.tp$1 = tp$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
            }
        });
        Enumeration.Value value = mode;
        Enumeration.Value value2 = DistributedRunParam.RunModes$.MODULE$.Local();
        Enumeration.Value value3 = value;
        if (value2 == null) {
            if (value3 == null) throw new IllegalArgumentException("Bulk ingest must be run in distributed mode");
        } else if (value2.equals(value3)) {
            throw new IllegalArgumentException("Bulk ingest must be run in distributed mode");
        }
        Enumeration.Value value4 = DistributedRunParam.RunModes$.MODULE$.Distributed();
        Enumeration.Value value5 = value;
        if (value4 != null ? !value4.equals(value5) : value5 != null) throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing implementation for mode ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mode})));
        Configuration conf = new Configuration();
        Path output = new Path(this.params().outputPath());
        FileContext context = FileContext.getFileContext((URI)output.toUri(), (Configuration)conf);
        if (context.util().exists(output)) {
            String warning = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output directory '", "' exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output}));
            if (this.params().force()) {
                package.Command$.MODULE$.user().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - deleting it"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{warning})));
            } else if (!Prompt$.MODULE$.confirm(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING DATA MAY BE LOST: ", ". Delete it and continue (y/n)? "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{warning})), Prompt$.MODULE$.confirm$default$2(), this.console())) throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output directory '", "' exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output})));
            object = BoxesRunTime.boxToBoolean((boolean)context.delete(output, true));
        } else {
            object = BoxedUnit.UNIT;
        }
        Option tempPath = Option$.MODULE$.apply((Object)this.params().tempPath()).map((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final Path apply(String temp) {
                Object object;
                Path path = new Path(temp);
                FileContext tempContext = FileContext.getFileContext((URI)path.toUri(), (Configuration)this.conf$1);
                Path dir = tempContext.makeQualified(path);
                if (tempContext.util().exists(dir)) {
                    package.Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting temp output path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir})));
                    object = BoxesRunTime.boxToBoolean((boolean)tempContext.delete(dir, true));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return dir;
            }
            {
                this.conf$1 = conf$1;
            }
        });
        package.Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running bulk ingestion in distributed ", "mode"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().combineInputs() ? "combine " : ""})));
        return new BulkConverterIngest(this, ds, this.connection(), sft, converter, (Seq<String>)inputs.paths(), output, (Option<Path>)tempPath, (Option<Object>)maxSplitSize, (Option<String>)index, (Option<Seq<String>>)partitions, this.libjarsFiles(), this.libjarsPaths());
    }

    public AccumuloBulkIngestCommand() {
        package.Command.class.$init$((package.Command)this);
        package.DataStoreCommand.class.$init$((package.DataStoreCommand)this);
        package.DistributedCommand.class.$init$((package.DistributedCommand)this);
        package.InteractiveCommand.class.$init$((package.InteractiveCommand)this);
        CreateSchemaCommand.SchemaOptionsCommand.class.$init$((CreateSchemaCommand.SchemaOptionsCommand)this);
        IngestCommand.class.$init$((IngestCommand)this);
        AccumuloDataStoreCommand$class.$init$(this);
        AccumuloDataStoreCommand$AccumuloDistributedCommand$class.$init$(this);
        this.name = "bulk-ingest";
        this.params = new AccumuloBulkIngestParams();
    }

    public class BulkConverterIngest
    extends ConverterIngestJob {
        public final AccumuloDataStore org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$ds;
        private final Map<String, String> dsParams;
        private final SimpleFeatureType sft;
        public final Path org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$output;
        public final Option<Path> org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$tempOutput;
        private final Option<Object> maxSplitSize;
        private final Option<String> index;
        private final Option<Seq<String>> partitions;
        private String org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$libjars;
        public final /* synthetic */ AccumuloBulkIngestCommand $outer;

        public String org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$libjars() {
            return this.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$libjars;
        }

        private void org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$libjars_$eq(String x$1) {
            this.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$libjars = x$1;
        }

        public void configureJob(Job job) {
            super.configureJob(job);
            Path dest = (Path)this.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$tempOutput.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BulkConverterIngest $outer;

                public final Path apply() {
                    return this.$outer.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$output;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            GeoMesaAccumuloFileOutputFormat$.MODULE$.configure(job, this.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$ds, this.dsParams, this.sft, dest, this.index, this.partitions);
            this.maxSplitSize.foreach((Function1)new Serializable(this, job){
                public static final long serialVersionUID = 0L;
                private final Job job$1;

                public final void apply(int max) {
                    this.apply$mcVI$sp(max);
                }

                public void apply$mcVI$sp(int max) {
                    this.job$1.setInputFormatClass(ConverterCombineInputFormat.class);
                    if (max > 0) {
                        FileInputFormat.setMaxInputSplitSize((Job)this.job$1, (long)max);
                    }
                }
                {
                    this.job$1 = job$1;
                }
            });
            this.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$libjars_$eq(job.getConfiguration().get("tmpjars"));
        }

        public package.JobResult await(package.StatusCallback reporter) {
            return super.await(reporter).merge((Function0)new Serializable(this, reporter){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BulkConverterIngest $outer;
                public final package.StatusCallback reporter$1;

                public final Option<package.JobResult> apply() {
                    return this.$outer.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$tempOutput.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ BulkConverterIngest$$anonfun$await$1 $outer;

                        public final package.JobResult apply(Path dir) {
                            package.JobResult jobResult;
                            this.$outer.reporter$1.reset();
                            Configuration conf = new Configuration();
                            conf.set("tmpjars", this.$outer.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$anonfun$$$outer().org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$libjars());
                            package.JobResult jobResult2 = StorageJobUtils$.MODULE$.distCopy(dir, this.$outer.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$anonfun$$$outer().org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$output, this.$outer.reporter$1, conf);
                            if (jobResult2 instanceof package.JobResult$.JobSuccess) {
                                package.JobResult$.JobSuccess jobSuccess = (package.JobResult$.JobSuccess)jobResult2;
                                String message = jobSuccess.message();
                                Map counts = jobSuccess.counts();
                                package.Command$.MODULE$.user().info(message);
                                jobResult = new package.JobResult$.JobSuccess("", counts);
                            } else {
                                jobResult = jobResult2;
                            }
                            return jobResult;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ BulkConverterIngest org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.reporter$1 = reporter$1;
                }
            }).merge((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BulkConverterIngest $outer;

                public final None$ apply() {
                    if (this.$outer.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$$outer().params().skipImport()) {
                        package.Command$.MODULE$.user().info("Skipping import of RFiles into Accumulo");
                        package.Command$.MODULE$.user().info("Files may be imported for each table through the Accumulo shell with the `importdirectory` command");
                    } else {
                        package.Command$.MODULE$.user().info("Importing RFiles into Accumulo");
                        TableOperations tableOps = this.$outer.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$ds.connector().tableOperations();
                        Path filesPath = new Path(this.$outer.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$output, GeoMesaAccumuloFileOutputFormat$.MODULE$.FilesPath());
                        FileContext fc = FileContext.getFileContext((URI)filesPath.toUri(), (Configuration)new Configuration());
                        RemoteIterator files = fc.listLocatedStatus(filesPath);
                        while (files.hasNext()) {
                            LocatedFileStatus file = (LocatedFileStatus)files.next();
                            Path path = file.getPath();
                            String table = path.getName();
                            if (!file.isDirectory() || !HadoopDelegate$.MODULE$.HiddenFileFilter().accept(path) || !tableOps.exists(table)) continue;
                            package.Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Importing ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
                            tableOps.importDirectory(path.toString()).to(table).load();
                        }
                    }
                    return None$.MODULE$;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ AccumuloBulkIngestCommand org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$$outer() {
            return this.$outer;
        }

        public BulkConverterIngest(AccumuloBulkIngestCommand $outer, AccumuloDataStore ds, Map<String, String> dsParams, SimpleFeatureType sft, Config converterConfig, Seq<String> paths, Path output, Option<Path> tempOutput, Option<Object> maxSplitSize, Option<String> index, Option<Seq<String>> partitions, Seq<String> libjarsFiles, Iterator<Function0<Seq<File>>> libjarsPaths2) {
            this.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$ds = ds;
            this.dsParams = dsParams;
            this.sft = sft;
            this.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$output = output;
            this.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$tempOutput = tempOutput;
            this.maxSplitSize = maxSplitSize;
            this.index = index;
            this.partitions = partitions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dsParams, sft, converterConfig, paths, libjarsFiles, libjarsPaths2);
        }
    }

    @Parameters(commandDescription="Convert various file formats into bulk loaded Accumulo RFiles")
    public static class AccumuloBulkIngestParams
    implements IngestCommand.IngestParams,
    AccumuloDataStoreParams,
    OutputPathParam,
    OptionalIndexParam,
    OptionalCqlFilterParam,
    TempPathParam {
        @Parameter(names={"--skip-import"}, description="Generate the files but skip the bulk import into Accumulo")
        private boolean skipImport;
        @Parameter(names={"--temp-path"}, description="Path to temp dir for writing output. Note that this may be useful when using s3 since it is slow as a sink", required=false)
        private String tempPath;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"--output"}, description="Path to use for writing output", required=true)
        private String outputPath;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;
        @Parameter(names={"-t", "--threads"}, description="Number of threads if using local ingest")
        private Integer threads;
        @Parameter(names={"--src-list"}, description="Input files are text files with lists of files, one per line, to ingest.")
        private boolean srcList;
        @Parameter(names={"--no-tracking"}, description="Return immediately after submitting ingest job (distributed jobs)")
        private boolean noWaitForCompletion;
        @Parameter(names={"--combine-inputs"}, description="Combine multiple input files into a single input split (distributed jobs)")
        private boolean combineInputs;
        @Parameter(names={"--split-max-size"}, description="Maximum size of a split in bytes (distributed jobs)")
        private Integer maxSplitSize;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private final Option<Enumeration.Value> mode;
        @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, auto-detection will be attempted")
        private String inputFormat;
        @Parameter(description="<file>...")
        private List<String> files;
        @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter")
        private String config;
        @Parameter(names={"--converter-error-mode"}, description="Override the converter error mode - 'skip-bad-records' or 'raise-errors'", converter=ParameterConverters.ErrorModeConverter.class)
        private Enumeration.Value errorMode;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
        private String spec;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;
        private volatile boolean bitmap$0;

        public String tempPath() {
            return this.tempPath;
        }

        public void tempPath_$eq(String x$1) {
            this.tempPath = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String outputPath() {
            return this.outputPath;
        }

        public void outputPath_$eq(String x$1) {
            this.outputPath = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        @TraitSetter
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        @TraitSetter
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public boolean srcList() {
            return this.srcList;
        }

        public void srcList_$eq(boolean x$1) {
            this.srcList = x$1;
        }

        public boolean noWaitForCompletion() {
            return this.noWaitForCompletion;
        }

        public void noWaitForCompletion_$eq(boolean x$1) {
            this.noWaitForCompletion = x$1;
        }

        public boolean waitForCompletion() {
            return IngestCommand.IngestParams.class.waitForCompletion((IngestCommand.IngestParams)this);
        }

        public boolean combineInputs() {
            return this.combineInputs;
        }

        public void combineInputs_$eq(boolean x$1) {
            this.combineInputs = x$1;
        }

        public Integer maxSplitSize() {
            return this.maxSplitSize;
        }

        public void maxSplitSize_$eq(Integer x$1) {
            this.maxSplitSize = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option mode$lzycompute() {
            AccumuloBulkIngestParams accumuloBulkIngestParams = this;
            synchronized (accumuloBulkIngestParams) {
                if (!this.bitmap$0) {
                    this.mode = DistributedRunParam.class.mode((DistributedRunParam)this);
                    this.bitmap$0 = true;
                }
                return this.mode;
            }
        }

        public Option<Enumeration.Value> mode() {
            return this.bitmap$0 ? this.mode : this.mode$lzycompute();
        }

        public String inputFormat() {
            return this.inputFormat;
        }

        public void inputFormat_$eq(String x$1) {
            this.inputFormat = x$1;
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public String config() {
            return this.config;
        }

        public void config_$eq(String x$1) {
            this.config = x$1;
        }

        public Enumeration.Value errorMode() {
            return this.errorMode;
        }

        public void errorMode_$eq(Enumeration.Value x$1) {
            this.errorMode = x$1;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String spec() {
            return this.spec;
        }

        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public boolean skipImport() {
            return this.skipImport;
        }

        public void skipImport_$eq(boolean x$1) {
            this.skipImport = x$1;
        }

        public AccumuloBulkIngestParams() {
            OptionalTypeNameParam.class.$init$((OptionalTypeNameParam)this);
            OptionalFeatureSpecParam.class.$init$((OptionalFeatureSpecParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ConverterConfigParam.class.$init$((ConverterConfigParam)this);
            InputFilesParam.class.$init$((InputFilesParam)this);
            OptionalInputFormatParam.class.$init$((OptionalInputFormatParam)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            DistributedCombineParam.class.$init$((DistributedCombineParam)this);
            IngestCommand.IngestParams.class.$init$((IngestCommand.IngestParams)this);
            ZookeepersParam$class.$init$(this);
            InstanceNameParams$class.$init$(this);
            PasswordParams.class.$init$((PasswordParams)this);
            CredentialsParams.class.$init$((CredentialsParams)this);
            KerberosParams.class.$init$((KerberosParams)this);
            AccumuloConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
            OutputPathParam.class.$init$((OutputPathParam)this);
            OptionalIndexParam.class.$init$((OptionalIndexParam)this);
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            TempPathParam.class.$init$((TempPathParam)this);
            this.skipImport = false;
        }
    }
}

