/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$AccumuloDistributedCommand$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand$class;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams$class;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam$class;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.jobs.accumulo.AccumuloJobUtils$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaAccumuloInputFormat$;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.NumReducersParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001=\u0011Q#Q2dk6,Hn\\#ya>\u0014HoQ8n[\u0006tGM\u0003\u0002\u0004\t\u00051Q\r\u001f9peRT!!\u0002\u0004\u0002\u000bQ|w\u000e\\:\u000b\u0005\u001dA\u0011\u0001C1dGVlW\u000f\\8\u000b\u0005%Q\u0011aB4f_6,7/\u0019\u0006\u0003\u00171\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001AAB\u0005\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!A.\u00198h\u0015\u0005)\u0012\u0001\u00026bm\u0006L!a\u0006\n\u0003\r=\u0013'.Z2u!\rIBDH\u0007\u00025)\u00111a\u0007\u0006\u0003\u000b!I!!\b\u000e\u0003\u001b\u0015C\bo\u001c:u\u0007>lW.\u00198e!\ty\"%D\u0001!\u0015\t\tc!\u0001\u0003eCR\f\u0017BA\u0012!\u0005E\t5mY;nk2|G)\u0019;b'R|'/\u001a\t\u0003KUr!AJ\u001a\u000f\u0005\u001d\u0012dB\u0001\u00152\u001d\tI\u0003G\u0004\u0002+_9\u00111FL\u0007\u0002Y)\u0011QFD\u0001\u0007yI|w\u000e\u001e \n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u00025\t\u0005A\u0012iY2v[Vdw\u000eR1uCN#xN]3D_6l\u0017M\u001c3\n\u0005Y:$AG!dGVlW\u000f\\8ESN$(/\u001b2vi\u0016$7i\\7nC:$'B\u0001\u001b\u0005\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u0019a\u0014N\\5u}Q\t1\b\u0005\u0002=\u00015\t!\u0001C\u0004?\u0001\t\u0007I\u0011I \u0002\rA\f'/Y7t+\u0005\u0001\u0005CA!R\u001d\t\u0011EI\u0004\u0002'\u0007&\u00111\u0001B\u0004\u0006\u000b\nA\tAR\u0001\u0016\u0003\u000e\u001cW/\\;m_\u0016C\bo\u001c:u\u0007>lW.\u00198e!\tatIB\u0003\u0002\u0005!\u0005\u0001j\u0005\u0002H\u0013B\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n1\u0011I\\=SK\u001aDQ!O$\u0005\u0002A#\u0012A\u0012\u0004\u0005%\u001e\u00031K\u0001\u000bBG\u000e,X.\u001e7p\u000bb\u0004xN\u001d;QCJ\fWn]\n\u0007#&#vlY4\u0011\u0005UcfB\u0001,[\u001d\t9\u0016L\u0004\u0002)1&\u0011Q\u0001C\u0005\u0003\u0007mI!a\u0017\u000e\u0002\u001b\u0015C\bo\u001c:u\u0007>lW.\u00198e\u0013\tifL\u0001\u0007FqB|'\u000f\u001e)be\u0006l7O\u0003\u0002\\5A\u0011\u0001-Y\u0007\u0002\t%\u0011!\r\u0002\u0002\u0018\u0003\u000e\u001cW/\\;m_\u0012\u000bG/Y*u_J,\u0007+\u0019:b[N\u0004\"\u0001Z3\u000e\u0003mI!AZ\u000e\u0003+I+\u0017/^5sK\u0012$\u0016\u0010]3OC6,\u0007+\u0019:b[B\u0011A\r[\u0005\u0003Sn\u0011!c\u00149uS>t\u0017\r\\%oI\u0016D\b+\u0019:b[\")\u0011(\u0015C\u0001WR\tA\u000e\u0005\u0002n#6\tq\t\u000b\u0003R_fT\bC\u00019x\u001b\u0005\t(B\u0001:t\u0003)Q7m\\7nC:$WM\u001d\u0006\u0003iV\fQAY3vgRT\u0011A^\u0001\u0004G>l\u0017B\u0001=r\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0013G>lW.\u00198e\t\u0016\u001c8M]5qi&|g.I\u0001|\u0003%*\u0005\u0010]8si\u00022W-\u0019;ve\u0016\u001c\bE\u001a:p[\u0002\n\u0007eR3p\u001b\u0016\u001c\u0018\r\t3bi\u0006\u00043\u000f^8sK\"1Q\u0010\u0001Q\u0001\n\u0001\u000bq\u0001]1sC6\u001c\b\u0005\u0003\u0004\u0000\u0001\u0011E\u0013\u0011A\u0001\nG>tg-[4ve\u0016$\u0002\"a\u0001\u0002\n\u0005\u0005\u0012Q\u0005\t\u0004\u0015\u0006\u0015\u0011bAA\u0004\u0017\n!QK\\5u\u0011\u001d\tYA a\u0001\u0003\u001b\t1A[8c!\u0011\ty!!\b\u000e\u0005\u0005E!\u0002BA\n\u0003+\t\u0011\"\\1qe\u0016$WoY3\u000b\t\u0005]\u0011\u0011D\u0001\u0007Q\u0006$wn\u001c9\u000b\u0007\u0005mA\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003?\t\tBA\u0002K_\nDa!a\t\u007f\u0001\u0004q\u0012A\u00013t\u0011\u001d\t9C a\u0001\u0003S\tQ!];fef\u0004B!a\u000b\u000245\u0011\u0011Q\u0006\u0006\u0004C\u0005=\"bAA\u0019\u0019\u0005Aq-Z8u_>d7/\u0003\u0003\u00026\u00055\"!B)vKJL\b")
public class AccumuloExportCommand
implements ExportCommand<AccumuloDataStore>,
AccumuloDataStoreCommand.AccumuloDistributedCommand {
    private final AccumuloExportParams params;
    private final String name;
    private final Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ Seq org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$AccumuloDistributedCommand$$super$libjarsFiles() {
        return ExportCommand.class.libjarsFiles((ExportCommand)this);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$AccumuloDistributedCommand$$super$libjarsPaths() {
        return package.DistributedCommand.class.libjarsPaths((package.DistributedCommand)this);
    }

    @Override
    public Seq<String> libjarsFiles() {
        return AccumuloDataStoreCommand$AccumuloDistributedCommand$class.libjarsFiles(this);
    }

    @Override
    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return AccumuloDataStoreCommand$AccumuloDistributedCommand$class.libjarsPaths(this);
    }

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return AccumuloDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds, Query query, FeatureExporter exporter, boolean writeEmptyFiles) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds, (Query)query, (FeatureExporter)exporter, (boolean)writeEmptyFiles);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        AccumuloExportCommand accumuloExportCommand = this;
        synchronized (accumuloExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return package.InteractiveCommand.class.console((package.InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        package.InteractiveCommand.class.setConsole((package.InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.class.withDataStore((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.class.loadDataStore((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.class.subCommands((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.class.validate((package.Command)this);
    }

    public void run() {
        package.Command.class.run((package.Command)this);
    }

    @Override
    public AccumuloExportParams params() {
        return this.params;
    }

    public void configure(Job job, AccumuloDataStore ds, Query query) {
        GeoMesaAccumuloInputFormat$.MODULE$.configure(job, (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.connection()).asJava(), AccumuloJobUtils$.MODULE$.getSingleQueryPlan(ds, query));
    }

    public AccumuloExportCommand() {
        package.Command.class.$init$((package.Command)this);
        package.DataStoreCommand.class.$init$((package.DataStoreCommand)this);
        package.DistributedCommand.class.$init$((package.DistributedCommand)this);
        package.InteractiveCommand.class.$init$((package.InteractiveCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        AccumuloDataStoreCommand$class.$init$(this);
        AccumuloDataStoreCommand$AccumuloDistributedCommand$class.$init$(this);
        this.params = new AccumuloExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class AccumuloExportParams
    implements ExportCommand.ExportParams,
    AccumuloDataStoreParams,
    RequiredTypeNameParam,
    OptionalIndexParam {
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"--suppress-empty"}, description="Suppress all output (headers, etc) if there are no features exported")
        private boolean suppressEmpty;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private final ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed jobs)", validateWith={PositiveInteger.class})
        private Integer reducers;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private final Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        @TraitSetter
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        @TraitSetter
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public boolean suppressEmpty() {
            return this.suppressEmpty;
        }

        public void suppressEmpty_$eq(boolean x$1) {
            this.suppressEmpty = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            AccumuloExportParams accumuloExportParams = this;
            synchronized (accumuloExportParams) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.class.outputFormat((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.outputFormat;
            }
        }

        public ExportFormat outputFormat() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.outputFormat$lzycompute() : this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option mode$lzycompute() {
            AccumuloExportParams accumuloExportParams = this;
            synchronized (accumuloExportParams) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.class.mode((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.mode;
            }
        }

        public Option<Enumeration.Value> mode() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.mode$lzycompute() : this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public AccumuloExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            NumReducersParam.class.$init$((NumReducersParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            ZookeepersParam$class.$init$(this);
            InstanceNameParams$class.$init$(this);
            PasswordParams.class.$init$((PasswordParams)this);
            CredentialsParams.class.$init$((CredentialsParams)this);
            KerberosParams.class.$init$((KerberosParams)this);
            AccumuloConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.class.$init$((OptionalIndexParam)this);
        }
    }
}

